//
//  CMRThreadsList.h
//  BathyScaphe
//
//  Updated by Tsutomu Sawada on 10/01/05.
//  Copyright 2005-2010 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import <Cocoa/Cocoa.h>
#import "CocoMonar_Prefix.h"

@class CMRThreadLayout;
@class CMRThreadSignature;

enum {
    kValueTemplateDefaultType,
    kValueTemplateNewArrivalType,
    kValueTemplateNewUnknownType,
    kValueTemplateDatOchiType // Available in Starlight Breaker.
};

@interface CMRThreadsList : NSObject<NSTableViewDelegate, NSTableViewDataSource>
{
    CMRThreadLayout *_worker;

    NSArray *_threads;
    NSArray *_filteredThreads;
}
/**
  * 
  * 読み込みを開始。
  * 初期化したクラスは直後に呼び出すこと。
  * workerを保持する。
  * 
  */
- (void)startLoadingThreadsList:(CMRThreadLayout *)worker;
- (void)doLoadThreadsList:(CMRThreadLayout *)worker;
- (CMRThreadLayout *)worker;
- (void)setWorker:(CMRThreadLayout *)aWorker;

- (BOOL)isFavorites;
- (BOOL)isSmartItem;
- (BOOL)isBoard; // Available in Tenori Tiger.

- (void)rebuildThreadsList; // Available in Tenori Tiger.
@end


@interface CMRThreadsList(CleanUp)
- (void)cleanUpItemsToBeRemoved:(NSArray *)files;

// Available in BathyScaphe 1.6.2 and later.
//- (BOOL)tableView:(NSTableView *)tableView removeFilesAtRowIndexes:(NSIndexSet *)rowIndexes ask:(BOOL)flag;

- (BOOL)tableView:(NSTableView *)tableView removeFiles:(NSArray *)files;
- (BOOL)removeDatochiFiles;
@end


@interface CMRThreadsList(AccessingList)
- (NSArray *)threads;
- (void)setThreads:(NSArray *)aThreads;
- (NSArray *)filteredThreads;
- (void)setFilteredThreads:(NSArray *)aFilteredThreads;
@end

 
@interface CMRThreadsList(Attributes)
- (NSString *)boardName;
- (NSURL *)boardURL;

- (NSUInteger)numberOfThreads;
- (NSUInteger)numberOfFilteredThreads;
@end


@interface CMRThreadsList(Filter)
// Available in MeteorSweeper.
- (BOOL)filterByString:(NSString *)searchString;
@end


@interface CMRThreadsList(DataSource)
+ (void)resetDataSourceTemplates;
+ (void)resetDataSourceTemplateForColumnIdentifier:(NSString *)identifier width:(CGFloat)loc;
+ (void)resetDataSourceTemplateForDateColumn;

+ (NSDictionary *)threadCreatedDateAttrTemplate;
+ (NSDictionary *)threadModifiedDateAttrTemplate;
+ (NSDictionary *)threadLastWrittenDateAttrTemplate;

+ (id)objectValueTemplate:(id)aValue forType:(NSInteger)aType;

- (NSString *)threadFilePathAtRowIndex:(NSInteger)rowIndex inTableView:(NSTableView *)tableView status:(ThreadStatus *)status;
- (NSDictionary *)threadAttributesAtRowIndex:(NSInteger)rowIndex inTableView:(NSTableView *)tableView;
- (NSString *)threadTitleAtRowIndex:(NSInteger)rowIndex inTableView:(NSTableView *)tableView;
// Available in BathyScaphe 2.0 "Final Moratorium" and later.
- (NSUInteger)threadLabelAtRowIndex:(NSInteger)rowIndex inTableView:(NSTableView *)tableView;
- (BOOL)isThreadLogCachedAtRowIndex:(NSInteger)rowIndex inTableView:(NSTableView *)tableView label:(NSUInteger *)label;
- (BOOL)isThreadLogCachedAtRowIndex:(NSInteger)rowIndex inTableView:(NSTableView *)tableView isDatOchi:(BOOL *)datOchiFlag;

- (CMRThreadSignature *)threadSignatureWithTitle:(NSString *)title; // Available in SilverGull and later.

- (NSUInteger)indexOfThreadWithPath:(NSString *)filepath;
- (NSUInteger)indexOfThreadWithPath:(NSString *)filepath ignoreFilter:(BOOL)ignores; // Available in BathyScaphe 1.6.2 and later.
- (NSIndexSet *)indexesOfFilePathsArray:(NSArray *)filepaths ignoreFilter:(BOOL)flag; // Available in BathyScaphe 1.6.3 "Hinagiku" and later.

- (NSArray *)tableView:(NSTableView *)aTableView threadFilePathsArrayAtRowIndexes:(NSIndexSet *)rowIndexes;
- (NSArray *)tableView:(NSTableView *)aTableView threadAttibutesArrayAtRowIndexes:(NSIndexSet *)rowIndexes exceptingPath:(NSString *)filepath;

- (void)tableView:(NSTableView *)aTableView revealFilesAtRowIndexes:(NSIndexSet *)rowIndexes;
- (void)tableView:(NSTableView *)aTableView quickLookAtRowIndexes:(NSIndexSet *)rowIndexes keepLook:(BOOL)flag; // Available in Tenori Tiger.
- (void)tableView:(NSTableView *)aTableView openURLsAtRowIndexes:(NSIndexSet *)rowIndexes;
// Available in BathyScaphe 1.7 "Prima Aspalas" and later.
- (void)tableView:(NSTableView *)aTableView removeFromDBAtRowIndexes:(NSIndexSet *)rowIndexes;
// Available in BathyScaphe 2.0 "Final Moratorium" and later.
- (void)tableView:(NSTableView *)aTableView setLabel:(NSUInteger)label atRowIndexes:(NSIndexSet *)rowIndexes;
- (void)tableView:(NSTableView *)aTableView setIsDatOchi:(BOOL)flag atRowIndexes:(NSIndexSet *)rowIndexes;
@end


@interface CMRThreadsList(DraggingImage)
- (NSImage *)dragImageForRowIndexes:(NSIndexSet *)rowIndexes inTableView:(NSTableView *)tableView offset:(NSPointPointer)dragImageOffset;
@end


@interface CMRThreadsList(Download)
- (void)downloadThreadsList;
@end


@interface CMRThreadsList(ListImport)
+ (NSMutableDictionary *)attributesForThreadsListWithContentsOfFile:(NSString *)path;
@end

// Notification
extern NSString *const CMRThreadsListDidChangeNotification;
