//
//  BSKFSplitView.m
//  BathyScaphe
//
//  Updated by Tsutomu Sawada on 10/03/09.
//  Copyright 2005-2010 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "BSKFSplitView.h"
#import "NSImage-SGExtensions.h"

@implementation BSKFSplitView
static NSRect	bSRect;
static NSRect	bSDimRect;
static NSRect	bSVerRect;
static NSRect	bSDimVerRect;

#pragma mark Private Accessors
- (NSImage *)splitterBg
{
	if (!bskf_isSnowLeopard && !_splitterBg) {
		_splitterBg = [[NSImage imageNamed:@"browserSplitter" loadFromBundle:[NSBundle bundleForClass:[self class]]] retain];
		bSRect = NSMakeRect(0, 0, 1, 10);
		[_splitterBg setFlipped:[self isFlipped]];
	}
	return _splitterBg;
}

- (NSImage *)splitterDimple
{
	if (!bskf_isSnowLeopard && !_splitterDimple) {
		_splitterDimple = [[NSImage imageNamed:@"browserSplitterDimple" loadFromBundle:[NSBundle bundleForClass:[self class]]] retain];
		bSDimRect = NSMakeRect(0, 0, 8, 10);
		[_splitterDimple setFlipped:[self isFlipped]];
	}
	return _splitterDimple;
}

- (NSImage *)splitterBgVertical
{
	if (!bskf_isSnowLeopard && !_splitterBgVertical) {
		_splitterBgVertical = [[NSImage imageNamed:@"browserSplitterVertical" loadFromBundle:[NSBundle bundleForClass:[self class]]] retain];
		bSVerRect = NSMakeRect(0, 0, 10, 1);
		[_splitterBgVertical setFlipped:[self isFlipped]];
	}
	return _splitterBgVertical;
}

- (NSImage *)splitterDimpleVertical
{
	if (!bskf_isSnowLeopard && !_splitterDimpleVertical) {
		_splitterDimpleVertical = [[NSImage imageNamed:@"browserSplitterDimpleVertical" loadFromBundle:[NSBundle bundleForClass:[self class]]] retain];
		bSDimVerRect = NSMakeRect(0, 0, 10, 8);
		[_splitterDimpleVertical setFlipped:[self isFlipped]];
	}
	return _splitterDimpleVertical;
}

- (void)detectAppKitVersion
{
    if (floor(NSAppKitVersionNumber) > 949) { // NSAppKitVersionNumber10_5
        bskf_isSnowLeopard = YES;
    } else {
        bskf_isSnowLeopard = NO;
    }
}

#pragma mark Override
- (void)kfSetupResizeCursors
{
	// Mac OS X 10.3 以降なので、より適切なカーソルを使用することができる。
    if (!kfIsVerticalResizeCursor) {
        kfIsVerticalResizeCursor = [[NSCursor resizeLeftRightCursor] retain];
    }
    if (!kfNotIsVerticalResizeCursor) {
        kfNotIsVerticalResizeCursor = [[NSCursor resizeUpDownCursor] retain];
    }
}

- (CGFloat)dividerThickness
{
	return bskf_isSnowLeopard ? [super dividerThickness] : 10;
}

- (NSSplitViewDividerStyle)dividerStyle
{
    return bskf_isSnowLeopard ? 3 : NSSplitViewDividerStyleThick; // 3 = NSSplitViewDividerStylePaneSplitter
}

- (void)drawDividerInRect:(NSRect)aRect
{
    if (bskf_isSnowLeopard) {
        [super drawDividerInRect:aRect];
        return;
    }

	if (![self isVertical]) {
		CGFloat dX;
		[[self splitterBg] drawInRect:aRect fromRect:bSRect operation:NSCompositeCopy fraction:1];
		
		dX = floor((NSWidth(aRect) - 8) * 0.5);
		[[self splitterDimple] drawInRect:NSMakeRect(aRect.origin.x+dX, aRect.origin.y, 8, 10)
								 fromRect:bSDimRect
								operation:NSCompositeCopy
								 fraction:1];
	} else {
		CGFloat dY;
		[[self splitterBgVertical] drawInRect:aRect fromRect:bSVerRect operation:NSCompositeCopy fraction:1];

		dY = floor((NSHeight(aRect) - 8) * 0.5);
		[[self splitterDimpleVertical] drawInRect:NSMakeRect(aRect.origin.x, aRect.origin.y+dY, 10, 8)
										 fromRect:bSDimVerRect
										operation:NSCompositeCopy
										 fraction:1];
	}
}

- (id)initWithFrame:(NSRect)frameRect
{
    if (self = [super initWithFrame:frameRect]) {
        [self detectAppKitVersion];
    }
    return self;
}

- (id)initWithCoder:(NSCoder *)coder
{
    if (self = [super initWithCoder:coder]) {
        [self detectAppKitVersion];
    }
    return self;
}

- (void)dealloc
{
	[_splitterBg release];
	[_splitterDimple release];
	[_splitterBgVertical release];
	[_splitterDimpleVertical release];
	
	[super dealloc];
}
@end
