//:CMRThreadsUpdateListTask.m
/**
  *
  * @see CMRThreadAttributes.h
  * @see CMRThreadsList.h
  * @see CMRThreadLayout.h
  *
  * @author Takanori Ishikawa
  * @author http://www15.big.or.jp/~takanori/
  * @version 1.0.0d1 (03/01/19  2:59:02 AM)
  *
  */
#import "CMRThreadsUpdateListTask_p.h"
#import "CMRFavoritesManager.h"
#import "BSDBThreadList.h"

//////////////////////////////////////////////////////////////////////
////////////////////// [ 萔}Nu ] //////////////////////////
//////////////////////////////////////////////////////////////////////
NSString *const CMRThreadsUpdateListTaskDidFinishNotification = @"CMRThreadsUpdateListTaskDidFinishNotification";



/**
  * [֐]setAttributesFromDictionary
  *
  * Xbh̏WĒǉB
  * 
  * @param    dict     
  * @param    thread   Xbh̏i[鎫
  * @return            W
  */
static void setAttributesFromDictionary(
                    NSDictionary        *dict,
                    NSMutableDictionary    *thread)
{
	static NSString * keys[] = {
						nil,
						nil,
						nil,
						nil,
						nil,
						nil,
						nil };

	if (keys[0] == nil) {
		keys[0] = CMRThreadCreatedDateKey;
		keys[1] = CMRThreadModifiedDateKey;
		keys[2] = CMRThreadLastLoadedNumberKey;
		keys[3] = CMRThreadStatusKey;
		keys[4] = ThreadPlistBoardNameKey;
		keys[5] = ThreadPlistIdentifierKey;
		keys[6] = nil;
	}
    NSString **p;
    
    for (p = keys; *p != nil; p++) {
        [thread setNoneNil : [dict objectForKey : *p]
                    forKey : *p];
    }
}
/**
  * [֐]collectAttributesFromPath
  *
  * Xbh̏WĒǉB
  * 
  * @param    path     Ot@C̃pX
  * @param    thread   Xbh̏i[鎫
  * @return            W
  */
static void collectAttributesFromPath(NSString *path, NSMutableDictionary *thread)
{
    NSDictionary *fileContents_;
    
    UTILDebugWrite(@"Collect Attributes From Log File");
    
    // Ot@Ce擾
    fileContents_ = 
        [BSDBThreadList attributesForThreadsListWithContentsOfFile : path];
    
    if (nil != fileContents_)
        setAttributesFromDictionary(fileContents_, thread);
    
    [thread setObject : path
               forKey : CMRThreadLogFilepathKey];
}

static void constructAttributesByAppendingCachedInfo(
                    NSMutableDictionary *thread,
                    NSMutableDictionary *cachedInfoTbl,
                    BOOL                 isUpdated)
{
    NSString *path_;
    id        cache;
    NSNumber *count_;
    NSNumber *status_;
    unsigned s;
    
    struct {
        unsigned char cacheIsNull  :1;
        unsigned char reserved     :7;
    } flags;
    
    
    path_ = [CMRThreadAttributes pathFromDictionary : thread];
    UTILCAssertNotNil(path_);
    
    cache = [cachedInfoTbl objectForKey : path_];
    flags.cacheIsNull = [cache isEqual : [NSNull null]];
    if (isUpdated && cache != nil && !flags.cacheIsNull) {
        // XVƂAXVȌ񂪑݂B
        // XVȌpB
        setAttributesFromDictionary(cache, thread);
    }
    
    count_  = [thread objectForKey : CMRThreadLastLoadedNumberKey];
    status_ = [thread objectForKey : CMRThreadStatusKey];
    s = [status_ unsignedIntValue];
    if (nil == status_ || nil == count_) {
        if (status_ == nil || !(s & ThreadNoCacheStatus)) {
            NSFileManager *fm = [NSFileManager defaultManager];
            if ([fm fileExistsAtPath : path_]) {
                collectAttributesFromPath(path_, thread);
                count_ = [thread objectForKey : CMRThreadLastLoadedNumberKey];
                s = ThreadLogCachedStatus;
                goto RECACHE;
            }
        }
        [thread removeObjectForKey : CMRThreadLastLoadedNumberKey];
        count_ = nil;
        s = ThreadNoCacheStatus;
    }
RECACHE:
    
    // Xe[^XČB
    // vZAݒB
    if (count_ != nil) {
        NSNumber    *newcount_;
        newcount_ = [thread objectForKey : CMRThreadNumberOfMessagesKey];
        
        // T[õX̕΁A
        if (newcount_ != nil && 
           NSOrderedDescending == [newcount_ compare : count_]) {
            if(s != ThreadHeadModifiedStatus)s = ThreadUpdatedStatus;
        }
    }
    // VKXbhǂ𔻒肷B
    // łɈꗗɊ܂܂ĂXbhɂ
    // O݂ȂĂNSNullݒ肳ĂB
    if (isUpdated && nil == cache) s = ThreadNewCreatedStatus;
    
    if (nil == status_ || [status_ unsignedIntValue] != s) {
        // Xe[^Xݒ
        [thread setObject : [NSNumber numberWithUnsignedInt : s]
                   forKey : CMRThreadStatusKey];
    }
    
    // XbhXVB
    // Ȏ݂ȂXbhɂNSNullݒ
    if (s & ThreadNoCacheStatus) {
		// 2005-11-25  if vbNOėlq
        //if (cache == nil) {
            [cachedInfoTbl setObject:[NSNull null] forKey:path_];
        //}
	} else if (isUpdated && (s == ThreadUpdatedStatus)) {
		// CɓɊ܂܂ĂȂT
		// V̊X݂̂ɂĒׂΗǂB
		//  subject.txt ĂčXVꍇ̂ݒׂΗǂB
		CMRFavoritesManager	*fm_ = [CMRFavoritesManager defaultManager];
		int	favidx_;
		favidx_ = [[fm_ favoritesItemsIndex] indexOfObject : path_];
		if (favidx_ != NSNotFound) {
			// Cɓ̃f[^XV
			[[fm_ favoritesItemsArray] replaceObjectAtIndex : favidx_
												 withObject : thread];
		}

        [cachedInfoTbl setObject:thread forKey:path_];

    } else {
        [cachedInfoTbl setObject:thread forKey:path_];
    }
}


@implementation CMRThreadsUpdateListTask
+ (id) taskWithLoadedList : (NSMutableArray      *) loadedList
              pathMapping : (NSMutableDictionary *) table
                   update : (BOOL                 ) isUpdated
{
    return [[[self alloc] initWithLoadedList : loadedList
                      pathMapping : table
                           update : isUpdated] autorelease];
}
- (id) initWithLoadedList : (NSMutableArray      *) loadedList
              pathMapping : (NSMutableDictionary *) table
                   update : (BOOL                 ) isUpdated
{
    UTILAssertNotNilArgument(table, @"table");
    if (self = [super init]) {
        
        [self setIsUpdate : isUpdated];
        [self setPathMappingTbl : table];
        [self setProgress : 0];
        [self setThreadsArray : loadedList];
    }
    return self;
}
- (void) dealloc
{
    [_boardName release];
    [_threadsArray release];
    [_pathMappingTbl release];
    [super dealloc];
}


- (void) doExecuteWithLayout : (CMRThreadLayout *) layout
{
    NSDictionary    *userInfo_;
    NSMutableArray  *threadsArray_;
    
    threadsArray_ = [self threadsArray];
    UTILAssertNotNil(threadsArray_);
    
    [self addParameterForThreadsList : threadsArray_
                            fromInfo : _pathMappingTbl
                              update : _isUpdate];
    userInfo_ = [NSDictionary dictionaryWithObjectsAndKeys :
                    threadsArray_,   kCMRUserInfoThreadsArrayKey, 
                    _pathMappingTbl, kCMRUserInfoThreadsDictKey,
                    [NSNumber numberWithBool : _isUpdate],
                    kCMRUserInfoIsUpdatedKey,
                    nil];
    
    [CMRMainMessenger postNotificationName : CMRThreadsUpdateListTaskDidFinishNotification
                                    object : self
                                  userInfo : userInfo_];
    
}



- (NSString *) boardName
{
    return _boardName;
}
- (void) setBoardName : (NSString *) aBoardName
{
    id        tmp;
    
    tmp = _boardName;
    _boardName = [aBoardName retain];
    [tmp release];
}


// CMRTask:
- (NSString *) title
{
    NSString        *format_;
    NSString        *name_;
    
    name_ = [self boardName];
    format_ = [self localizedString : @"Converting List Title"];
    
    return [NSString stringWithFormat : 
                        format_ ? format_ : @"%@",
                        name_ ? name_ : @""];
}
- (NSString *) messageInProgress
{
    NSString        *format_;
    NSString        *title_;
    
    title_ = [self title];
    format_ = [self localizedString : @"Converting List Message"];
    
    return [NSString stringWithFormat : 
                        format_ ? format_ : @"%@",
                        title_ ? title_ : @""];
}
- (double) amount
{
    if ([self progress] <= 0)
        return -1;
    
    return [self progress];
}
@end



@implementation CMRThreadsUpdateListTask(Private)
- (void) addParameterForThreadsList : (NSArray             *) loadedList
                           fromInfo : (NSMutableDictionary *) threadsInfo
                             update : (BOOL                 ) isUpdated
{
    NSEnumerator        *iter;
    NSMutableDictionary *thread_;
    
    unsigned nEnded_ = 0;
    unsigned nElem_  = [loadedList count];

    UTILAssertNotNilArgument(loadedList, @"Threads List Array");
    UTILAssertNotNilArgument(threadsInfo, @"Threads Info Dictionary");
	
	NSAutoreleasePool	*pool_ = [[NSAutoreleasePool alloc] init];

    iter = [loadedList objectEnumerator];
    while (thread_ = [iter nextObject]) {
        UTILAssertKindOfClass(thread_, NSMutableDictionary);
        
        constructAttributesByAppendingCachedInfo(thread_, threadsInfo, isUpdated);

        nEnded_++;
        [self setProgress : (((double)nEnded_ / (double)nElem_) * 100)];
    }
	
	[pool_ release];
}



- (NSMutableArray *) threadsArray
{
    return _threadsArray;
}
- (NSMutableDictionary *) pathMappingTbl
{
    return _pathMappingTbl;
}
- (BOOL) isUpdate
{
    return _isUpdate;
}
- (void) setThreadsArray : (NSMutableArray *) aThreadsArray
{
    id        tmp;
    
    tmp = _threadsArray;
    _threadsArray = [aThreadsArray retain];
    [tmp release];
}
- (void) setPathMappingTbl : (NSMutableDictionary *) aPathMappingTbl
{
    id        tmp;
    
    tmp = _pathMappingTbl;
    _pathMappingTbl = [aPathMappingTbl retain];
    [tmp release];
}
- (void) setIsUpdate : (BOOL) anIsUpdate
{
    _isUpdate = anIsUpdate;
}

- (unsigned) progress
{
    return _progress;
}
- (void) setProgress : (unsigned) newValue
{
    _progress = newValue;
}
@end
