//
//  BSThreadListItem.m
//  BathyScaphe
//
//  Created by Hori,Masaki on 07/03/18.
//  Copyright 2007-2011 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "BSThreadListItem.h"


#import "CMRThreadSignature.h"
#import "DatabaseManager.h"
#import "CMRDocumentFileManager.h"
#import <SGAppKit/NSImage-SGExtensions.h>
#import "CMRThreadAttributes.h"

static inline BOOL searchBoardIDAndThreadIDFromFilePath( NSUInteger *outBoardID, NSString **outThreadID, NSString *inFilePath );
static inline NSImage *_statusImageWithStatusBSDB(ThreadStatus s);
static inline NSArray *dateTypeKeys();
static inline NSArray *numberTypeKeys();
//static inline NSArray *threadListIdentifiers();
static inline BSThreadListItem *itemFromRow(id <SQLiteRow> row);

static NSString *const BSThreadListItemErrorDomain = @"BSThreadListItemErrorDomain";
#define BSThreadListItemClassMismatchError	1
#define BSThreadListItemStatusMismatchError	2


@implementation BSThreadListItem

@dynamic identifier, threadName, boardID, boardName;
@dynamic threadFilePath, status, responseNumber, readNumber;
@dynamic delta, creationDate, modifiedDate, lastWrittenDate;
@dynamic isDatOchi, datOchi, label;
@dynamic threadNumber, attribute;

#pragma mark NSPasteboardWriting
- (NSArray *)writableTypesForPasteboard:(NSPasteboard *)pasteboard
{
    if ([self status] & ThreadLogCachedStatus) {
        return [NSArray arrayWithObjects:BSPasteboardTypeThreadSignature, (NSString *)kUTTypeURL, NSPasteboardTypeString, (NSString *)kUTTypeFileURL, nil];
    }
    return [NSArray arrayWithObjects:BSPasteboardTypeThreadSignature, (NSString *)kUTTypeURL, NSPasteboardTypeString, nil];
}

- (id)pasteboardPropertyListForType:(NSString *)type
{
    if ([type isEqualToString:BSPasteboardTypeThreadSignature]) {
        return [[CMRThreadSignature threadSignatureWithIdentifier:[self identifier] boardName:[self boardName]] pasteboardPropertyListForType:type];
    } else if ([type isEqualToString:NSPasteboardTypeString]) {
        return [NSString stringWithFormat:@"%@\n%@", [self threadName], [CMRThreadAttributes threadURLWithBoardID:[self boardID] datIdentifier:[self identifier]]];
    } else if ([type isEqualToString:(NSString *)kUTTypeFileURL]) {
        return [[NSURL fileURLWithPath:[self threadFilePath]] pasteboardPropertyListForType:(NSString *)kUTTypeFileURL];
    } else if ([type isEqualToString:(NSString *)kUTTypeURL]) {
        return [[CMRThreadAttributes threadURLWithBoardID:[self boardID] datIdentifier:[self identifier]] pasteboardPropertyListForType:(NSString *)kUTTypeURL];
    }
    return nil;
}

- (NSPasteboardWritingOptions)writingOptionsForType:(NSString *)type pasteboard:(NSPasteboard *)pasteboard
{
    return 0;
}
@end
