//
//  BoardBoardListItem.m
//  BathyScaphe
//
//  Created by Hori,Masaki on 05/07/17.
//  Copyright 2005-2011 BathyScaphe Project. All rights reserved.
//

#import "BoardBoardListItem.h"

#import "CMRBBSListTemplateKeys.h"
#import <SGAppKit/NSImage-SGExtensions.h>
#import "BSCoreDataManager.h"
#import "AppDefaults.h"


@interface BoardBoardListItem(Private)
@end

@implementation BoardBoardListItem

+ (id) boardBoardListWithBoardID:(NSUInteger) inBoardID
{
	return [[[self alloc] initWithBoardID:inBoardID] autorelease];
}


- (id) initWithBoardID:(NSUInteger) inBoardID
{
	[super init];
	[self setBoardID:inBoardID];
	
	return self;
}
- (id) initWithURLString:(NSString *) urlString
{
	BSCoreDataManager *cdm = [BSCoreDataManager defaultManager];
	NSNumber *aBoardID = [cdm boardIDFromBoardURL:urlString];
	
	if(!aBoardID) {
		[self release];
		return nil;
	}
	
	return [self initWithBoardID:[aBoardID unsignedIntegerValue]];
}

- (void) dealloc
{
	[representName release];
	[boardIDValue release];
	
	[super dealloc];
}

- (id) description
{
	return [[self plist] description];
}
- (id) plist
{
	id dict;
	id url;
	id repName;
	
	dict = [[NSMutableDictionary alloc] initWithObjectsAndKeys:[self name], BoardPlistNameKey, nil];
	
	url = [[self url] absoluteString];
	UTILAssertNotNil(url);
	[dict setObject:url forKey:BoardPlistURLKey];
	
	if((repName = [self representName])) {
		[dict setObject:repName forKey:@"RepresentName"];
	}
	
	return [dict autorelease];
}

#pragma mark## CMRPropertyListCoding protocol ##
- (id) propertyListRepresentation
{
	id result;
	
	result = [NSMutableDictionary dictionaryWithObject:[NSNumber numberWithUnsignedInteger:[self boardID]]
												forKey:@"BoardID"];
	if (representName) {
		[result setObject:representName
				   forKey:@"RepresentName"];
	}
	
	return result;
}
- (id) initWithPropertyListRepresentation:(id) rep
{
	id result;
	id repname;
	
	if ([rep isKindOfClass: [NSNumber class]]) {
		return [self initWithBoardID: [rep unsignedIntegerValue]];
	}
	
	result = [self initWithBoardID: [[rep objectForKey: @"BoardID"] unsignedIntegerValue]];
	
	repname = [rep objectForKey: @"RepresentName"];
	if (repname) {
		[result setRepresentName: repname];
	}
	
	return result;
}
- (BOOL) isHistoryEqual: (id) anObject
{
	if (![super isHistoryEqual: anObject]) return NO;

	if ([anObject boardID] == [self boardID]) return YES;
	
	return NO;
}

- (NSImage *)icon
{
	return [NSImage imageAppNamed:[self iconBaseName]];
}

- (NSString *) name
{
	BSCoreDataManager *cdm = [BSCoreDataManager defaultManager];
	return [cdm boardNameFromBoardID:boardIDValue];
}
/*
- (void) setName: (NSString *) name
{
	NSString *currentName = self.name;
	
	if ([currentName isEqualTo: name]) return;
	
#warning #### MUST check oneTimeEditor ; this method never use.
	BSCoreDataManager *cdm = [BSCoreDataManager oneTimeEditor];
	[cdm setName:name toBoardID:boardIDValue];
}
 */

- (NSString *) representName
{
	if (representName) {
		return representName;
	}
	
	return [self name];
}
- (void) setRepresentName: (NSString *) name
{
	id temp = representName;
	
	representName = [name copy];
	[temp release];
}

- (NSArray *)items
{
	BSCoreDataManager *cdm = [BSCoreDataManager defaultManager];
//	[cdm refresh];
	
	if([CMRPref threadsListViewMode] == BSThreadsListShowsLiveThreads) {
		return [cdm threadInfoWithBoardID:boardIDValue];
	}
	if([CMRPref threadsListViewMode] == BSThreadsListShowsStoredLogFiles) {
		return [cdm cachedThreadInfoWithBoardID:boardIDValue];
	}
	return nil;
}

- (BOOL) hasURL
{
	return YES;
}
- (NSURL *) url
{
	BSCoreDataManager *cdm = [BSCoreDataManager defaultManager];
	NSString *urlStrin = [cdm urlStringFromBoardID:boardIDValue];
	
	return [NSURL URLWithString:urlStrin];
}
- (void) setURLString: (NSString *) urlString
{
	BSCoreDataManager *cdm = [BSCoreDataManager oneTimeEditor];
	[cdm setURLString:urlString toBoardID:boardIDValue];
}

- (NSUInteger) boardID
{
	return boardID;
}
- (void) setBoardID: (NSUInteger) newBoardID
{
	boardID = newBoardID;
	
	[boardIDValue autorelease];
	boardIDValue = [[NSNumber numberWithInteger:newBoardID] retain];
}

#pragma mark NSPasteboardWriting
- (NSArray *)writableTypesForPasteboard:(NSPasteboard *)pasteboard
{
    static NSArray *cachedTypes = nil;
    if (!cachedTypes) {
        cachedTypes = [[NSArray alloc] initWithObjects:BSPasteboardTypeBoardListItem, (NSString *)kUTTypeURL, NSPasteboardTypeString, nil];
    }
    return cachedTypes;
}

- (id)pasteboardPropertyListForType:(NSString *)type
{
    if ([type isEqualToString:BSPasteboardTypeBoardListItem]) {
        return [self plist];
    } else if ([type isEqualToString:(NSString *)kUTTypeURL]) {
        return [[self url] pasteboardPropertyListForType:(NSString *)kUTTypeURL];
    } else if ([type isEqualToString:NSPasteboardTypeString]) {
        return [NSString stringWithFormat:@"%@\n%@", [self representName], [[self url] absoluteString]];
    }
    return nil;
}

- (NSPasteboardWritingOptions)writingOptionsForType:(NSString *)type pasteboard:(NSPasteboard *)pasteboard
{
    return 0;
}
@end
