//: SGTableView_p.h
/**
  * $Id: SGTableView_p.h,v 1.1.1.1 2005-05-11 17:51:26 tsawada2 Exp $
  * 
  * Copyright (c) 2001-2003, Takanori Ishikawa.  All rights reserved.
  * See the file LICENSE for copying permission.
  */

#import "SGTableView.h"

#import "SGAppKitFrameworkDefines.h"
#import <SGAppKit/SGTableViewBase.h>
#import <SGAppKit/NSColor-SGExtensions.h>

#define VGLID_LINE_WIDTH		0.2f


@interface SGTableView(DrowingStripes)
- (void) fillWithStripedColorInRow : (int) rowIndex;
- (void) drawEmptyRows;
@end



@interface SGTableView(StripedLayoutSupport)
- (BOOL) shouldFillStripedAtRow : (int) rowIndex;
- (unsigned) numberOfEmptyRows;
- (int) numberOfRowsInVisibleRectIgnoreDataSource;
- (NSRect) visibleRectOfColumn : (int) columnIndex;
- (NSRect) rectOfRowIgnoreDataSource : (int) rowIndex;
@end



@interface SGTableView(VerticalGrid)
- (void) drawVerticalGridInClipRect : (NSRect) aRect;
- (void) strokeVerticalGridLineFromPoint : (NSPoint) p1 
								 toPoint : (NSPoint) p2;
@end
