//: NSView-SGExtensions_p.h
/**
  * $Id: NSView-SGExtensions_p.h,v 1.1.1.1 2005-05-11 17:51:27 tsawada2 Exp $
  * 
  * Copyright (c) 2001-2003, Takanori Ishikawa.  All rights reserved.
  * See the file LICENSE for copying permission.
  */

#import "NSView-SGExtensions.h"
#import "SGAppKitFrameworkDefines.h"

#define ANIMATE_VALUE_MIN	2.0f

@interface SGViewAnimationScrollInfo : NSObject
{
	@private
	NSPoint			m_point;
	float			m_animateValue;
	NSTimeInterval	m_timeInterval;
}
//////////////////////////////////////////////////////////////////////
/////////////////////// [ 初期化・後始末 ] ///////////////////////////
//////////////////////////////////////////////////////////////////////
+ (id) infoWithPoint : (NSPoint       ) aPoint
        animateValue : (float         ) animateValue
            interval : (NSTimeInterval) timeInterval;
- (id) initWithPoint : (NSPoint       ) aPoint
        animateValue : (float         ) animateValue
            interval : (NSTimeInterval) timeInterval;
//////////////////////////////////////////////////////////////////////
//////////////////// [ インスタンスメソッド ] ////////////////////////
//////////////////////////////////////////////////////////////////////
/* Accessor for m_point */
- (NSPoint) point;
/* Accessor for m_animateValue */
- (float) animateValue;
/* Accessor for m_timeInterval */
- (NSTimeInterval) timeInterval;
@end
