//
//  BSDictionaryServicesHelper.m
//  BSDictionaryServicesHelper
//
//  Created by Tsutomu Sawada on 09/06/28.
//  Copyright 2009 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "BSDictionaryServicesHelper.h"
#import <Carbon/Carbon.h>


@implementation BSDictionaryServicesHelper
+ (void)lookupInDictionaryWithRange:(NSRange)selectedRange atView:(NSTextView *)textView
{
    NSAttributedString *text = [[textView textStorage] attributedSubstringFromRange:selectedRange];
    NSFont *attr = [text attribute:NSFontAttributeName atIndex:0 effectiveRange:NULL];
    CGFloat adjust = [attr ascender];
    CFRange range = CFRangeMake(0, selectedRange.length);

    NSLayoutManager *lm = [textView layoutManager];
    NSRange	glyphRange;
    NSRect	rect;

    glyphRange = [lm glyphRangeForCharacterRange:selectedRange actualCharacterRange:NULL];
    rect = [lm boundingRectForGlyphRange:glyphRange inTextContainer:[textView textContainer]];
    NSPoint windowPoint = [textView convertPoint:NSMakePoint(rect.origin.x, rect.origin.y + adjust) toView:nil];
    NSPoint screenPoint = [[textView window] convertBaseToScreen:windowPoint];
    CGPoint point = CGPointMake(screenPoint.x, NSMaxY([[[NSScreen screens] objectAtIndex:0] frame]) - screenPoint.y);

    HIDictionaryWindowShow(NULL, (CFAttributedStringRef)text, range, NULL, point, false, NULL);
}
@end
