//
//  BSBoardInformationObject.h
//  BathyScaphe
//
//  Created by Hori,Masaki on 10/10/12.
//  Copyright 2010 masakih. All rights reserved.
//

#import <CoreData/CoreData.h>

@class BSBoardHistoryObject;
@class BSThreadInformationObject;

@interface BSBoardInformationObject :  NSManagedObject  
{
}

@property (nonatomic, retain) NSNumber * boardID;
@property (nonatomic, retain) NSString * boardName;
@property (nonatomic, retain) NSString * boardURL;
@property (nonatomic, retain) NSSet* histories;
@property (nonatomic, retain) NSSet* threads;

@end


@interface BSBoardInformationObject (CoreDataGeneratedAccessors)
- (void)addHistoriesObject:(BSBoardHistoryObject *)value;
- (void)removeHistoriesObject:(BSBoardHistoryObject *)value;
- (void)addHistories:(NSSet *)value;
- (void)removeHistories:(NSSet *)value;

- (void)addThreadsObject:(BSThreadInformationObject *)value;
- (void)removeThreadsObject:(BSThreadInformationObject *)value;
- (void)addThreads:(NSSet *)value;
- (void)removeThreads:(NSSet *)value;

@end

