//
//  PSPreviewerInterface.m
//  PreviewerSelector
//
//  Created by Hori,Masaki on 10/09/13.
//  Copyright 2010 masakih. All rights reserved.
//

#import "PSPreviewerInterface.h"
#import "BSLinkPreviewSelector.h"
#import "BSLPSPreviewerItem.h"


NSString *BSLinkPreviewSelectorDidChangeItemsNotification = @"BSLinkPreviewSelectorDidChangeItemsNotification";


@interface BSLinkPreviewSelector (PSPreviewerInterface) <PSPreviewerInterface>
@end

@implementation BSLinkPreviewSelector (PSPreviewerInterface)
static NSArray *previewerDisplayNames = nil;
static NSArray *previewerIdentifiers = nil;
static NSArray *previewers = nil;

- (void)buildArrays
{
	NSMutableArray *names = [NSMutableArray array];
	NSMutableArray *ids = [NSMutableArray array];
	
	for(BSLPSPreviewerItem *item in [self loadedPlugInsInfo]) {
		[names addObject:item.displayName];
		[ids addObject:item.identifier];
	}
	
	previewerDisplayNames = [[NSArray arrayWithArray:names] retain];
	previewerIdentifiers = [[NSArray arrayWithArray:ids] retain];
}
- (NSArray *)previewerDisplayNames
{
	if(previewerDisplayNames) return previewerDisplayNames;
	
	[self buildArrays];
	
	return previewerDisplayNames;
}

- (NSArray *)previewerIdentifires
{
	if(previewerIdentifiers) return previewerIdentifiers;
	
	[self buildArrays];
	
	return previewerIdentifiers;
}
- (BOOL)openURL:(NSURL *)url withPreviewer:(id)previewer
{
	if([previewer conformsToProtocol:@protocol(BSLinkPreviewing)]) {
		return [previewer previewLink:url];
	}
	
	return [previewer showImageWithURL:url];
}
- (BOOL)openURLs:(NSArray *)url withPreviewer:(id)previewer
{
	if([previewer respondsToSelector:@selector(previewLinks:)]) {
		return [previewer previewLinks:url];
	}
	if([previewer respondsToSelector:@selector(showImagesWithURLs:)]) {
		return [previewer showImagesWithURLs:url];
	}
	return NO;
}

- (BOOL)openURL:(NSURL *)url inPreviewerByName:(NSString *)previewerName
{
	BOOL result = NO;
	
	for(BSLPSPreviewerItem *item in [self loadedPlugInsInfo]) {
		NSString *displayName = item.displayName;
		
		if([displayName isEqualToString:previewerName]) {
			id previewer = item.previewer;
			if([previewer validateLink:url]) {
				result =  [self openURL:url withPreviewer:previewer];;
			}
			return result;
		}
	}
	
	return NO;
}
- (BOOL)openURL:(NSURL *)url inPreviewerByIdentifier:(NSString *)target
{
	BOOL result = NO;
	
	for(BSLPSPreviewerItem *item in [self loadedPlugInsInfo]) {
		if([item.identifier isEqualToString:target]) {
			id previewer = item.previewer;
			if([previewer validateLink:url]) {
				result =  [self openURL:url withPreviewer:previewer];;
			}
			return result;
		}
	}
	
	return NO;
}

- (NSArray *)previewerItems
{
	return [NSArray arrayWithArray:[self loadedPlugInsInfo]];
}

// for direct controll previewers.
- (NSArray *)previewers
{
	if(previewers) return previewers;
	
	NSMutableArray *pvs = [NSMutableArray array];
	
	for(BSLPSPreviewerItem *item in [self loadedPlugInsInfo]) {
		[pvs addObject:item.previewer];
	}
	
	previewers = [NSArray arrayWithArray:pvs];
	
	return previewers;
}
- (id <BSLinkPreviewing>)previewerByName:(NSString *)previewerName
{
	for(BSLPSPreviewerItem *item in [self loadedPlugInsInfo]) {
		if([item.displayName isEqualToString:previewerName]) {
			return item.previewer;
		}
	}
	
	return nil;
}
- (id <BSLinkPreviewing>)previewerByIdentifier:(NSString *)previewerIdentifier
{
	for(BSLPSPreviewerItem *item in [self loadedPlugInsInfo]) {
		if([item.identifier isEqualToString:previewerIdentifier]) {
			return item.previewer;
		}
	}
	
	return nil;
}
@end

@implementation NSObject (PSPreviewerInterface)
+ (id <PSPreviewerInterface>)PSPreviewerSelector
{
	return [BSLinkPreviewSelector sharedInstance];
}
@end
