//
//  BSLinkPreviewSelector.m
//  PreviewerSelector
//
//  Created by Hori,Masaki on 06/05/07.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import "BSLinkPreviewSelector.h"
//#import "BSLPSPreference.h"
#import <objc/objc-class.h>

#import "BSLPSPreviewerItem.h"
#import "BSLPSPreviewerItems.h"
#import "BSLPSPreferenceViewController.h"

#import "AppDefaults.h"


#import "HMPreferenceWindow.h"



#pragma mark -
#pragma mark CMRFileManager Dummy
@interface NSObject(CMRFileManagerDummy)
+ (id)defaultManager;
- (id)supportDirectoryWithName:(NSString *)dirName;
- (NSString *)filepath;
@end
#define CMRFileManager NSClassFromString(@"CMRFileManager")

#pragma mark -
#pragma mark## NSDictionary Keys ##
static NSString *keyPlugInObject = @"PlugInObjectKey";
static NSString *keyActionLink = @"ActionLinkKey";

static NSString *keyPrefPlugInsDir = AppIdentifierString @"." @"PlugInsDir";

NSString *keyPrefPlugInsInfo = AppIdentifierString @"." @"PlugInsInfo";


#pragma mark## Static Variable ##
static IMP orignalIMP;

@implementation BSLinkPreviewSelector(MethodExchange)
- (NSMenuItem *)replacementCommandItemWithLink:(id)link command:(Class)class title:(NSString *)title
{
	id obj = [BSLinkPreviewSelector sharedInstance];
	Class class_ = NSClassFromString(@"SGPreviewLinkCommand");
	NSMenuItem *res;
		
	if(class_ == class) {
		res = [obj previewMenuItemForLink:link];
		[res setTitle:title];
	} else {
		res = orignalIMP(self, _cmd, link, class, title);
	}
	
	return res;
}
@end
static void psSwapMethod()
{
//	Class target = NSClassFromString(@"CMRThreadView");
	Class target = NSClassFromString(@"SGHTMLView");
	Method method;
	
    method = class_getInstanceMethod(target, @selector(commandItemWithLink:command:title:));
	orignalIMP = class_getMethodImplementation(target, @selector(commandItemWithLink:command:title:));
	if(method) {		
		Method newMethod = class_getInstanceMethod([BSLinkPreviewSelector class], @selector(replacementCommandItemWithLink:command:title:));
		method_exchangeImplementations(method, newMethod);
	}
}

#pragma mark-
#pragma mark## Class variables ##
static BSLinkPreviewSelector *sSharedInstance;

#pragma mark-


@interface BSLinkPreviewSelector()
@property (retain, nonatomic) HMPreferenceWindow *preferenceWindow;
- (BOOL)openURL:(NSURL *)url withPreviewer:(id)previewer;
- (BOOL)openURLs:(NSArray *)url withPreviewer:(id)previewer;
@end

#pragma mark-
@implementation BSLinkPreviewSelector
@synthesize preferenceWindow = _preferenceWindow;

+ (void)initialize
{
	psSwapMethod();
}

+ (BSLinkPreviewSelector *)sharedInstance
{
	if (sSharedInstance == nil) {
		sSharedInstance = [[super allocWithZone:NULL] init];
	}
	return sSharedInstance;
}

+ (id)allocWithZone:(NSZone *)zone
{
	return [[self sharedInstance] retain];
}

- (id)copyWithZone:(NSZone *)zone
{
	return self;
}

- (id)retain
{
	return self;
}

- (NSUInteger)retainCount
{
	return NSUIntegerMax;  //denotes an object that cannot be released
}

- (oneway void)release
{
	//do nothing
}

- (id)autorelease
{
	return self;
}



- (void)addItem:(BSLPSPreviewerItem *)item
{
	[_items addItem:item];
	[self savePlugInsInfo];
}
- (void)addItemFromBundle:(NSBundle *)plugin
{
	[_items addItemFromBundle:plugin];
	[self savePlugInsInfo];
}
- (void)addItemFromURL:(NSURL *)url
{
	[_items addItemFromURL:url];
	[self savePlugInsInfo];
}
- (void)removeItem:(BSLPSPreviewerItem *)item
{
	[_items removeItem:item];
	[self savePlugInsInfo];
}
- (void)moveItem:(BSLPSPreviewerItem *)item toIndex:(NSUInteger)index
{
	[_items moveItem:item toIndex:index];
	[self savePlugInsInfo];
}


- (NSArray *)loadedPlugInsInfo
{
	return [_items previewerItems];
}

- (void)savePlugInsInfo
{
	NSData *itemsData = [NSKeyedArchiver archivedDataWithRootObject:[self loadedPlugInsInfo]];
	
	[self setPreference:itemsData forKey:keyPrefPlugInsInfo];
}

- (NSMenuItem *)previewMenuItemForLink:(id)link
{
	NSURL *url = [NSURL URLWithString:link];
	id res = [[[NSMenuItem alloc] initWithTitle:@"" action:Nil keyEquivalent:@""] autorelease];
	
	id submenu = [[[NSMenu alloc] initWithTitle:@""] autorelease];
	[res setSubmenu:submenu];
	
	for(BSLPSPreviewerItem *item in [self loadedPlugInsInfo]) {
		if(!item.isDisplayInMenu) continue;
		
		NSMenuItem *menuItem = [[[NSMenuItem alloc] initWithTitle:item.displayName
														   action:@selector(performLinkAction:)
													keyEquivalent:@""] autorelease];
		
		if([item.previewer validateLink:url]) {
			[menuItem setTarget:self];
			[menuItem setRepresentedObject:
				[NSDictionary dictionaryWithObjectsAndKeys:item, keyPlugInObject, url, keyActionLink, nil]];
		} else {
			[menuItem setEnabled:NO];
		}
		
		[submenu addItem:menuItem];
	}
		
	return res;
}


#pragma mark## Actions ##
- (void)performLinkAction:(id)sender
{
	if(![sender respondsToSelector:@selector(representedObject)]) return;
	
	id rep = [sender representedObject];
	if(![rep isKindOfClass:[NSDictionary class]]) return;
	
	id obj = [[rep objectForKey:keyPlugInObject] previewer];
	id url = [rep objectForKey:keyActionLink];
	
	[self openURL:url withPreviewer:obj];
}

#pragma mark## Key Value Coding ##
- (void)setPreference:(id)pref forKey:(id)key
{
	[[[self preferences] imagePreviewerPrefsDict] setObject:pref forKey:key];
}
- (id)preferenceForKey:(id)key
{
	return [[[self preferences] imagePreviewerPrefsDict] objectForKey:key];
}

- (NSString *)plugInsDirectory
{
	NSString *path;
	
	path = [self preferenceForKey:keyPrefPlugInsDir];
	
	if(!path) {
		id fm = [CMRFileManager defaultManager];
		id pathRef = [fm supportDirectoryWithName:@"PlugIns"];
		path = [pathRef filepath];
	}
	
	return path;
}
- (NSView *)preferenceView
{
	if(prefViewController) {
		return prefViewController.view;
	}
	prefViewController = [[BSLPSPreferenceViewController alloc] init];
	[prefViewController setPlugInList:[self loadedPlugInsInfo]];
	return prefViewController.view;
}

#pragma mark-
// Designated Initializer
- (id)initWithPreferences:(AppDefaults *)prefs
{
	self = [self init];
	
	_items = [[BSLPSPreviewerItems alloc] init];
	
	[self setPreferences:prefs];
	
	return self;
}
	// Accessor
- (AppDefaults *)preferences
{
	return _preferences;
}
- (void)setPreferences:(AppDefaults *)aPreferences
{
	id temp = _preferences;
	_preferences = [aPreferences retain];
	[temp release];
	
	[_items setPreference:_preferences];
}
	// Action
- (BOOL)showImageWithURL:(NSURL *)imageURL
{
	BOOL result = NO;
	
	for(BSLPSPreviewerItem *item in [self loadedPlugInsInfo]) {
		if(!item.isTryCheck) continue;
		
		id previewer = item.previewer;
		if([previewer validateLink:imageURL]) {
			result =  [self openURL:imageURL withPreviewer:previewer];
		}
		if(result) return YES;
	}
	
	return NO;
}
- (BOOL)previewLink:(NSURL *)url
{
	return [self showImageWithURL:url];
}
- (BOOL)validateLink:(NSURL *)anURL
{
	if([[anURL scheme] isEqualToString:@"cmonar"]) return NO;
	
	return YES;
}
- (IBAction)resetPreviewer:(id)sender
{
	for(BSLPSPreviewerItem *item in [self loadedPlugInsInfo]) {
		id previewer = item.previewer;
		if([previewer respondsToSelector:_cmd]) {
			[previewer performSelector:_cmd withObject:sender];
		}
	}
}

- (HMPreferenceWindow *)preferenceWindow
{
	if(_preferenceWindow) return _preferenceWindow;
	_preferenceWindow = [[HMPreferenceWindow alloc] init];
	[_preferenceWindow setItems:[self loadedPlugInsInfo]];
	return _preferenceWindow;
}
- (IBAction) togglePreviewPanel : (id) sender
{
	[self.preferenceWindow showWindow:nil];
}
- (BOOL)previewLinks:(NSArray *)urls
{
	return [self showImagesWithURLs:urls];
}
- (BOOL)showImagesWithURLs:(NSArray *)urls
{
	BOOL result = NO;
	
	for(BSLPSPreviewerItem *item in [self loadedPlugInsInfo]) {
		result = [self openURLs:urls withPreviewer:item.previewer];
		if(result) return YES;
	}
	
	return NO;
}

@end
