//
//  BSLinkPreviewSelector.h
//  PreviewerSelector
//
//  Created by Hori,Masaki on 06/05/07.
//  Copyright 2006 masakih. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "BSImagePreviewerInterface.h"
#import "BSPreviewPluginInterface.h"

@class BSLPSPreviewerItems, BSLPSPreviewerItem;
@class BSLPSPreferenceViewController;

@class HMPreferenceWindow;

@interface BSLinkPreviewSelector : NSObject <BSLinkPreviewing>
{
	AppDefaults *_preferences;
	BSLPSPreviewerItems *_items;
	
	BSLPSPreferenceViewController *prefViewController;
	HMPreferenceWindow *_preferenceWindow;
}

+ (id)sharedInstance;

- (NSMenuItem *)previewMenuItemForLink:(id)link;

- (NSString *)plugInsDirectory;

- (NSArray *)loadedPlugInsInfo;

- (void)savePlugInsInfo;
//- (void)restorePlugInsInfo;

- (id)preferenceForKey:(id)key;
- (void)setPreference:(id)pref forKey:(id)key;

- (NSView *)preferenceView;

// 
- (void)addItem:(BSLPSPreviewerItem *)item;
- (void)addItemFromBundle:(NSBundle *)plugin;
- (void)addItemFromURL:(NSURL *)url;
- (void)removeItem:(BSLPSPreviewerItem *)item;
- (void)moveItem:(BSLPSPreviewerItem *)item toIndex:(NSUInteger)index;

@end

#define PSLocalizedString( str, comment ) \
NSLocalizedStringFromTableInBundle( (str), @"Localizable", [NSBundle bundleForClass:[BSLinkPreviewSelector class]], (comment) )

#define AppIdentifierString @"jp.tsawada2.bathyscaphe.BSLinkPreviewSelector"
extern NSString *keyPrefPlugInsInfo;

