//
//  CookieManager.m
//  CocoMonar
//
//  Created by Takanori Ishikawa on Mon Mar 25 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import "CookieManager.h"
#import "Cookie.h"
#import "AppDefaults.h"
#import <AppKit/NSApplication.h>



@implementation CookieManager
APP_SINGLETON_FACTORY_METHOD_IMPLEMENTATION(defaultManager);

+ (NSString *) defaultFilepath
{
	return [[CMRFileManager defaultManager]
				 supportFilepathWithName : CMRCookiesFile
						resolvingFileRef : NULL];
}

- (id) init
{
	NSString		*filepath_;
	NSDictionary	*dict_;
	
	filepath_ = [[self class] defaultFilepath];
	UTILAssertNotNil(filepath_);
		
	dict_ = [NSDictionary dictionaryWithContentsOfFile : filepath_];
	return (self = [self initWithPropertyListRepresentation : dict_]);
}
+ (id) objectWithPropertyListRepresentation : (id) rep
{
	return [[[self alloc] initWithPropertyListRepresentation : rep] autorelease];
}
- (id) propertyListRepresentation
{
	return [self dictionaryRepresentation];
}
- (id) initWithPropertyListRepresentation : (id) rep
{
	if (self = [super init]) {
		if (NO == [self initializeFromPropertyListRepresentation : rep]) {
			[self autorelease];
			return nil;
		}
		
		[[NSNotificationCenter defaultCenter]
				 addObserver : self
					selector : @selector(applicationWillTerminate:)
					    name : NSApplicationWillTerminateNotification
					  object : NSApp];
	}
	return self;
}
- (BOOL) initializeFromPropertyListRepresentation : (id) rep;
{
	NSDictionary		*tmp_;
	
	if (nil == rep) return YES;
	if (NO == [rep isKindOfClass : [NSDictionary class]]) return NO;
	
	tmp_ = [self dictionaryByDeletingExpiredCookies : rep];
	[self setCookies : tmp_];
	return YES;
}
- (void) dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver : self];
	[_cookies release];
	[super dealloc];
}



- (NSDictionary *) cookies
{
	if (nil == _cookies)
		_cookies = [[NSDictionary empty] copy];
	
	return _cookies;
}
- (void) setCookies : (NSDictionary *) aCookies
{
	id		tmp;
	
	tmp = _cookies;
	_cookies = [aCookies retain];
	[tmp release];
}
- (void) setCookiesArray : (NSArray  *) aCookiesArray
				 forHost : (NSString *) aHost
{
	NSMutableDictionary		*tmp;
	NSDictionary			*newDict_;
	
	if (nil == aCookiesArray || nil == aHost) 
		return;
	
	tmp = [[self cookies] mutableCopy];
	[tmp setObject:aCookiesArray forKey:aHost];
	
	newDict_ = [tmp copy];
	[self setCookies : newDict_];
	
	[newDict_ release];
	[tmp release];
}
- (void) removeAllCookies
{
	[self setCookies : nil];
}

//////////////////////////////////////////////////////////////////////
//////////////////// [ CX^X\bh ] ////////////////////////
//////////////////////////////////////////////////////////////////////
/**
  * PA܂͕̃NbL[ݒ܂Ƃ߂@"Set-Cookie"wb_
  * ͂AK؂ȐCookie𐶐AzɊi[ĕԂB
  * 
  * @param    header  wb_
  * @return           Cookie̔z(sɂnil)
  */
- (NSArray *) scanSetCookieHeader : (NSString *) header
{
	static NSString *const st_sep_ = @",";
	static NSString *const st_expsep_ = @"day,";
	static NSString *const st_expsep2_ = @"day.";
	NSMutableArray  *marray_;
	NSMutableString *mstr_;
	
	if (nil == header || 0 == [header length])
		return nil;
	marray_ = [NSMutableArray array];
	// J}ŋ؂Ă邪AL̃tH[}bgɂJ}
	// ܂܂Ă邽߁APɐ؂蕪邱Ƃ͂łȂB
	// ex. expires=Wednesday, 24-Apr-2002 00:00:00 GMT 
	mstr_ = [NSMutableString stringWithString : header];
	//expires̗ǰ̃J}ЂƂ܂A̕(*)
	[mstr_ replaceCharacters : st_expsep_
	                toString : st_expsep2_];
	//͕
	{
		NSArray      *comps_;		//؂蕶Ő؂蕪
		NSEnumerator *iter_;		//T
		NSString     *item_;		//eP
		
		comps_ = [mstr_ componentsSeparatedByString : st_sep_];
		iter_ = [comps_ objectEnumerator];
		while (item_ = [iter_ nextObject]) {
			Cookie *cookie_;
			
			item_ = [item_ stringByStriped];
			//(*)̒u߂ĂB
			item_ = [item_ stringByReplaceCharacters : st_expsep2_
				                            toString : st_expsep_];
			cookie_ = [Cookie cookieWithString : item_];
			NSAssert1(
				(cookie_ != nil),
				@"Can't create Cookie! from %@",
				item_);
			[marray_ addObject : cookie_];
		}
	}
	if (0 == [marray_ count])
		return nil;
	return marray_;
}

/**
  * @"Set-Cookie"ŗvꂽNbL[ێB
  * 
  * @param    header    @"Set-Cookie"wb_
  * @param    hostName  ṽzXg
  */
- (void) addCookies : (NSString *) header
         fromServer : (NSString *) hostName
{
	NSMutableArray *oldCookies_;		//O܂ł̃NbL[
	NSArray        *newCookies_;		//VǉNbL[
	
	if (nil == header || nil == hostName) return;
	
	oldCookies_ = [[self cookies] objectForKey : hostName];
	// VK쐬
	if (nil == oldCookies_)
		oldCookies_ = [NSMutableArray array];
	
	UTILAssertKindOfClass(oldCookies_, NSMutableArray);

	newCookies_ = [self scanSetCookieHeader : header];
	if (newCookies_ != nil) {
		NSEnumerator *iter_;		//T
		Cookie       *cookie_;		//eNbL[
		
		iter_ = [newCookies_ reverseObjectEnumerator];
		while (cookie_ = [iter_ nextObject]) {
			//dNbL[͎菜B
			[oldCookies_ removeObject : cookie_];
			[oldCookies_ addObject : cookie_];
		}
	}
	[self setCookiesArray:oldCookies_ forHost:hostName];
}
/**
  * MɑׂURLꍇ̓NbL[ԂB
  * 
  * @param    anURL  MURL
  * @return          NbL[
  */
- (NSString *) cookiesForRequestURL : (NSURL *) anURL
{
	NSArray        *cookies_;		//zXgɑΉNbL[
	NSEnumerator   *iter_;			//T
	Cookie         *item_;			//eNbL[
	NSMutableArray *avails_;		//ׂNbL[

	const char *hs = [[anURL host] UTF8String];
	if (NULL == hs) return nil;
	
	if (nil == anURL) return nil;
	cookies_ = [[self cookies] objectForKey : [anURL host]];
	if (nil == cookies_ || 0 == [cookies_ count]) return nil;
	avails_ = [NSMutableArray array];
	
	iter_ = [cookies_ objectEnumerator];
	while (item_ = [iter_ nextObject]) {
		if (NO == [item_ isAvalilableURL : anURL]) continue;
		if (NO == [item_ isEnabled]) continue;
		if ([item_ isExpired : NULL]) continue;
		[avails_ addObject : item_];
	}
	//OŁApẌႤNbL[ꍇ
	//[}b`̂𑗂B
/*	iter_ = [avails_ objectEnumerator];
	while (item_ = [iter_ nextObject]) {
		//܂̂Ƃ떢
	}
*/
	//  be OĈ߂̃NbL[ǉR[h
	if (is_2channel(hs)) {
		if ([CMRPref shouldLoginBe2chAnyTime] || [[anURL host] isEqualToString : @"be.2ch.net"] || [[anURL host] isEqualToString : @"qa.2ch.net"]) {
			Cookie	*beItem_, *beItem2_;
			NSString *dmdmStr_, *mdmdStr_;
			
			dmdmStr_ = [CMRPref be2chAccountMailAddress];
			if (dmdmStr_ == nil || [dmdmStr_ length] == 0) goto default_cookie;

			mdmdStr_ = [CMRPref be2chAccountCode];
			if (mdmdStr_ == nil || [mdmdStr_ length] == 0) goto default_cookie;
			
			beItem_ = [Cookie cookieWithDictionary : [NSDictionary dictionaryWithObject : dmdmStr_ forKey : @"DMDM"]];
			[avails_ addObject : beItem_];
			beItem2_ = [Cookie cookieWithDictionary : [NSDictionary dictionaryWithObject : mdmdStr_ forKey : @"MDMD"]];
			[avails_ addObject : beItem2_];
		}
	}
	
default_cookie:
	return [avails_ componentsJoinedByString : @"; "];
}

/**
  * ؂̃NbL[폜B
  */
- (void) deleteExpiredCookies
{
	[self setCookies : [self dictionaryByDeletingExpiredCookies : [self cookies]]];
}

/**
  * ؂̃NbL[폜AώŕԂB
  * 
  * @param    dict  
  * @return         ؂̃NbL[폜
  */
- (NSMutableDictionary *) dictionaryByDeletingExpiredCookies : (NSDictionary *) dict
{
	NSMutableDictionary *tmp_;		//Ɨp
	NSEnumerator        *kiter_;	//ׂẴL[
	NSString            *host_;		//eL[
	
	tmp_ = [NSMutableDictionary dictionary];
	if (nil == dict || 0 == [dict count]) return tmp_;
	
	kiter_ = [dict keyEnumerator];
	while (host_ = [kiter_ nextObject]) {
		NSMutableArray      *tmparray_;	//Ɨp
		NSArray             *cookies_;		//ׂẴNbL[
		NSEnumerator        *citer_;		//T
		id                   cookie_;		//eNbL[
		
		cookies_ = [dict objectForKey : host_];
		if (nil == cookies_ || 0 == [cookies_ count]) continue;
		
		tmparray_ = [NSMutableArray array];
		citer_ = [cookies_ reverseObjectEnumerator];
		while (cookie_ = [citer_ nextObject]) {
			// ̏ꍇCookieɕϊ
			if ([cookie_ isKindOfClass : [NSDictionary class]])
				cookie_ = [Cookie cookieWithDictionary : cookie_];
			if ([cookie_ isExpired : NULL])
				continue;
			// ؂łȂꍇ͈ڂ
			[tmparray_ addObject : cookie_];
		}
		[tmp_ setObject : tmparray_
				 forKey : host_];
	}
	return [[tmp_ copy] autorelease];
}

/**
  * t@CƂĕۑB
  * 
  * @param    path  ۑꏊ̃pX
  * @param    flag  NOȂ璼ځAށB
  * @return         YES
  */
- (BOOL) writeToFile : (NSString *) path
          atomically : (BOOL      ) flag
{
	return [[self dictionaryRepresentation] writeToFile : path
									         atomically : flag];
}

/**
  * V[oۑ\ȎŕԂB
  * 
  * @return     
  */
- (NSDictionary *) dictionaryRepresentation
{
	NSMutableDictionary		*tmp_;
	NSEnumerator			*kiter_;
	NSString				*host_;
	
	tmp_ = [NSMutableDictionary dictionary];
	kiter_ = [[self cookies] keyEnumerator];
	while (host_ = [kiter_ nextObject]) {
		NSMutableArray      *tmparray_;		//Ɨp
		NSArray             *cookies_;		//ׂẴNbL[
		NSEnumerator        *citer_;		//T
		Cookie              *cookie_;		//eNbL[
		
		cookies_ = [[self cookies] objectForKey : host_];
		if (nil == cookies_ || 0 == [cookies_ count]) continue;
		
		tmparray_ = [NSMutableArray array];
		citer_ = [cookies_ reverseObjectEnumerator];
		while (cookie_ = [citer_ nextObject]) {
			BOOL whenTerminate_;
			
			whenTerminate_ = NO;
			if ([cookie_ isExpired : &whenTerminate_] || whenTerminate_)
				continue;
			//؂łȂꍇ
			//`Œǉ
			[tmparray_ addObject : [cookie_ dictionaryRepresentation]];
		}
		[tmp_ setObject : tmparray_
				 forKey : host_];
	}
	return tmp_;
}

- (void) applicationWillTerminate : (NSNotification *) theNotification
{
	UTILAssertNotificationName(
		theNotification,
		NSApplicationWillTerminateNotification);
	
	[self writeToFile : [[self class] defaultFilepath]
		   atomically : YES];
}
@end
