//
//  CMRAbstructThreadDocument.m
//  BathyScaphe
//
//  Updated by Tsutomu Sawada on 09/09/02.
//  Copyright 2005-2010 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "CMRAbstructThreadDocument_p.h"
#import "BSThreadInfoPanelController.h"
#import "BSRelatedKeywordsCollector.h"
#import "BoardManager.h"
#import <SGAppKit/NSWorkspace-SGExtensions.h>
#import "AppDefaults.h"
#import "missing.h"

NSString *const CMRAbstractThreadDocumentDidToggleDatOchiNotification = @"CMRAbstractThreadDocumentDidToggleDatOchiNotification";

@implementation CMRAbstructThreadDocument
#pragma mark Accessors
- (NSTextStorage *)textStorage
{
    if (!_textStorage) {
        _textStorage = [[NSTextStorage alloc] init];
    }
    return _textStorage;
}

- (void)setTextStorage:(NSTextStorage *)aTextStorage
{
    [aTextStorage retain];
    [_textStorage release];
    _textStorage = aTextStorage;
}

- (CMRThreadAttributes *)threadAttributes
{
    return _threadAttributes;
}

- (void)setThreadAttributes:(CMRThreadAttributes *)newAttributes
{
    CMRThreadAttributes     *oldAttributes_;

    oldAttributes_ = _threadAttributes;
    _threadAttributes = [newAttributes retain];

    [oldAttributes_ release];
}

- (NSArray *)cachedKeywords
{
    return m_keywords;
}

- (void)setCachedKeywords:(NSArray *)array
{
    [array retain];
    [m_keywords release];
    m_keywords = array;
}

- (BSRelatedKeywordsCollector *)keywordsCollector
{
    if (!m_collector) {
        m_collector = [[BSRelatedKeywordsCollector alloc] init];
    }
    return m_collector;
}

- (BOOL)isAAThread
{
    return [[self threadAttributes] isAAThread];
}

- (void)setIsAAThread:(BOOL)flag
{
    if ([self isAAThread] == flag) return;

    NSArray *winControllers;
    [[self threadAttributes] setIsAAThread:flag];
    winControllers = [self windowControllers];
    if ([winControllers count] > 0) {
        [winControllers makeObjectsPerformSelector:@selector(changeAllMessageAttributesWithAAFlag:) withObject:[NSNumber numberWithBool:flag]];
    }
}

- (BOOL)isDatOchiThread
{
    return [[self threadAttributes] isDatOchiThread];
}

- (void)setIsDatOchiThread:(BOOL)flag
{
    if ([self isDatOchiThread] == flag) return;
    
    [[self threadAttributes] setIsDatOchiThread:flag];
    NSDictionary *foo = [NSDictionary dictionaryWithObject:[[self threadAttributes] path] forKey:@"path"];
    UTILNotifyInfo(CMRAbstractThreadDocumentDidToggleDatOchiNotification, foo);
}

- (BOOL)isMarkedThread
{
    return [[self threadAttributes] isMarkedThread];
}

- (void)setIsMarkedThread:(BOOL)flag
{
    if ([self isMarkedThread] == flag) return;
    
    [[self threadAttributes] setIsMarkedThread:flag];
}

- (NSString *)candidateHost
{
    return m_candidateHost;
}

- (void)setCandidateHost:(NSString *)host
{
    [host retain];
    [m_candidateHost release];
    m_candidateHost = host;
}

#pragma mark Override
- (void)dealloc
{
    [m_candidateHost release];
    [m_collector release];
    [m_keywords release];
    [_threadAttributes release];
    [_textStorage release];
    [super dealloc];
}

- (void)removeWindowController:(NSWindowController *)windowController
{
    NSEnumerator        *iter_;
    NSWindowController  *controller_;
    SEL                 selector_;
    
    selector_ = @selector(document:willRemoveController:);
    iter_ = [[self windowControllers] objectEnumerator];

    while(controller_ = [iter_ nextObject]){
        if (![controller_ respondsToSelector:selector_]) continue;
        
        [controller_ document:self willRemoveController:windowController];
    }

    if ([[self keywordsCollector] delegate] == windowController) {
        [[self keywordsCollector] setDelegate:nil];
    }

    [super removeWindowController:windowController];
}

#pragma mark Validation
- (BOOL)validateUserInterfaceItem:(id<NSValidatedUserInterfaceItem>)theItem
{
    SEL action_;

    action_ = [theItem action];
    
    if (action_ == @selector(showDocumentInfo:) || action_ == @selector(showMainBrowser:)) {
        return ([self showsThreadDocument] && ([self threadAttributes] != nil));
    }

    if (action_ == @selector(saveDocumentAs:)) {
        setUserInterfaceItemTitle(theItem, NSLocalizedString(@"Save Menu Item Default", @"Save as..."));
        return ([self showsThreadDocument] && ([self threadAttributes] != nil));
    } else if (action_ == @selector(toggleAAThread:)) {
        if (![self showsThreadDocument] || ![self threadAttributes]) {
            return NO;
        }
        setUserInterfaceItemState(theItem, [self isAAThread]);
    } else if (action_ == @selector(toggleMarkedThread:)) {
        if (![self showsThreadDocument] || ![self threadAttributes]) {
            return NO;
        }
        setUserInterfaceItemState(theItem, [self isMarkedThread]);
    } else if (action_ == @selector(toggleDatOchiThread:)) {
        if (![self showsThreadDocument] || ![self threadAttributes]) {
            return NO;
        }
        setUserInterfaceItemState(theItem, [self isDatOchiThread]);
    } else if (action_ == @selector(openInBrowser:)) {
        return ([self showsThreadDocument] && ([[self threadAttributes] threadURL] != nil));
    }
    return [super validateUserInterfaceItem:theItem];
}

#pragma mark IBActions
- (IBAction)showDocumentInfo:(id)sender
{
    [[BSThreadInfoPanelController sharedInstance] showWindow:sender];
}

- (IBAction)showMainBrowser:(id)sender
{
    CMRThreadAttributes *attr_ = [self threadAttributes];
    NSString *boardName_ = [attr_ boardName];
    if(!boardName_) return; 

    [[NSApp delegate] showThreadsListForBoard:boardName_ selectThread:[attr_ path] addToListIfNeeded:YES];
}

- (IBAction)revealInFinder:(id)sender
{
    NSString *path = [[self threadAttributes] path];
    if (!path) {
        NSBeep();
        return;
    }
    [[NSWorkspace sharedWorkspace] selectFile:path inFileViewerRootedAtPath:[path stringByDeletingLastPathComponent]];
}

- (IBAction)toggleAAThread:(id)sender
{
    [self setIsAAThread:![self isAAThread]];
}

- (IBAction)toggleDatOchiThread:(id)sender
{
    [self setIsDatOchiThread:![self isDatOchiThread]];
}

- (IBAction)toggleMarkedThread:(id)sender
{
    [self setIsMarkedThread:![self isMarkedThread]];
}

- (IBAction)toggleAAThreadFromInfoPanel:(id)sender
{
    NSArray *winControllers;
    BOOL    flag = [self isAAThread];
    winControllers = [self windowControllers];
    if ([winControllers count] > 0) {
        [winControllers makeObjectsPerformSelector:@selector(changeAllMessageAttributesWithAAFlag:) withObject:[NSNumber numberWithBool:flag]];
    }
}

- (IBAction)openInBrowser:(id)sender
{
    NSURL *url = [CMRThreadAttributes threadURLWithDefaultParameterFromDictionary:[[self threadAttributes] dictionaryRepresentation]];
    [[NSWorkspace sharedWorkspace] openURL:url inBackground:[CMRPref openInBg]];
}
@end


@implementation CMRAbstructThreadDocument(ScriptingSupport)
- (NSTextStorage *)selectedText
{
    NSAttributedString *attrString;
    attrString = [[self textStorage] attributedSubstringFromRange:[[[[self windowControllers] lastObject] textView] selectedRange]];
    NSTextStorage *storage = [[NSTextStorage alloc] initWithAttributedString:attrString];
    return [storage autorelease];
}

- (NSDictionary *)threadAttrDict
{
    NSDictionary *tmp = [[self threadAttributes] dictionaryRepresentation];
    return tmp ?: [NSDictionary dictionary];
}

- (NSString *)threadTitleAsString
{
    NSString *tmp = [[self threadAttributes] threadTitle];
    return tmp ?: @"";
}

- (NSString *)threadURLAsString
{
    NSString *tmp = [[[self threadAttributes] threadURL] stringValue];
    return tmp ?: @"";
}

- (NSString *)boardNameAsString
{
    NSString *tmp = [[self threadAttributes] boardName];
    return tmp ?: @"";
}

- (NSString *)boardURLAsString
{
    NSString *tmp = [[[self threadAttributes] boardURL] stringValue];
    return tmp ?: @"";
}

- (NSString *)tListBoardURL
{
    UTILAbstractMethodInvoked;
    return nil;
}

- (NSString *)tListBoardName
{
    UTILAbstractMethodInvoked;
    return nil;
}

- (void)setTListBoardName:(NSString *)boardNameStr
{
    UTILAbstractMethodInvoked;
}

- (NSString *)name
{
    UTILAbstractMethodInvoked;
    return nil;
}

- (void)setName:(NSString *)aName
{
    UTILAbstractMethodInvoked;
}

- (NSString *)mail
{
    UTILAbstractMethodInvoked;
    return nil;
}

- (void)setMail:(NSString *)aMail
{
    UTILAbstractMethodInvoked;
}

- (void)handleReloadThreadCommand:(NSScriptCommand*)command
{
    UTILAbstractMethodInvoked;
}

- (BOOL)showsThreadDocument // Dummy
{
    return YES;
}
@end
