/**
  * $Id: CMXTextParser.h,v 1.1.1.1.4.2 2006-03-19 15:09:53 masakih Exp $
  * BathyScaphe
  *
  * Copyright 2005-2006 BathyScaphe Project. All rights reserved.
  *
  */

#import <Foundation/Foundation.h>

@class CMRThreadMessage;

enum {
	k2chDATNameIndex			= 0,
	k2chDATMailIndex			,
	k2chDATDateExtraFieldIndex	,
	k2chDATMessageIndex			,
	
	// Optional
	k2chDATTitleIndex			
};


@interface CMXTextParser : NSObject
/**
  *
  * s"<>"܂","ŕzԂB
  * ؂蕶","̏ꍇ̓tB[h'@M'","ɕϊ
  *
  * ؂蕶݂Ȃꍇ͕sȕƌȂAnilԂB
  *
  * @param    line  s
  * @return         ؂蕶ŕz
  *
  */
+ (NSArray *) separatedLine : (NSString *) line;

// DAT --> XIuWFNg
+ (NSArray *) messageArrayWithDATContents : (NSString  *) DATContens
								baseIndex : (unsigned   ) baseIndex
								    title : (NSString **) tilePtr;
+ (CMRThreadMessage *) messageWithDATLine : (NSString *) theString;
+ (CMRThreadMessage *) messageWithInvalidDATLineDetected : (NSString *) line;

// Entity Reference
// "&amp" --> "&amp;"
+ (void) replaceEntityReferenceWithString : (NSMutableString *) aString;

/*
X̖{̂ϊł͕̂ϊĂ܂B
svHTML^O菜As^Oϊ
*/
+ (NSString *) cachedMessageWithMessageSource : (NSString *) aSource;
+ (void) convertMessageSourceToCachedMessage : (NSMutableString *) aSource;



// ----------------------------------------
// CES (Code Encoding Scheme)
// ----------------------------------------
/*
Shift JIS ɂĂ͑Ή镄WƂĎO
₪lB

  - JIS Kiɒ JIS X 0208:1997
  - MicroSoft Ђ̎dl
  - Apple Ђ̎dl

͈ȉ CFStringEncodings ɑΉiʓ
CFStringConvertEncodingToIANACharSetName() ̕ԂOj

  - kCFStringEncodingShiftJIS (SHIFT_JIS)
  - kCFStringEncodingDOSJapanese (CP932)
  - kCFStringEncodingMacJapanese (X-MAC-JAPANESE)

CocoMonar ̏ꍇAƂΐVEmac ł Mac Japanese 
R[hgP[X邽߁AShift JIS ɊւĂ
炷ׂĂɑΉ̂IƎvB

̂߁Aȉ̃\bhł CFStringEncoding 
Ԃꍇ
(1) ܂ÃGR[fBO
(2) ŕϊłȂΎc̃GR[fBȌԂŎB
(3) ʓIɕϊłȂ΃G[

  - kCFStringEncodingDOSJapanese
  - kCFStringEncodingMacJapanese
  - kCFStringEncodingShiftJIS
----------------------------------------
*/

+ (NSString *) stringWithData : (NSData         *) aData
                   CFEncoding : (CFStringEncoding) enc;



// ----------------------------------------
// URL Encode
// ----------------------------------------
/*!
 * @method      availableURLEncodings
 * @discussion  
 * 
 * URLGR[hꂽƂ肷Ƃ
 * pGR[fBO̔ziI[F0j
 * 
 * @result      ziI[F0j
 */
+ (const NSStringEncoding *) availableURLEncodings;
+ (NSString *) stringByURLEncodedWithString : (NSString *) aString;
+ (NSString *) stringByURLDecodedWithString : (NSString *) aString;
+ (NSString *) queryWithDictionary : (NSDictionary *) aDictionary;


+ (CMRThreadMessage *) messageWithDATLineComponentsSeparatedByNewline : (NSArray *) aComponents;

//+ (BOOL) parseDateExtraField : (NSString         *) dateExtra
//            convertToMessage : (CMRThreadMessage *) aMessage;
//+ (BOOL) parseExtraField : (NSString         *) extraField
//        convertToMessage : (CMRThreadMessage *) aMessage;
@end


extern void htmlConvertBreakLineTag(NSMutableString *theString);
