//
//  BSThreadInformationObject.h
//  BathyScaphe
//
//  Created by Hori,Masaki on 10/10/12.
//  Copyright 2010 masakih. All rights reserved.
//

#import <CoreData/CoreData.h>

@class BSBoardInformationObject;
@class BSThreadListItemObject;

@interface BSThreadInformationObject :  NSManagedObject  
{
}

@property (nonatomic, retain) NSString * threadID;
@property (nonatomic, retain) NSDate * creationDate;
@property (nonatomic, retain) NSString * threadName;
@property (nonatomic, retain) NSNumber * numberOfAll;
@property (nonatomic, retain) NSNumber * numberOfRead;
@property (nonatomic, retain) NSNumber * numberOfDifference;
@property (nonatomic, retain) NSDate * modifiedDate;
@property (nonatomic, retain) NSDate * lastWrittenDate;
@property (nonatomic, retain) NSNumber * threadLabel;
@property (nonatomic, retain) NSNumber * threadStatus;
@property (nonatomic, retain) NSNumber * isDatOchi;
@property (nonatomic, retain) NSNumber * isNew;
@property (nonatomic, retain) NSNumber * isHeadModified;
@property (nonatomic, retain) NSNumber * threadAboneType;
@property (nonatomic, retain) NSSet* threadListItems;
@property (nonatomic, retain) BSBoardInformationObject * board;


@property (nonatomic, readonly) NSDictionary *attribute;

- (void)updateStatus;
@end


@interface BSThreadInformationObject (CoreDataGeneratedAccessors)
- (void)addThreadListItemsObject:(BSThreadListItemObject *)value;
- (void)removeThreadListItemsObject:(BSThreadListItemObject *)value;
- (void)addThreadListItems:(NSSet *)value;
- (void)removeThreadListItems:(NSSet *)value;

@end

