//
//  CMRStatusLine.m
//  BathyScaphe
//
//  Updated by Tsutomu Sawada on 08/03/14.
//  Copyright 2005-2009 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "CMRStatusLine.h"
#import "BSStatusLineView.h"
#import "CMRTaskManager.h"
#import "BSTaskItemValueTransformer.h"

#define kLoadNibName				@"BSStatusLine"

@implementation CMRStatusLine
+ (void)initialize
{
	if (self == [CMRStatusLine class]) {
		id transformer = [[[BSTaskItemValueTransformer alloc] init] autorelease];
		[NSValueTransformer setValueTransformer:transformer forName:@"BSTaskItemValueTransformer"];
		id transformer2 = [[[BSStatusLineTabViewItemTransformer alloc] init] autorelease];
		[NSValueTransformer setValueTransformer:transformer2 forName:@"BSStatusLineTabViewItemTransformer"];
	}
}

- (id)initWithDelegate:(id)delegate
{
	if (self = [super init]) {
		if (![NSBundle loadNibNamed:kLoadNibName owner:self]) {
			[self release];
			return nil;
		}
		[self setDelegate:delegate];
		[[self taskObjectController] bind:@"contentObject" toObject:[CMRTaskManager defaultManager] withKeyPath:@"currentTask" options:nil];
	}
	return self;
}

- (void)dealloc
{
	[self setDelegate:nil];

	// nib top-level objects
	[_statusLineView release];
	_statusLineView = nil;
	[_objectController release];
	_objectController = nil;

	[super dealloc];
}

- (void)setupUIComponents
{
    unsigned    autoresizingMask_;

    autoresizingMask_ = NSViewMaxYMargin;
    autoresizingMask_ |= NSViewWidthSizable;
    [[self statusLineView] setAutoresizingMask:autoresizingMask_];
	[[self statusLineView] bind:@"messageText" toObject:[self taskObjectController] withKeyPath:@"selection.message" options:nil];
}

- (void)statusLineWillRemoveFromWindow
{
	[[self statusLineView] unbind:@"messageText"];
	[[self taskObjectController] unbind:@"contentObject"];
    [[self taskObjectController] setContent:nil];
}

- (void)statusLineViewDidMoveToWindow
{
	[self setupUIComponents];
	BOOL indicatorShown = [[[self statusLineView] window] showsResizeIndicator];
	if (!indicatorShown) {
        return;
    }

	NSPoint origin = [[self tabView] frame].origin;
	origin.x -= [NSScroller scrollerWidth];
	[[self tabView] setFrameOrigin:origin];
}

#pragma mark Accessors
- (BSStatusLineView *)statusLineView
{
    return _statusLineView;
}

- (NSProgressIndicator *)progressIndicator
{
    return _progressIndicator;
}

- (NSObjectController *)taskObjectController
{
	return _objectController;
}

- (NSTabView *)tabView
{
    return m_tabView;
}

- (id)delegate
{
	return _delegate;
}

- (void)setDelegate:(id)aDelegate
{
	_delegate = aDelegate;
}
@end
