/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 56 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 240
#define YYACTIONTYPE unsigned short int
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  struct {int value; int mask;} yy13;
  struct TrigEvent yy132;
  IdList* yy160;
  Expr* yy178;
  int yy230;
  Select* yy239;
  TriggerStep* yy247;
  struct LimitVal yy270;
  SrcList* yy285;
  Expr * yy292;
  Token yy384;
  struct LikeOp yy440;
  ExprList* yy462;
  int yy479;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 559
#define YYNRULE 295
#define YYERRORSYMBOL 137
#define YYERRSYMDT yy479
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   279,  855,  125,  370,  442,  171,    2,  377,   88,   88,
 /*    10 */    88,   88,  298,   86,   86,   86,   86,   85,   85,   84,
 /*    20 */    84,   84,   83,  525,  523,  522,  392,   81,   86,   86,
 /*    30 */    86,   86,   85,   85,   84,   84,   84,   83,   82,  427,
 /*    40 */    80,  146,  187,   89,   55,  297,  402,  404,  399,  399,
 /*    50 */    87,   87,   88,   88,   88,   88,  202,   86,   86,   86,
 /*    60 */    86,   85,   85,   84,   84,   84,   83,  279,  298,  151,
 /*    70 */   377,  389,  475,   69,   86,   86,   86,   86,   85,   85,
 /*    80 */    84,   84,   84,   83,  186,  114,  254,  362,  256,  328,
 /*    90 */   155,  232,  398,  392,  529,  442,  403,   91,  231,  485,
 /*   100 */   508,  323,  508,  375,   85,   85,   84,   84,   84,   83,
 /*   110 */    89,   55,  297,  402,  404,  399,  399,   87,   87,   88,
 /*   120 */    88,   88,   88,   83,   86,   86,   86,   86,   85,   85,
 /*   130 */    84,   84,   84,   83,  279,  218,  372,  372,  372,  489,
 /*   140 */   429,  145,  254,  362,  256,  328,  155,  232,  454,   22,
 /*   150 */   529,  250,  428,  529,  231,  352,  549,  527,  526,  198,
 /*   160 */   392,  208,  331,  337,  340,  422,  277,  302,  179,  387,
 /*   170 */   488,  160,  144,  499,  345,  180,  350,   89,   55,  297,
 /*   180 */   402,  404,  399,  399,   87,   87,   88,   88,   88,   88,
 /*   190 */   189,   86,   86,   86,   86,   85,   85,   84,   84,   84,
 /*   200 */    83,  486,  391,  518,  385,  200,  279,  198,  356,  457,
 /*   210 */   331,  337,  340,  527,  526,  541,  527,  526,  551,  353,
 /*   220 */   356,  510,  345,  356,  542,  509,  347,  365,  147,  282,
 /*   230 */   397,   43,  392,  543,  544,    9,  484,  319,   17,  529,
 /*   240 */   447,  517,  397,   37,  498,  397,   37,  168,   70,   89,
 /*   250 */    55,  297,  402,  404,  399,  399,   87,   87,   88,   88,
 /*   260 */    88,   88,  391,   86,   86,   86,   86,   85,   85,   84,
 /*   270 */    84,   84,   83,  497,  464,  161,  490,  290,  279,  455,
 /*   280 */   496,  391,  483,  360,  356,  299,  281,  410,  318,  356,
 /*   290 */   304,  242,  236,  356,  409,  206,   82,  424,   80,  146,
 /*   300 */   424,  202,  527,  526,  392,  260,  397,   46,  451,  391,
 /*   310 */   398,  397,   37,  214,  403,  397,   43,  188,  416,  415,
 /*   320 */    73,   89,   55,  297,  402,  404,  399,  399,   87,   87,
 /*   330 */    88,   88,   88,   88,  307,   86,   86,   86,   86,   85,
 /*   340 */    85,   84,   84,   84,   83,  279,  344,  274,  429,  460,
 /*   350 */    82,  391,   80,  146,  291,  312,  343,  529,  413,  356,
 /*   360 */   428,  317,  289,  190,  154,  314,  424,  152,  355,  284,
 /*   370 */   548,  392,  529,  422,   82,  431,   80,  146,  342,  380,
 /*   380 */   381,  397,   26,  180,  313,  430,  407,  407,   89,   55,
 /*   390 */   297,  402,  404,  399,  399,   87,   87,   88,   88,   88,
 /*   400 */    88,  391,   86,   86,   86,   86,   85,   85,   84,   84,
 /*   410 */    84,   83,  279,  198,  458,  475,  331,  337,  340,  475,
 /*   420 */   527,  526,   84,   84,   84,   83,  356,  529,  345,  385,
 /*   430 */   200,  408,  393,  506,  507,  527,  526,  282,  392,  341,
 /*   440 */    57,  206,  231,  313,  308,  407,  407,  444,  397,   46,
 /*   450 */   292,  165,  395,  396,  212,   89,   55,  297,  402,  404,
 /*   460 */   399,  399,   87,   87,   88,   88,   88,   88,  218,   86,
 /*   470 */    86,   86,   86,   85,   85,   84,   84,   84,   83,  279,
 /*   480 */   394,  356,  202,  463,    1,  356,  303,  489,  529,  226,
 /*   490 */   527,  526,  348,  255,  244,  305,  500,   22,  244,  313,
 /*   500 */   122,  407,  407,  397,   35,  392,  149,  397,   37,  227,
 /*   510 */   286,  380,  381,  218,  397,    3,  313,  443,  407,  407,
 /*   520 */   268,  377,   89,   55,  297,  402,  404,  399,  399,   87,
 /*   530 */    87,   88,   88,   88,   88,  356,   86,   86,   86,   86,
 /*   540 */    85,   85,   84,   84,   84,   83,  279,  356,  192,   67,
 /*   550 */   252,  527,  526,  356,  366,  223,  356,  397,   53,  129,
 /*   560 */   356,  273,  423,  356,  202,  356,  387,  330,  160,  397,
 /*   570 */    48,  489,  392,  206,  411,  397,   38,  363,  397,   10,
 /*   580 */   556,   22,  397,   24,  377,  397,   45,  397,   32,   89,
 /*   590 */    55,  297,  402,  404,  399,  399,   87,   87,   88,   88,
 /*   600 */    88,   88,  356,   86,   86,   86,   86,   85,   85,   84,
 /*   610 */    84,   84,   83,  279,  356,  177,  173,  169,   58,  356,
 /*   620 */   421,  356,   15,  356,  397,   34,  356,  473,  356,  122,
 /*   630 */   356,  552,  356,  171,    2,  377,  397,   36,  215,  392,
 /*   640 */   593,  397,   30,  397,   31,  397,   41,  261,  397,   42,
 /*   650 */   397,   44,  397,   47,  397,   49,   89,   55,  297,  402,
 /*   660 */   404,  399,  399,   87,   87,   88,   88,   88,   88,  356,
 /*   670 */    86,   86,   86,   86,   85,   85,   84,   84,   84,   83,
 /*   680 */   279,  356,  475,  475,  237,  109,  356,  378,  356,   20,
 /*   690 */   356,  397,   27,  356,  559,  551,  353,  356,  377,  356,
 /*   700 */   449,   21,  182,  397,   50,  377,  392,  336,  397,   33,
 /*   710 */   397,   28,  397,  111,  238,  397,  113,  300,  295,  397,
 /*   720 */    52,  397,   25,   89,   55,  297,  402,  404,  399,  399,
 /*   730 */    87,   87,   88,   88,   88,   88,  356,   86,   86,   86,
 /*   740 */    86,   85,   85,   84,   84,   84,   83,  279,  356,  475,
 /*   750 */   383,  383,  356,  195,  356,  193,  356,  440,  397,   93,
 /*   760 */   356,  244,  244,  451,  228,  356,  122,  539,  377,   60,
 /*   770 */   397,   39,  439,  392,  397,   97,  397,   16,  397,  112,
 /*   780 */   477,  400,  397,  110,  288,  468,  467,  397,  100,  218,
 /*   790 */    89,   55,  297,  402,  404,  399,  399,   87,   87,   88,
 /*   800 */    88,   88,   88,  356,   86,   86,   86,   86,   85,   85,
 /*   810 */    84,   84,   84,   83,  279,  356,   19,  229,  139,  356,
 /*   820 */   528,  356,   60,  356,  296,  397,   98,  356,  244,  240,
 /*   830 */   222,  469,  356,  461,  512,   15,  451,  397,   94,  309,
 /*   840 */   392,  397,   96,  397,   51,  397,   23,  141,  386,  397,
 /*   850 */    40,  470,  163,  154,  397,   29,  441,   89,   79,  297,
 /*   860 */   402,  404,  399,  399,   87,   87,   88,   88,   88,   88,
 /*   870 */   447,   86,   86,   86,   86,   85,   85,   84,   84,   84,
 /*   880 */    83,  279,  452,  480,   74,  267,   72,  364,  513,  122,
 /*   890 */   122,  477,  524,  213,  182,  436,  432,  322,  309,  425,
 /*   900 */    54,  472,  294,  181,  241,  209,  315,  392,  514,  269,
 /*   910 */   515,  432,  311,  218,  218,  194,  218,  153,  218,  162,
 /*   920 */   310,  218,  447,  253,  279,   55,  297,  402,  404,  399,
 /*   930 */   399,   87,   87,   88,   88,   88,   88,  391,   86,   86,
 /*   940 */    86,   86,   85,   85,   84,   84,   84,   83,  792,  391,
 /*   950 */   392,  391,  306,  391,  535,  534,  446,  533,  487,  531,
 /*   960 */   371,  270,  243,  471,  211,  266,  263,  481,  216,  297,
 /*   970 */   402,  404,  399,  399,   87,   87,   88,   88,   88,   88,
 /*   980 */   466,   86,   86,   86,   86,   85,   85,   84,   84,   84,
 /*   990 */    83,   77,  359,  221,    4,  465,  450,  540,  283,  259,
 /*  1000 */   538,  115,   77,  359,  555,    4,  326,  357,  235,  283,
 /*  1010 */   197,   65,  265,    5,  329,  434,  247,  326,  384,  491,
 /*  1020 */   140,  464,  382,  369,  358,  482,  521,  245,  474,  537,
 /*  1030 */   476,  437,  230,  389,  369,  334,  390,  301,  128,  157,
 /*  1040 */   433,  553,  339,  503,  389,  550,   59,  434,  435,  554,
 /*  1050 */   389,   67,   75,   76,  456,   71,  207,  116,  257,  132,
 /*  1060 */    77,  325,  321,   75,   76,  375,  411,  536,  412,  143,
 /*  1070 */   142,   77,  325,  321,  220,  123,  375,  324,  485,  493,
 /*  1080 */   420,  210,  375,  287,  271,  479,  185,  494,  478,   77,
 /*  1090 */   359,  505,    4,  136,  546,  202,  283,  516,  372,  372,
 /*  1100 */   372,  373,  374,   14,  326,  105,  278,  338,  156,  372,
 /*  1110 */   372,  372,  373,  374,   14,  372,  372,  372,   63,  504,
 /*  1120 */   316,  369,  419,  164,  225,  327,  239,  203,   68,  217,
 /*  1130 */   520,  389,  196,  158,  201,  368,  453,  495,  438,  135,
 /*  1140 */     8,  361,  405,  492,   90,  376,  285,  426,  124,  276,
 /*  1150 */    75,   76,  557,   56,  104,  333,  530,  501,   77,  325,
 /*  1160 */   321,   66,  251,  375,  191,  272,  320,  205,  126,  249,
 /*  1170 */   234,  233,  106,  127,   18,  448,   99,   95,  246,  204,
 /*  1180 */   532,  417,  170,  174,   11,  178,  418,  219,  167,  445,
 /*  1190 */    61,   62,  121,  519,  262,  406,  372,  372,  372,  373,
 /*  1200 */   374,   14,  275,  107,  159,   15,  184,  248,  517,  511,
 /*  1210 */     6,  595,  182,  183,  120,  176,  594,  117,   92,   78,
 /*  1220 */   332,  388,  293,  119,  102,  137,  258,  502,  401,  335,
 /*  1230 */   108,    7,  172,   64,  240,  379,  101,  346,   12,  264,
 /*  1240 */   148,  103,  547,  354,  349,  134,  558,  166,  545,  414,
 /*  1250 */   138,  199,  462,  459,   13,  133,  175,  367,  224,  236,
 /*  1260 */   131,  536,  130,  280,  150,  536,  536,  536,  202,  118,
 /*  1270 */   536,  536,  536,  536,  536,  536,  536,  536,  536,  536,
 /*  1280 */   536,  536,  536,  536,  536,  536,  536,  536,  536,  536,
 /*  1290 */   536,  536,  351,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  138,  139,  140,   22,   21,  143,   23,   68,   69,
 /*    10 */    70,   71,   16,   73,   74,   75,   76,   77,   78,   79,
 /*    20 */    80,   81,   82,    7,    8,    9,   42,   72,   73,   74,
 /*    30 */    75,   76,   77,   78,   79,   80,   81,   82,  216,  217,
 /*    40 */   218,  219,  134,   59,   60,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,  109,   73,   74,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   16,   16,   87,
 /*    70 */    86,   58,  146,   22,   73,   74,   75,   76,   77,   78,
 /*    80 */    79,   80,   81,   82,   88,   89,   90,   91,   92,   93,
 /*    90 */    94,   95,  106,   42,   23,  113,  110,   46,  102,   86,
 /*   100 */    98,   99,  100,   90,   77,   78,   79,   80,   81,   82,
 /*   110 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   120 */    69,   70,   71,   82,   73,   74,   75,   76,   77,   78,
 /*   130 */    79,   80,   81,   82,   16,  146,  123,  124,  125,  146,
 /*   140 */    12,   22,   90,   91,   92,   93,   94,   95,  155,  156,
 /*   150 */    23,  225,   24,   23,  102,  141,  142,   86,   87,   88,
 /*   160 */    42,  147,   91,   92,   93,   37,  157,   39,  154,  160,
 /*   170 */   161,  162,  179,  180,  103,   43,  187,   59,   60,   61,
 /*   180 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   190 */    19,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   200 */    82,  168,  188,   11,   77,   78,   16,   88,  146,   79,
 /*   210 */    91,   92,   93,   86,   87,  146,   86,   87,    1,    2,
 /*   220 */   146,   25,  103,  146,   97,   29,  237,  213,  154,   97,
 /*   230 */   168,  169,   42,  164,  165,   19,  168,   41,   67,   23,
 /*   240 */   160,   49,  168,  169,  180,  168,  169,  154,  130,   59,
 /*   250 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   260 */    70,   71,  188,   73,   74,   75,   76,   77,   78,   79,
 /*   270 */    80,   81,   82,  175,  176,  154,  180,  215,   16,  199,
 /*   280 */   182,  188,   20,   79,  146,  211,  149,   27,  211,  146,
 /*   290 */    98,   99,  100,  146,   34,  226,  216,  223,  218,  219,
 /*   300 */   223,  109,   86,   87,   42,  146,  168,  169,  146,  188,
 /*   310 */   106,  168,  169,  189,  110,  168,  169,  154,    7,    8,
 /*   320 */   130,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   330 */    68,   69,   70,   71,  213,   73,   74,   75,   76,   77,
 /*   340 */    78,   79,   80,   81,   82,   16,  208,  209,   12,   20,
 /*   350 */   216,  188,  218,  219,  211,  234,   16,   23,   20,  146,
 /*   360 */    24,  224,  215,  200,  201,  228,  223,  154,  205,  207,
 /*   370 */   236,   42,   23,   37,  216,   39,  218,  219,  163,  164,
 /*   380 */   165,  168,  169,   43,  105,   49,  107,  108,   59,   60,
 /*   390 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   400 */    71,  188,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   410 */    81,   82,   16,   88,   20,  146,   91,   92,   93,  146,
 /*   420 */    86,   87,   79,   80,   81,   82,  146,   23,  103,   77,
 /*   430 */    78,   20,   42,   51,   52,   86,   87,   97,   42,  146,
 /*   440 */    44,  226,  102,  105,  146,  107,  108,  113,  168,  169,
 /*   450 */   181,   22,   62,   63,  181,   59,   60,   61,   62,   63,
 /*   460 */    64,   65,   66,   67,   68,   69,   70,   71,  146,   73,
 /*   470 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   16,
 /*   480 */    90,  146,  109,   20,   19,  146,  185,  146,   23,  209,
 /*   490 */    86,   87,  146,  152,  225,  122,  155,  156,  225,  105,
 /*   500 */    22,  107,  108,  168,  169,   42,  146,  168,  169,  187,
 /*   510 */   163,  164,  165,  146,  168,  169,  105,  113,  107,  108,
 /*   520 */    14,   23,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   530 */    67,   68,   69,   70,   71,  146,   73,   74,   75,   76,
 /*   540 */    77,   78,   79,   80,   81,   82,   16,  146,   19,  120,
 /*   550 */    20,   86,   87,  146,  187,  220,  146,  168,  169,   53,
 /*   560 */   146,   55,  223,  146,  109,  146,  160,  161,  162,  168,
 /*   570 */   169,  146,   42,  226,   96,  168,  169,  122,  168,  169,
 /*   580 */   155,  156,  168,  169,   86,  168,  169,  168,  169,   59,
 /*   590 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   600 */    70,   71,  146,   73,   74,   75,   76,   77,   78,   79,
 /*   610 */    80,   81,   82,   16,  146,   98,   99,  100,   21,  146,
 /*   620 */    20,  146,   22,  146,  168,  169,  146,   20,  146,   22,
 /*   630 */   146,  140,  146,   21,  143,   23,  168,  169,  132,   42,
 /*   640 */   111,  168,  169,  168,  169,  168,  169,  146,  168,  169,
 /*   650 */   168,  169,  168,  169,  168,  169,   59,   60,   61,   62,
 /*   660 */    63,   64,   65,   66,   67,   68,   69,   70,   71,  146,
 /*   670 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   680 */    16,  146,  146,  146,  146,   21,  146,   20,  146,   22,
 /*   690 */   146,  168,  169,  146,    0,    1,    2,  146,   86,  146,
 /*   700 */    20,   19,   22,  168,  169,   23,   42,   16,  168,  169,
 /*   710 */   168,  169,  168,  169,   14,  168,  169,  181,  181,  168,
 /*   720 */   169,  168,  169,   59,   60,   61,   62,   63,   64,   65,
 /*   730 */    66,   67,   68,   69,   70,   71,  146,   73,   74,   75,
 /*   740 */    76,   77,   78,   79,   80,   81,   82,   16,  146,  146,
 /*   750 */   123,  124,  146,   53,  146,   55,  146,   22,  168,  169,
 /*   760 */   146,  225,  225,  146,   20,  146,   22,   20,   86,   22,
 /*   770 */   168,  169,  167,   42,  168,  169,  168,  169,  168,  169,
 /*   780 */   175,   90,  168,  169,  181,   89,   90,  168,  169,  146,
 /*   790 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   800 */    69,   70,   71,  146,   73,   74,   75,   76,   77,   78,
 /*   810 */    79,   80,   81,   82,   16,  146,   19,   90,   21,  146,
 /*   820 */    20,  146,   22,  146,  207,  168,  169,  146,  225,  102,
 /*   830 */   187,   30,  146,   20,   18,   22,  146,  168,  169,  146,
 /*   840 */    42,  168,  169,  168,  169,  168,  169,  112,  160,  168,
 /*   850 */   169,   50,  200,  201,  168,  169,  202,   59,   60,   61,
 /*   860 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   870 */   160,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   880 */    82,   16,  166,  167,  129,  146,  131,   20,   20,   22,
 /*   890 */    22,  175,   20,  191,   22,  184,  185,  207,  146,  146,
 /*   900 */   198,  177,  101,  154,  146,  212,  146,   42,   92,  199,
 /*   910 */   184,  185,  146,  146,  146,  154,  146,  154,  146,  154,
 /*   920 */   146,  146,  160,  146,   16,   60,   61,   62,   63,   64,
 /*   930 */    65,   66,   67,   68,   69,   70,   71,  188,   73,   74,
 /*   940 */    75,   76,   77,   78,   79,   80,   81,   82,  132,  188,
 /*   950 */    42,  188,  146,  188,  187,  187,  146,  187,  159,  187,
 /*   960 */   146,  199,  187,  177,  212,  146,  146,  168,  146,   61,
 /*   970 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   980 */   177,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   990 */    82,   16,   17,  146,   19,  146,  146,  146,   23,  146,
 /*  1000 */   146,  146,   16,   17,  146,   19,   31,  146,  144,   23,
 /*  1010 */   230,   19,  146,  190,  231,   23,  146,   31,  227,  146,
 /*  1020 */   190,  176,  227,   48,  222,  148,  193,  171,  171,  193,
 /*  1030 */   171,  171,  192,   58,   48,  172,  188,   15,  186,  111,
 /*  1040 */   171,  151,  115,  151,   58,   33,  235,   23,  159,  151,
 /*  1050 */    58,  120,   77,   78,   79,  129,  221,   59,  196,  183,
 /*  1060 */    85,   86,   87,   77,   78,   90,   96,  193,  172,   77,
 /*  1070 */    78,   85,   86,   87,   95,   19,   90,   97,   86,  170,
 /*  1080 */   170,  210,   90,   40,  193,  178,    6,  145,  159,   16,
 /*  1090 */    17,  145,   19,  214,  145,  109,   23,  183,  123,  124,
 /*  1100 */   125,  126,  127,  128,   31,   19,  173,   15,  150,  123,
 /*  1110 */   124,  125,  126,  127,  128,  123,  124,  125,  129,  233,
 /*  1120 */   151,   48,  178,  183,  170,   38,  232,  210,  118,  195,
 /*  1130 */   145,   58,  151,  150,  210,  114,  204,  170,  170,  214,
 /*  1140 */    22,  153,  170,  170,  119,  197,  151,  151,  151,  173,
 /*  1150 */    77,   78,  136,  235,  238,  151,  193,  151,   85,   86,
 /*  1160 */    87,   97,  203,   90,    5,  203,  117,  210,  186,   10,
 /*  1170 */    11,   12,   13,  186,  229,  204,  174,  158,  194,  174,
 /*  1180 */    17,   20,   22,  112,   19,   26,   20,   28,  121,  113,
 /*  1190 */    67,   67,  101,    1,   35,  106,  123,  124,  125,  126,
 /*  1200 */   127,  128,    5,   19,   97,   22,   47,  132,   49,   45,
 /*  1210 */   116,  111,   22,   54,   45,   56,  111,   32,   19,   19,
 /*  1220 */    44,   20,   36,   97,   19,   21,   20,   17,   90,   16,
 /*  1230 */    19,  116,  111,   19,  102,   20,   19,   44,   22,  135,
 /*  1240 */   111,   14,    1,    3,   57,   20,    4,  111,   20,   11,
 /*  1250 */    19,   44,   20,   20,   19,  121,   94,   98,   99,  100,
 /*  1260 */   112,  239,   19,  104,   19,  239,  239,  239,  109,  101,
 /*  1270 */   239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
 /*  1280 */   239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
 /*  1290 */   239,  239,  133,
};
#define YY_SHIFT_USE_DFLT (-93)
#define YY_SHIFT_MAX 369
static const short yy_shift_ofst[] = {
 /*     0 */   217,  986, 1159,  -16,  986, 1073, 1073, 1073,   71,  -53,
 /*    10 */   396, 1073, 1073, 1073, 1073, 1073,  -45,  127,  192,  349,
 /*    20 */   352,  352,  498,   51,  597,  463,  329,  118,  190,  664,
 /*    30 */   530,  262,  731,  731,  731,  731,  731,  731,  731,  798,
 /*    40 */   731,  731,  731,  731,  731,  731,  731,  731,  731,  731,
 /*    50 */   731,  865,  908,  908,  975, 1073, 1073, 1073, 1073, 1073,
 /*    60 */  1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073,
 /*    70 */  1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073,
 /*    80 */  1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073, 1073,
 /*    90 */  1073, 1073, 1073,  -60,  -60,   -4,    1,    1,   27,  340,
 /*   100 */   343,  349,  349,  349,  349,  349,  816,  349,  349,  498,
 /*   110 */    41,  -93,  -93,  -93,  992,   52,  336,  336,  349,  349,
 /*   120 */   349,  349,  349,  349,  612,  694,  349,  349,  349,  349,
 /*   130 */   349,  349,  349,  349,  612,  373,  455,  -53,  -53,  -53,
 /*   140 */   -93,  -93,   13,   13,  119,  325,  465,  411,  130,  334,
 /*   150 */   128,  404,  394,  338,  216,  349,  349,  349,  349,  349,
 /*   160 */   682,  279,  279,  -18,  349,  349,  349,  349,  279,  801,
 /*   170 */   349,  349,  349,  801,  349,  349,  349,  801,  349,  279,
 /*   180 */   349,  279,  349,  349,  349,  349,  349,  349,  279,  349,
 /*   190 */   -18,   16,  204,  349,  279,  349,  196,    2,  349,  260,
 /*   200 */   627,  260,  -14,  260,  132,  260,  627,  755,  797,  429,
 /*   210 */   260,  429,  478,  735,  -53, 1022,  928,  927,  928, 1012,
 /*   220 */  1024,  928,  931,  926,  998,  970,  979, 1056,  980,  980,
 /*   230 */   931, 1043, 1024, 1080, 1080, 1080,  998, 1086, 1092,  989,
 /*   240 */  1043,  928,  998, 1087,  979,  980, 1010,  928, 1092, 1080,
 /*   250 */   979, 1021,  980, 1056,  980, 1118,  980, 1025,  980,  928,
 /*   260 */   928,  928, 1012, 1086, 1016,  928,  931,  928, 1022, 1064,
 /*   270 */  1064, 1049, 1021, 1022,  979,  -93,  -93,  -93,  -93,  390,
 /*   280 */   506,  700,  517,  529,  680,  171,  667,  311,  744,  747,
 /*   290 */   800,  813,  867,  382,  696,  868,  872,  691,  727,  600,
 /*   300 */   607, 1163, 1161, 1160, 1071, 1165, 1166, 1067, 1076, 1123,
 /*   310 */  1124, 1091, 1192, 1089, 1197, 1184, 1107, 1075, 1183, 1164,
 /*   320 */  1094, 1100, 1190, 1169, 1185, 1105, 1199, 1186, 1200, 1126,
 /*   330 */  1201, 1176, 1205, 1204, 1206, 1210, 1138, 1211, 1213, 1115,
 /*   340 */  1214, 1121, 1215, 1132, 1216, 1193, 1217, 1104, 1129,  -92,
 /*   350 */  1187, 1227, 1241, 1240, 1242, 1225, 1136, 1228, 1238, 1231,
 /*   360 */  1232, 1233, 1207, 1235, 1162, 1134, 1168, 1148, 1243, 1245,
};
#define YY_REDUCE_USE_DFLT (-179)
#define YY_REDUCE_MAX 278
static const short yy_reduce_ofst[] = {
 /*     0 */  -137,   74,   14,   80,  213,  143,   77,  138,   -7,  163,
 /*    10 */   134,   62,  280,  147,  335,  339, -178,   69,  121,  341,
 /*    20 */   215,  347,    9,  158,  158,  158,  158,  158,  158,  158,
 /*    30 */   158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
 /*    40 */   158,  158,  158,  158,  158,  158,  158,  158,  158,  158,
 /*    50 */   158,  158,  158,  158,  346,  389,  401,  407,  410,  414,
 /*    60 */   417,  419,  456,  468,  473,  475,  477,  480,  482,  484,
 /*    70 */   486,  523,  535,  540,  542,  544,  547,  551,  553,  590,
 /*    80 */   602,  606,  608,  610,  614,  619,  657,  669,  673,  675,
 /*    90 */   677,  681,  686,  158,  158,  716,  158,  158,  158,   98,
 /*   100 */   158,  269,  273,  -11,  425,  536,  137,  537,  603,  406,
 /*   110 */   158,  158,  158,  158,  799,  605,  726,  711,  752,  775,
 /*   120 */   690,  693,  -74,  617,  762,  491,  772,  770,  768,  767,
 /*   130 */   162,  643,  367,  322,  710,   93,  749,  761,  763,  765,
 /*   140 */   702,  652,   33,   68,   64,   96,  159,  124,  293,  298,
 /*   150 */   301,  360,  124,  124,  501,  538,  739,  753,  758,  760,
 /*   160 */   688,  124,  124,  654,  766,  774,  293,  777,  124,  724,
 /*   170 */   806,  810,  814,  786,  819,  820,  822,  803,  847,  124,
 /*   180 */   849,  124,  850,  851,  853,  854,  855,  858,  124,  861,
 /*   190 */   654,  864,  823,  866,  124,  870,  780,  783,  873,  856,
 /*   200 */   791,  857,  830,  859,  845,  860,  795,  802,  877,  833,
 /*   210 */   869,  836,  863,  840,  848,  852,  890,  862,  892,  811,
 /*   220 */   889,  898,  874,  835,  876,  896,  871,  879,  909,  910,
 /*   230 */   891,  907,  929,  942,  946,  949,  914,  933,  958,  886,
 /*   240 */   944,  969,  940,  894,  917,  954,  934,  981,  983,  985,
 /*   250 */   924,  932,  967,  925,  968,  988,  972,  948,  973,  995,
 /*   260 */   996,  997,  918,  976,  916, 1004,  963, 1006,  982,  959,
 /*   270 */   962,  984,  971,  987,  957,  945, 1002, 1019, 1005,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   565,  789,  854,  680,  854,  789,  789,  854,  854,  684,
 /*    10 */   840,  854,  854,  854,  785,  789,  760,  811,  854,  854,
 /*    20 */   811,  811,  596,  715,  854,  854,  854,  854,  854,  854,
 /*    30 */   854,  854,  723,  780,  722,  784,  825,  788,  841,  854,
 /*    40 */   716,  696,  720,  729,  713,  728,  704,  717,  844,  781,
 /*    50 */   782,  750,  766,  749,  854,  854,  854,  854,  854,  854,
 /*    60 */   854,  854,  854,  854,  854,  854,  854,  854,  854,  854,
 /*    70 */   854,  854,  854,  854,  854,  854,  854,  854,  854,  854,
 /*    80 */   854,  854,  854,  854,  854,  854,  854,  854,  854,  854,
 /*    90 */   854,  854,  854,  771,  752,  589,  751,  759,  753,  649,
 /*   100 */   754,  854,  854,  854,  854,  854,  584,  854,  854,  854,
 /*   110 */   755,  768,  756,  767,  854,  854,  854,  854,  854,  854,
 /*   120 */   854,  854,  854,  854,  680,  565,  854,  854,  854,  854,
 /*   130 */   854,  854,  854,  854,  680,  854,  854,  854,  854,  854,
 /*   140 */   674,  684,  854,  854,  640,  854,  854,  854,  854,  854,
 /*   150 */   854,  854,  854,  854,  854,  854,  854,  854,  854,  854,
 /*   160 */   598,  832,  586,  682,  854,  854,  854,  854,  830,  854,
 /*   170 */   854,  854,  854,  854,  854,  854,  845,  854,  847,  663,
 /*   180 */   854,  725,  854,  799,  854,  570,  854,  854,  687,  854,
 /*   190 */   688,  572,  672,  854,  661,  854,  817,  854,  854,  707,
 /*   200 */   854,  707,  672,  707,  619,  707,  854,  783,  854,  719,
 /*   210 */   707,  719,  622,  681,  854,  660,  689,  700,  689,  843,
 /*   220 */   854,  689,  719,  854,  653,  622,  708,  730,  651,  651,
 /*   230 */   719,  636,  854,  569,  569,  569,  653,  793,  581,  824,
 /*   240 */   636,  689,  653,  821,  708,  651,  712,  689,  581,  569,
 /*   250 */   708,  699,  651,  730,  651,  639,  651,  714,  651,  689,
 /*   260 */   689,  689,  843,  793,  852,  689,  719,  689,  660,  697,
 /*   270 */   697,  710,  699,  660,  708,  827,  624,  606,  624,  854,
 /*   280 */   854,  854,  854,  737,  854,  806,  854,  854,  854,  854,
 /*   290 */   854,  854,  854,  854,  854,  854,  854,  854,  854,  854,
 /*   300 */   854,  854,  854,  854,  854,  854,  854,  854,  854,  854,
 /*   310 */   854,  854,  854,  666,  854,  854,  854,  854,  711,  854,
 /*   320 */   854,  738,  820,  819,  854,  742,  854,  854,  854,  854,
 /*   330 */   854,  854,  854,  854,  854,  854,  854,  854,  854,  854,
 /*   340 */   854,  739,  854,  854,  701,  854,  854,  854,  854,  854,
 /*   350 */   851,  854,  854,  566,  854,  854,  854,  854,  854,  854,
 /*   360 */   854,  854,  854,  854,  854,  854,  854,  854,  854,  854,
 /*   370 */   561,  740,  741,  743,  744,  736,  669,  592,  599,  600,
 /*   380 */   603,  604,  807,  809,  808,  810,  602,  601,  745,  748,
 /*   390 */   665,  664,  757,  758,  764,  770,  773,  734,  671,  762,
 /*   400 */   763,  765,  769,  670,  772,  617,  667,  668,  776,  706,
 /*   410 */   705,  623,  616,  778,  779,  638,  637,  833,  834,  634,
 /*   420 */   615,  774,  837,  786,  787,  690,  777,  761,  836,  835,
 /*   430 */   657,  656,  655,  702,  591,  709,  652,  703,  614,  607,
 /*   440 */   673,  683,  692,  693,  694,  695,  678,  679,  685,  698,
 /*   450 */   732,  733,  605,  686,  587,  675,  676,  677,  775,  585,
 /*   460 */   735,  746,  747,  618,  625,  626,  627,  630,  631,  632,
 /*   470 */   633,  628,  629,  794,  795,  797,  796,  620,  621,  635,
 /*   480 */   608,  609,  579,  610,  611,  742,  612,  613,  597,  590,
 /*   490 */   641,  644,  645,  646,  578,  647,  648,  650,  642,  643,
 /*   500 */   588,  580,  582,  691,  813,  577,  822,  823,  818,  814,
 /*   510 */   815,  816,  583,  790,  791,  654,  726,  727,  812,  826,
 /*   520 */   576,  828,  575,  574,  731,  573,  595,  594,  829,  593,
 /*   530 */   831,  658,  659,  662,  798,  838,  718,  721,  571,  724,
 /*   540 */   800,  801,  802,  803,  804,  805,  568,  564,  839,  562,
 /*   550 */   842,  563,  560,  846,  848,  849,  850,  853,  567,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*  STATEMENT => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "STATEMENT",     "TRIGGER",       "VACUUM",        "VIEW",        
  "REINDEX",       "RENAME",        "CTIME_KW",      "OR",          
  "AND",           "IS",            "BETWEEN",       "IN",          
  "ISNULL",        "NOTNULL",       "NE",            "EQ",          
  "GT",            "LE",            "LT",            "GE",          
  "ESCAPE",        "BITAND",        "BITOR",         "LSHIFT",      
  "RSHIFT",        "PLUS",          "MINUS",         "STAR",        
  "SLASH",         "REM",           "CONCAT",        "UMINUS",      
  "UPLUS",         "BITNOT",        "STRING",        "JOIN_KW",     
  "CONSTRAINT",    "DEFAULT",       "NULL",          "PRIMARY",     
  "UNIQUE",        "CHECK",         "REFERENCES",    "COLLATE",     
  "AUTOINCR",      "ON",            "DELETE",        "UPDATE",      
  "INSERT",        "SET",           "DEFERRABLE",    "FOREIGN",     
  "DROP",          "UNION",         "ALL",           "EXCEPT",      
  "INTERSECT",     "SELECT",        "DISTINCT",      "DOT",         
  "FROM",          "JOIN",          "USING",         "ORDER",       
  "BY",            "GROUP",         "HAVING",        "LIMIT",       
  "WHERE",         "INTO",          "VALUES",        "INTEGER",     
  "FLOAT",         "BLOB",          "REGISTER",      "VARIABLE",    
  "CASE",          "WHEN",          "THEN",          "ELSE",        
  "INDEX",         "ALTER",         "TO",            "ADD",         
  "COLUMNKW",      "error",         "input",         "cmdlist",     
  "ecmd",          "cmdx",          "cmd",           "explain",     
  "transtype",     "trans_opt",     "nm",            "create_table",
  "create_table_args",  "temp",          "ifnotexists",   "dbnm",        
  "columnlist",    "conslist_opt",  "select",        "column",      
  "columnid",      "type",          "carglist",      "id",          
  "ids",           "typetoken",     "typename",      "signed",      
  "plus_num",      "minus_num",     "carg",          "ccons",       
  "term",          "expr",          "onconf",        "sortorder",   
  "autoinc",       "idxlist_opt",   "refargs",       "defer_subclause",
  "refarg",        "refact",        "init_deferred_pred_opt",  "conslist",    
  "tcons",         "idxlist",       "defer_subclause_opt",  "orconf",      
  "resolvetype",   "raisetype",     "ifexists",      "fullname",    
  "oneselect",     "multiselect_op",  "distinct",      "selcollist",  
  "from",          "where_opt",     "groupby_opt",   "having_opt",  
  "orderby_opt",   "limit_opt",     "sclp",          "as",          
  "seltablist",    "stl_prefix",    "joinop",        "on_opt",      
  "using_opt",     "seltablist_paren",  "joinop2",       "inscollist",  
  "sortlist",      "sortitem",      "collate",       "exprlist",    
  "setlist",       "insert_cmd",    "inscollist_opt",  "itemlist",    
  "likeop",        "escape",        "between_op",    "in_op",       
  "case_operand",  "case_exprlist",  "case_else",     "expritem",    
  "uniqueflag",    "idxitem",       "plus_opt",      "number",      
  "trigger_decl",  "trigger_cmd_list",  "trigger_time",  "trigger_event",
  "foreach_clause",  "when_clause",   "trigger_cmd",   "database_kw_opt",
  "key_opt",       "add_column_fullname",  "kwcolumn_opt",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "carg ::= DEFAULT term",
 /*  51 */ "carg ::= DEFAULT LP expr RP",
 /*  52 */ "carg ::= DEFAULT PLUS term",
 /*  53 */ "carg ::= DEFAULT MINUS term",
 /*  54 */ "carg ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE id",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 144 */ "sortlist ::= sortitem collate sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "collate ::=",
 /* 150 */ "collate ::= COLLATE id",
 /* 151 */ "groupby_opt ::=",
 /* 152 */ "groupby_opt ::= GROUP BY exprlist",
 /* 153 */ "having_opt ::=",
 /* 154 */ "having_opt ::= HAVING expr",
 /* 155 */ "limit_opt ::=",
 /* 156 */ "limit_opt ::= LIMIT expr",
 /* 157 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 158 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 159 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 160 */ "where_opt ::=",
 /* 161 */ "where_opt ::= WHERE expr",
 /* 162 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 163 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 164 */ "setlist ::= nm EQ expr",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 166 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 167 */ "insert_cmd ::= INSERT orconf",
 /* 168 */ "insert_cmd ::= REPLACE",
 /* 169 */ "itemlist ::= itemlist COMMA expr",
 /* 170 */ "itemlist ::= expr",
 /* 171 */ "inscollist_opt ::=",
 /* 172 */ "inscollist_opt ::= LP inscollist RP",
 /* 173 */ "inscollist ::= inscollist COMMA nm",
 /* 174 */ "inscollist ::= nm",
 /* 175 */ "expr ::= term",
 /* 176 */ "expr ::= LP expr RP",
 /* 177 */ "term ::= NULL",
 /* 178 */ "expr ::= ID",
 /* 179 */ "expr ::= JOIN_KW",
 /* 180 */ "expr ::= nm DOT nm",
 /* 181 */ "expr ::= nm DOT nm DOT nm",
 /* 182 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 183 */ "term ::= STRING",
 /* 184 */ "expr ::= REGISTER",
 /* 185 */ "expr ::= VARIABLE",
 /* 186 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 187 */ "expr ::= ID LP distinct exprlist RP",
 /* 188 */ "expr ::= ID LP STAR RP",
 /* 189 */ "term ::= CTIME_KW",
 /* 190 */ "expr ::= expr AND expr",
 /* 191 */ "expr ::= expr OR expr",
 /* 192 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 193 */ "expr ::= expr EQ|NE expr",
 /* 194 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 195 */ "expr ::= expr PLUS|MINUS expr",
 /* 196 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 197 */ "expr ::= expr CONCAT expr",
 /* 198 */ "likeop ::= LIKE_KW",
 /* 199 */ "likeop ::= NOT LIKE_KW",
 /* 200 */ "escape ::= ESCAPE expr",
 /* 201 */ "escape ::=",
 /* 202 */ "expr ::= expr likeop expr escape",
 /* 203 */ "expr ::= expr ISNULL|NOTNULL",
 /* 204 */ "expr ::= expr IS NULL",
 /* 205 */ "expr ::= expr NOT NULL",
 /* 206 */ "expr ::= expr IS NOT NULL",
 /* 207 */ "expr ::= NOT|BITNOT expr",
 /* 208 */ "expr ::= MINUS expr",
 /* 209 */ "expr ::= PLUS expr",
 /* 210 */ "between_op ::= BETWEEN",
 /* 211 */ "between_op ::= NOT BETWEEN",
 /* 212 */ "expr ::= expr between_op expr AND expr",
 /* 213 */ "in_op ::= IN",
 /* 214 */ "in_op ::= NOT IN",
 /* 215 */ "expr ::= expr in_op LP exprlist RP",
 /* 216 */ "expr ::= LP select RP",
 /* 217 */ "expr ::= expr in_op LP select RP",
 /* 218 */ "expr ::= expr in_op nm dbnm",
 /* 219 */ "expr ::= EXISTS LP select RP",
 /* 220 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 221 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 222 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 223 */ "case_else ::= ELSE expr",
 /* 224 */ "case_else ::=",
 /* 225 */ "case_operand ::= expr",
 /* 226 */ "case_operand ::=",
 /* 227 */ "exprlist ::= exprlist COMMA expritem",
 /* 228 */ "exprlist ::= expritem",
 /* 229 */ "expritem ::= expr",
 /* 230 */ "expritem ::=",
 /* 231 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 232 */ "uniqueflag ::= UNIQUE",
 /* 233 */ "uniqueflag ::=",
 /* 234 */ "idxlist_opt ::=",
 /* 235 */ "idxlist_opt ::= LP idxlist RP",
 /* 236 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 237 */ "idxlist ::= idxitem collate sortorder",
 /* 238 */ "idxitem ::= nm",
 /* 239 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 240 */ "cmd ::= VACUUM",
 /* 241 */ "cmd ::= VACUUM nm",
 /* 242 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 243 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 244 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 245 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 246 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 247 */ "cmd ::= PRAGMA nm dbnm",
 /* 248 */ "plus_num ::= plus_opt number",
 /* 249 */ "minus_num ::= MINUS number",
 /* 250 */ "number ::= INTEGER|FLOAT",
 /* 251 */ "plus_opt ::= PLUS",
 /* 252 */ "plus_opt ::=",
 /* 253 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 254 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 255 */ "trigger_time ::= BEFORE",
 /* 256 */ "trigger_time ::= AFTER",
 /* 257 */ "trigger_time ::= INSTEAD OF",
 /* 258 */ "trigger_time ::=",
 /* 259 */ "trigger_event ::= DELETE|INSERT",
 /* 260 */ "trigger_event ::= UPDATE",
 /* 261 */ "trigger_event ::= UPDATE OF inscollist",
 /* 262 */ "foreach_clause ::=",
 /* 263 */ "foreach_clause ::= FOR EACH ROW",
 /* 264 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 265 */ "when_clause ::=",
 /* 266 */ "when_clause ::= WHEN expr",
 /* 267 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 268 */ "trigger_cmd_list ::=",
 /* 269 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 270 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 271 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 272 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 273 */ "trigger_cmd ::= select",
 /* 274 */ "expr ::= RAISE LP IGNORE RP",
 /* 275 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 276 */ "raisetype ::= ROLLBACK",
 /* 277 */ "raisetype ::= ABORT",
 /* 278 */ "raisetype ::= FAIL",
 /* 279 */ "cmd ::= DROP TRIGGER fullname",
 /* 280 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 281 */ "key_opt ::=",
 /* 282 */ "key_opt ::= KEY expr",
 /* 283 */ "database_kw_opt ::= DATABASE",
 /* 284 */ "database_kw_opt ::=",
 /* 285 */ "cmd ::= DETACH database_kw_opt expr",
 /* 286 */ "cmd ::= REINDEX",
 /* 287 */ "cmd ::= REINDEX nm dbnm",
 /* 288 */ "cmd ::= ANALYZE",
 /* 289 */ "cmd ::= ANALYZE nm dbnm",
 /* 290 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 291 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 292 */ "add_column_fullname ::= fullname",
 /* 293 */ "kwcolumn_opt ::=",
 /* 294 */ "kwcolumn_opt ::= COLUMNKW",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 154:
    case 188:
    case 205:
#line 373 "parse.y"
{sqlite3SelectDelete((yypminor->yy239));}
#line 1219 "parse.c"
      break;
    case 168:
    case 169:
    case 193:
    case 195:
    case 203:
    case 209:
    case 217:
    case 220:
    case 222:
    case 223:
    case 233:
#line 630 "parse.y"
{sqlite3ExprDelete((yypminor->yy178));}
#line 1234 "parse.c"
      break;
    case 173:
    case 181:
    case 191:
    case 194:
    case 196:
    case 198:
    case 208:
    case 211:
    case 212:
    case 215:
    case 221:
#line 861 "parse.y"
{sqlite3ExprListDelete((yypminor->yy462));}
#line 1249 "parse.c"
      break;
    case 187:
    case 192:
    case 200:
    case 201:
#line 501 "parse.y"
{sqlite3SrcListDelete((yypminor->yy285));}
#line 1257 "parse.c"
      break;
    case 197:
#line 562 "parse.y"
{
  sqlite3ExprDelete((yypminor->yy270).pLimit);
  sqlite3ExprDelete((yypminor->yy270).pOffset);
}
#line 1265 "parse.c"
      break;
    case 204:
    case 207:
    case 214:
#line 518 "parse.y"
{sqlite3IdListDelete((yypminor->yy160));}
#line 1272 "parse.c"
      break;
    case 229:
    case 234:
#line 955 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy247));}
#line 1278 "parse.c"
      break;
    case 231:
#line 939 "parse.y"
{sqlite3IdListDelete((yypminor->yy132).b);}
#line 1283 "parse.c"
      break;
    case 236:
#line 1023 "parse.y"
{sqlite3ExprDelete((yypminor->yy292));}
#line 1288 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
#line 44 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1441 "parse.c"
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 138, 1 },
  { 139, 2 },
  { 139, 1 },
  { 141, 1 },
  { 140, 1 },
  { 140, 3 },
  { 143, 0 },
  { 143, 1 },
  { 143, 3 },
  { 142, 3 },
  { 145, 0 },
  { 145, 1 },
  { 145, 2 },
  { 144, 0 },
  { 144, 1 },
  { 144, 1 },
  { 144, 1 },
  { 142, 2 },
  { 142, 2 },
  { 142, 2 },
  { 142, 2 },
  { 147, 6 },
  { 150, 0 },
  { 150, 3 },
  { 149, 1 },
  { 149, 0 },
  { 148, 4 },
  { 148, 2 },
  { 152, 3 },
  { 152, 1 },
  { 155, 3 },
  { 156, 1 },
  { 159, 1 },
  { 160, 1 },
  { 146, 1 },
  { 146, 1 },
  { 146, 1 },
  { 157, 0 },
  { 157, 1 },
  { 161, 1 },
  { 161, 4 },
  { 161, 6 },
  { 162, 1 },
  { 162, 2 },
  { 163, 1 },
  { 163, 1 },
  { 158, 2 },
  { 158, 0 },
  { 166, 3 },
  { 166, 1 },
  { 166, 2 },
  { 166, 4 },
  { 166, 3 },
  { 166, 3 },
  { 166, 2 },
  { 167, 2 },
  { 167, 3 },
  { 167, 5 },
  { 167, 2 },
  { 167, 4 },
  { 167, 4 },
  { 167, 1 },
  { 167, 2 },
  { 172, 0 },
  { 172, 1 },
  { 174, 0 },
  { 174, 2 },
  { 176, 2 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 177, 2 },
  { 177, 2 },
  { 177, 1 },
  { 177, 1 },
  { 175, 3 },
  { 175, 2 },
  { 178, 0 },
  { 178, 2 },
  { 178, 2 },
  { 153, 0 },
  { 153, 2 },
  { 179, 3 },
  { 179, 2 },
  { 179, 1 },
  { 180, 2 },
  { 180, 7 },
  { 180, 5 },
  { 180, 5 },
  { 180, 10 },
  { 182, 0 },
  { 182, 1 },
  { 170, 0 },
  { 170, 3 },
  { 183, 0 },
  { 183, 2 },
  { 184, 1 },
  { 184, 1 },
  { 184, 1 },
  { 142, 4 },
  { 186, 2 },
  { 186, 0 },
  { 142, 7 },
  { 142, 4 },
  { 142, 1 },
  { 154, 1 },
  { 154, 3 },
  { 189, 1 },
  { 189, 2 },
  { 189, 1 },
  { 188, 9 },
  { 190, 1 },
  { 190, 1 },
  { 190, 0 },
  { 198, 2 },
  { 198, 0 },
  { 191, 3 },
  { 191, 2 },
  { 191, 4 },
  { 199, 2 },
  { 199, 1 },
  { 199, 0 },
  { 192, 0 },
  { 192, 2 },
  { 201, 2 },
  { 201, 0 },
  { 200, 6 },
  { 200, 7 },
  { 205, 1 },
  { 205, 1 },
  { 151, 0 },
  { 151, 2 },
  { 187, 2 },
  { 202, 1 },
  { 202, 2 },
  { 202, 3 },
  { 202, 4 },
  { 203, 2 },
  { 203, 0 },
  { 204, 4 },
  { 204, 0 },
  { 196, 0 },
  { 196, 3 },
  { 208, 5 },
  { 208, 3 },
  { 209, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 0 },
  { 210, 0 },
  { 210, 2 },
  { 194, 0 },
  { 194, 3 },
  { 195, 0 },
  { 195, 2 },
  { 197, 0 },
  { 197, 2 },
  { 197, 4 },
  { 197, 4 },
  { 142, 4 },
  { 193, 0 },
  { 193, 2 },
  { 142, 6 },
  { 212, 5 },
  { 212, 3 },
  { 142, 8 },
  { 142, 5 },
  { 213, 2 },
  { 213, 1 },
  { 215, 3 },
  { 215, 1 },
  { 214, 0 },
  { 214, 3 },
  { 207, 3 },
  { 207, 1 },
  { 169, 1 },
  { 169, 3 },
  { 168, 1 },
  { 169, 1 },
  { 169, 1 },
  { 169, 3 },
  { 169, 5 },
  { 168, 1 },
  { 168, 1 },
  { 169, 1 },
  { 169, 1 },
  { 169, 6 },
  { 169, 5 },
  { 169, 4 },
  { 168, 1 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 169, 3 },
  { 216, 1 },
  { 216, 2 },
  { 217, 2 },
  { 217, 0 },
  { 169, 4 },
  { 169, 2 },
  { 169, 3 },
  { 169, 3 },
  { 169, 4 },
  { 169, 2 },
  { 169, 2 },
  { 169, 2 },
  { 218, 1 },
  { 218, 2 },
  { 169, 5 },
  { 219, 1 },
  { 219, 2 },
  { 169, 5 },
  { 169, 3 },
  { 169, 5 },
  { 169, 4 },
  { 169, 4 },
  { 169, 5 },
  { 221, 5 },
  { 221, 4 },
  { 222, 2 },
  { 222, 0 },
  { 220, 1 },
  { 220, 0 },
  { 211, 3 },
  { 211, 1 },
  { 223, 1 },
  { 223, 0 },
  { 142, 11 },
  { 224, 1 },
  { 224, 0 },
  { 173, 0 },
  { 173, 3 },
  { 181, 5 },
  { 181, 3 },
  { 225, 1 },
  { 142, 4 },
  { 142, 1 },
  { 142, 2 },
  { 142, 5 },
  { 142, 5 },
  { 142, 5 },
  { 142, 5 },
  { 142, 6 },
  { 142, 3 },
  { 164, 2 },
  { 165, 2 },
  { 227, 1 },
  { 226, 1 },
  { 226, 0 },
  { 142, 5 },
  { 228, 10 },
  { 230, 1 },
  { 230, 1 },
  { 230, 2 },
  { 230, 0 },
  { 231, 1 },
  { 231, 1 },
  { 231, 3 },
  { 232, 0 },
  { 232, 3 },
  { 232, 3 },
  { 233, 0 },
  { 233, 2 },
  { 229, 3 },
  { 229, 0 },
  { 234, 6 },
  { 234, 8 },
  { 234, 5 },
  { 234, 4 },
  { 234, 1 },
  { 169, 4 },
  { 169, 6 },
  { 185, 1 },
  { 185, 1 },
  { 185, 1 },
  { 142, 3 },
  { 142, 6 },
  { 236, 0 },
  { 236, 2 },
  { 235, 1 },
  { 235, 0 },
  { 142, 3 },
  { 142, 1 },
  { 142, 3 },
  { 142, 1 },
  { 142, 3 },
  { 142, 6 },
  { 142, 6 },
  { 237, 1 },
  { 238, 0 },
  { 238, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 100 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1814 "parse.c"
        break;
      case 6:
#line 103 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1819 "parse.c"
        break;
      case 7:
#line 105 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1824 "parse.c"
        break;
      case 8:
#line 106 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1829 "parse.c"
        break;
      case 9:
#line 112 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy230);}
#line 1834 "parse.c"
        break;
      case 13:
#line 117 "parse.y"
{yygotominor.yy230 = TK_DEFERRED;}
#line 1839 "parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 107:
      case 109:
#line 118 "parse.y"
{yygotominor.yy230 = yymsp[0].major;}
#line 1848 "parse.c"
        break;
      case 17:
      case 18:
#line 121 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1854 "parse.c"
        break;
      case 19:
#line 123 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1859 "parse.c"
        break;
      case 21:
#line 128 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy384,&yymsp[0].minor.yy384,yymsp[-4].minor.yy230,0,yymsp[-2].minor.yy230);
}
#line 1866 "parse.c"
        break;
      case 22:
      case 25:
      case 63:
      case 77:
      case 79:
      case 90:
      case 101:
      case 112:
      case 113:
      case 210:
      case 213:
#line 132 "parse.y"
{yygotominor.yy230 = 0;}
#line 1881 "parse.c"
        break;
      case 23:
      case 24:
      case 64:
      case 78:
      case 100:
      case 111:
      case 211:
      case 214:
#line 133 "parse.y"
{yygotominor.yy230 = 1;}
#line 1893 "parse.c"
        break;
      case 26:
#line 139 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy384,&yymsp[0].minor.yy0,0);
}
#line 1900 "parse.c"
        break;
      case 27:
#line 142 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy239);
  sqlite3SelectDelete(yymsp[0].minor.yy239);
}
#line 1908 "parse.c"
        break;
      case 30:
#line 154 "parse.y"
{
  yygotominor.yy384.z = yymsp[-2].minor.yy384.z;
  yygotominor.yy384.n = (pParse->sLastToken.z-yymsp[-2].minor.yy384.z) + pParse->sLastToken.n;
}
#line 1916 "parse.c"
        break;
      case 31:
#line 158 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy384);
  yygotominor.yy384 = yymsp[0].minor.yy384;
}
#line 1924 "parse.c"
        break;
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 250:
#line 168 "parse.y"
{yygotominor.yy384 = yymsp[0].minor.yy0;}
#line 1934 "parse.c"
        break;
      case 38:
#line 227 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy384);}
#line 1939 "parse.c"
        break;
      case 39:
      case 42:
      case 119:
      case 120:
      case 131:
      case 150:
      case 238:
      case 248:
      case 249:
#line 228 "parse.y"
{yygotominor.yy384 = yymsp[0].minor.yy384;}
#line 1952 "parse.c"
        break;
      case 40:
#line 229 "parse.y"
{
  yygotominor.yy384.z = yymsp[-3].minor.yy384.z;
  yygotominor.yy384.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy384.z;
}
#line 1960 "parse.c"
        break;
      case 41:
#line 233 "parse.y"
{
  yygotominor.yy384.z = yymsp[-5].minor.yy384.z;
  yygotominor.yy384.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy384.z;
}
#line 1968 "parse.c"
        break;
      case 43:
#line 239 "parse.y"
{yygotominor.yy384.z=yymsp[-1].minor.yy384.z; yygotominor.yy384.n=yymsp[0].minor.yy384.n+(yymsp[0].minor.yy384.z-yymsp[-1].minor.yy384.z);}
#line 1973 "parse.c"
        break;
      case 44:
#line 241 "parse.y"
{ yygotominor.yy230 = atoi((char*)yymsp[0].minor.yy384.z); }
#line 1978 "parse.c"
        break;
      case 45:
#line 242 "parse.y"
{ yygotominor.yy230 = -atoi((char*)yymsp[0].minor.yy384.z); }
#line 1983 "parse.c"
        break;
      case 50:
      case 52:
#line 251 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy178);}
#line 1989 "parse.c"
        break;
      case 51:
#line 252 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy178);}
#line 1994 "parse.c"
        break;
      case 53:
#line 254 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy178, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2002 "parse.c"
        break;
      case 54:
#line 258 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy384);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2010 "parse.c"
        break;
      case 56:
#line 267 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy230);}
#line 2015 "parse.c"
        break;
      case 57:
#line 269 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy230,yymsp[0].minor.yy230,yymsp[-2].minor.yy230);}
#line 2020 "parse.c"
        break;
      case 58:
#line 270 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy230,0,0,0,0);}
#line 2025 "parse.c"
        break;
      case 59:
#line 271 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy178);}
#line 2030 "parse.c"
        break;
      case 60:
#line 273 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy384,yymsp[-1].minor.yy462,yymsp[0].minor.yy230);}
#line 2035 "parse.c"
        break;
      case 61:
#line 274 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy230);}
#line 2040 "parse.c"
        break;
      case 62:
#line 275 "parse.y"
{sqlite3AddCollateType(pParse, (char*)yymsp[0].minor.yy384.z, yymsp[0].minor.yy384.n);}
#line 2045 "parse.c"
        break;
      case 65:
#line 288 "parse.y"
{ yygotominor.yy230 = OE_Restrict * 0x010101; }
#line 2050 "parse.c"
        break;
      case 66:
#line 289 "parse.y"
{ yygotominor.yy230 = (yymsp[-1].minor.yy230 & yymsp[0].minor.yy13.mask) | yymsp[0].minor.yy13.value; }
#line 2055 "parse.c"
        break;
      case 67:
#line 291 "parse.y"
{ yygotominor.yy13.value = 0;     yygotominor.yy13.mask = 0x000000; }
#line 2060 "parse.c"
        break;
      case 68:
#line 292 "parse.y"
{ yygotominor.yy13.value = yymsp[0].minor.yy230;     yygotominor.yy13.mask = 0x0000ff; }
#line 2065 "parse.c"
        break;
      case 69:
#line 293 "parse.y"
{ yygotominor.yy13.value = yymsp[0].minor.yy230<<8;  yygotominor.yy13.mask = 0x00ff00; }
#line 2070 "parse.c"
        break;
      case 70:
#line 294 "parse.y"
{ yygotominor.yy13.value = yymsp[0].minor.yy230<<16; yygotominor.yy13.mask = 0xff0000; }
#line 2075 "parse.c"
        break;
      case 71:
#line 296 "parse.y"
{ yygotominor.yy230 = OE_SetNull; }
#line 2080 "parse.c"
        break;
      case 72:
#line 297 "parse.y"
{ yygotominor.yy230 = OE_SetDflt; }
#line 2085 "parse.c"
        break;
      case 73:
#line 298 "parse.y"
{ yygotominor.yy230 = OE_Cascade; }
#line 2090 "parse.c"
        break;
      case 74:
#line 299 "parse.y"
{ yygotominor.yy230 = OE_Restrict; }
#line 2095 "parse.c"
        break;
      case 75:
      case 76:
      case 91:
      case 93:
      case 95:
      case 96:
      case 167:
#line 301 "parse.y"
{yygotominor.yy230 = yymsp[0].minor.yy230;}
#line 2106 "parse.c"
        break;
      case 80:
#line 311 "parse.y"
{yygotominor.yy384.n = 0; yygotominor.yy384.z = 0;}
#line 2111 "parse.c"
        break;
      case 81:
#line 312 "parse.y"
{yygotominor.yy384 = yymsp[-1].minor.yy0;}
#line 2116 "parse.c"
        break;
      case 86:
#line 318 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy462,yymsp[0].minor.yy230,yymsp[-2].minor.yy230,0);}
#line 2121 "parse.c"
        break;
      case 87:
#line 320 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy462,yymsp[0].minor.yy230,0,0,0,0);}
#line 2126 "parse.c"
        break;
      case 88:
#line 321 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy178);}
#line 2131 "parse.c"
        break;
      case 89:
#line 323 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy462, &yymsp[-3].minor.yy384, yymsp[-2].minor.yy462, yymsp[-1].minor.yy230);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy230);
}
#line 2139 "parse.c"
        break;
      case 92:
      case 94:
#line 337 "parse.y"
{yygotominor.yy230 = OE_Default;}
#line 2145 "parse.c"
        break;
      case 97:
#line 342 "parse.y"
{yygotominor.yy230 = OE_Ignore;}
#line 2150 "parse.c"
        break;
      case 98:
      case 168:
#line 343 "parse.y"
{yygotominor.yy230 = OE_Replace;}
#line 2156 "parse.c"
        break;
      case 99:
#line 347 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy285, 0, yymsp[-1].minor.yy230);
}
#line 2163 "parse.c"
        break;
      case 102:
#line 357 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy384, &yymsp[-2].minor.yy384, yymsp[0].minor.yy239, yymsp[-5].minor.yy230);
}
#line 2170 "parse.c"
        break;
      case 103:
#line 360 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy285, 1, yymsp[-1].minor.yy230);
}
#line 2177 "parse.c"
        break;
      case 104:
#line 367 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy239, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy239);
}
#line 2185 "parse.c"
        break;
      case 105:
      case 128:
#line 377 "parse.y"
{yygotominor.yy239 = yymsp[0].minor.yy239;}
#line 2191 "parse.c"
        break;
      case 106:
#line 379 "parse.y"
{
  if( yymsp[0].minor.yy239 ){
    yymsp[0].minor.yy239->op = yymsp[-1].minor.yy230;
    yymsp[0].minor.yy239->pPrior = yymsp[-2].minor.yy239;
  }
  yygotominor.yy239 = yymsp[0].minor.yy239;
}
#line 2202 "parse.c"
        break;
      case 108:
#line 388 "parse.y"
{yygotominor.yy230 = TK_ALL;}
#line 2207 "parse.c"
        break;
      case 110:
#line 392 "parse.y"
{
  yygotominor.yy239 = sqlite3SelectNew(yymsp[-6].minor.yy462,yymsp[-5].minor.yy285,yymsp[-4].minor.yy178,yymsp[-3].minor.yy462,yymsp[-2].minor.yy178,yymsp[-1].minor.yy462,yymsp[-7].minor.yy230,yymsp[0].minor.yy270.pLimit,yymsp[0].minor.yy270.pOffset);
}
#line 2214 "parse.c"
        break;
      case 114:
      case 235:
#line 413 "parse.y"
{yygotominor.yy462 = yymsp[-1].minor.yy462;}
#line 2220 "parse.c"
        break;
      case 115:
      case 141:
      case 151:
      case 234:
#line 414 "parse.y"
{yygotominor.yy462 = 0;}
#line 2228 "parse.c"
        break;
      case 116:
#line 415 "parse.y"
{
   yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-2].minor.yy462,yymsp[-1].minor.yy178,yymsp[0].minor.yy384.n?&yymsp[0].minor.yy384:0);
}
#line 2235 "parse.c"
        break;
      case 117:
#line 418 "parse.y"
{
  yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-1].minor.yy462, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2242 "parse.c"
        break;
      case 118:
#line 421 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy384);
  yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-3].minor.yy462, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2251 "parse.c"
        break;
      case 121:
#line 433 "parse.y"
{yygotominor.yy384.n = 0;}
#line 2256 "parse.c"
        break;
      case 122:
#line 445 "parse.y"
{yygotominor.yy285 = sqliteMalloc(sizeof(*yygotominor.yy285));}
#line 2261 "parse.c"
        break;
      case 123:
#line 446 "parse.y"
{yygotominor.yy285 = yymsp[0].minor.yy285;}
#line 2266 "parse.c"
        break;
      case 124:
#line 451 "parse.y"
{
   yygotominor.yy285 = yymsp[-1].minor.yy285;
   if( yygotominor.yy285 && yygotominor.yy285->nSrc>0 ) yygotominor.yy285->a[yygotominor.yy285->nSrc-1].jointype = yymsp[0].minor.yy230;
}
#line 2274 "parse.c"
        break;
      case 125:
#line 455 "parse.y"
{yygotominor.yy285 = 0;}
#line 2279 "parse.c"
        break;
      case 126:
#line 456 "parse.y"
{
  yygotominor.yy285 = sqlite3SrcListAppend(yymsp[-5].minor.yy285,&yymsp[-4].minor.yy384,&yymsp[-3].minor.yy384);
  if( yymsp[-2].minor.yy384.n ) sqlite3SrcListAddAlias(yygotominor.yy285,&yymsp[-2].minor.yy384);
  if( yymsp[-1].minor.yy178 ){
    if( yygotominor.yy285 && yygotominor.yy285->nSrc>1 ){ yygotominor.yy285->a[yygotominor.yy285->nSrc-2].pOn = yymsp[-1].minor.yy178; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy178); }
  }
  if( yymsp[0].minor.yy160 ){
    if( yygotominor.yy285 && yygotominor.yy285->nSrc>1 ){ yygotominor.yy285->a[yygotominor.yy285->nSrc-2].pUsing = yymsp[0].minor.yy160; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy160); }
  }
}
#line 2295 "parse.c"
        break;
      case 127:
#line 470 "parse.y"
{
    yygotominor.yy285 = sqlite3SrcListAppend(yymsp[-6].minor.yy285,0,0);
    yygotominor.yy285->a[yygotominor.yy285->nSrc-1].pSelect = yymsp[-4].minor.yy239;
    if( yymsp[-2].minor.yy384.n ) sqlite3SrcListAddAlias(yygotominor.yy285,&yymsp[-2].minor.yy384);
    if( yymsp[-1].minor.yy178 ){
      if( yygotominor.yy285 && yygotominor.yy285->nSrc>1 ){ yygotominor.yy285->a[yygotominor.yy285->nSrc-2].pOn = yymsp[-1].minor.yy178; }
      else { sqlite3ExprDelete(yymsp[-1].minor.yy178); }
    }
    if( yymsp[0].minor.yy160 ){
      if( yygotominor.yy285 && yygotominor.yy285->nSrc>1 ){ yygotominor.yy285->a[yygotominor.yy285->nSrc-2].pUsing = yymsp[0].minor.yy160; }
      else { sqlite3IdListDelete(yymsp[0].minor.yy160); }
    }
  }
#line 2312 "parse.c"
        break;
      case 129:
#line 491 "parse.y"
{
     yygotominor.yy239 = sqlite3SelectNew(0,yymsp[0].minor.yy285,0,0,0,0,0,0,0);
  }
#line 2319 "parse.c"
        break;
      case 130:
#line 497 "parse.y"
{yygotominor.yy384.z=0; yygotominor.yy384.n=0;}
#line 2324 "parse.c"
        break;
      case 132:
#line 502 "parse.y"
{yygotominor.yy285 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy384,&yymsp[0].minor.yy384);}
#line 2329 "parse.c"
        break;
      case 133:
#line 506 "parse.y"
{ yygotominor.yy230 = JT_INNER; }
#line 2334 "parse.c"
        break;
      case 134:
#line 507 "parse.y"
{ yygotominor.yy230 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2339 "parse.c"
        break;
      case 135:
#line 508 "parse.y"
{ yygotominor.yy230 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy384,0); }
#line 2344 "parse.c"
        break;
      case 136:
#line 510 "parse.y"
{ yygotominor.yy230 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy384,&yymsp[-1].minor.yy384); }
#line 2349 "parse.c"
        break;
      case 137:
      case 145:
      case 154:
      case 161:
      case 175:
      case 200:
      case 223:
      case 225:
      case 229:
#line 514 "parse.y"
{yygotominor.yy178 = yymsp[0].minor.yy178;}
#line 2362 "parse.c"
        break;
      case 138:
      case 153:
      case 160:
      case 201:
      case 224:
      case 226:
      case 230:
#line 515 "parse.y"
{yygotominor.yy178 = 0;}
#line 2373 "parse.c"
        break;
      case 139:
      case 172:
#line 519 "parse.y"
{yygotominor.yy160 = yymsp[-1].minor.yy160;}
#line 2379 "parse.c"
        break;
      case 140:
      case 171:
#line 520 "parse.y"
{yygotominor.yy160 = 0;}
#line 2385 "parse.c"
        break;
      case 142:
      case 152:
#line 531 "parse.y"
{yygotominor.yy462 = yymsp[0].minor.yy462;}
#line 2391 "parse.c"
        break;
      case 143:
#line 532 "parse.y"
{
  yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-4].minor.yy462,yymsp[-2].minor.yy178,yymsp[-1].minor.yy384.n>0?&yymsp[-1].minor.yy384:0);
  if( yygotominor.yy462 ) yygotominor.yy462->a[yygotominor.yy462->nExpr-1].sortOrder = yymsp[0].minor.yy230;
}
#line 2399 "parse.c"
        break;
      case 144:
#line 536 "parse.y"
{
  yygotominor.yy462 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy178,yymsp[-1].minor.yy384.n>0?&yymsp[-1].minor.yy384:0);
  if( yygotominor.yy462 && yygotominor.yy462->a ) yygotominor.yy462->a[0].sortOrder = yymsp[0].minor.yy230;
}
#line 2407 "parse.c"
        break;
      case 146:
      case 148:
#line 545 "parse.y"
{yygotominor.yy230 = SQLITE_SO_ASC;}
#line 2413 "parse.c"
        break;
      case 147:
#line 546 "parse.y"
{yygotominor.yy230 = SQLITE_SO_DESC;}
#line 2418 "parse.c"
        break;
      case 149:
#line 548 "parse.y"
{yygotominor.yy384.z = 0; yygotominor.yy384.n = 0;}
#line 2423 "parse.c"
        break;
      case 155:
#line 566 "parse.y"
{yygotominor.yy270.pLimit = 0; yygotominor.yy270.pOffset = 0;}
#line 2428 "parse.c"
        break;
      case 156:
#line 567 "parse.y"
{yygotominor.yy270.pLimit = yymsp[0].minor.yy178; yygotominor.yy270.pOffset = 0;}
#line 2433 "parse.c"
        break;
      case 157:
#line 569 "parse.y"
{yygotominor.yy270.pLimit = yymsp[-2].minor.yy178; yygotominor.yy270.pOffset = yymsp[0].minor.yy178;}
#line 2438 "parse.c"
        break;
      case 158:
#line 571 "parse.y"
{yygotominor.yy270.pOffset = yymsp[-2].minor.yy178; yygotominor.yy270.pLimit = yymsp[0].minor.yy178;}
#line 2443 "parse.c"
        break;
      case 159:
#line 575 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy285,yymsp[0].minor.yy178);}
#line 2448 "parse.c"
        break;
      case 162:
#line 586 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy285,yymsp[-1].minor.yy462,yymsp[0].minor.yy178,yymsp[-4].minor.yy230);}
#line 2453 "parse.c"
        break;
      case 163:
#line 592 "parse.y"
{yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-4].minor.yy462,yymsp[0].minor.yy178,&yymsp[-2].minor.yy384);}
#line 2458 "parse.c"
        break;
      case 164:
#line 593 "parse.y"
{yygotominor.yy462 = sqlite3ExprListAppend(0,yymsp[0].minor.yy178,&yymsp[-2].minor.yy384);}
#line 2463 "parse.c"
        break;
      case 165:
#line 599 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy285, yymsp[-1].minor.yy462, 0, yymsp[-4].minor.yy160, yymsp[-7].minor.yy230);}
#line 2468 "parse.c"
        break;
      case 166:
#line 601 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy285, 0, yymsp[0].minor.yy239, yymsp[-1].minor.yy160, yymsp[-4].minor.yy230);}
#line 2473 "parse.c"
        break;
      case 169:
      case 227:
#line 611 "parse.y"
{yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-2].minor.yy462,yymsp[0].minor.yy178,0);}
#line 2479 "parse.c"
        break;
      case 170:
      case 228:
#line 612 "parse.y"
{yygotominor.yy462 = sqlite3ExprListAppend(0,yymsp[0].minor.yy178,0);}
#line 2485 "parse.c"
        break;
      case 173:
#line 621 "parse.y"
{yygotominor.yy160 = sqlite3IdListAppend(yymsp[-2].minor.yy160,&yymsp[0].minor.yy384);}
#line 2490 "parse.c"
        break;
      case 174:
#line 622 "parse.y"
{yygotominor.yy160 = sqlite3IdListAppend(0,&yymsp[0].minor.yy384);}
#line 2495 "parse.c"
        break;
      case 176:
#line 633 "parse.y"
{yygotominor.yy178 = yymsp[-1].minor.yy178; sqlite3ExprSpan(yygotominor.yy178,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2500 "parse.c"
        break;
      case 177:
      case 182:
      case 183:
#line 634 "parse.y"
{yygotominor.yy178 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2507 "parse.c"
        break;
      case 178:
      case 179:
#line 635 "parse.y"
{yygotominor.yy178 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2513 "parse.c"
        break;
      case 180:
#line 637 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy384);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy384);
  yygotominor.yy178 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2522 "parse.c"
        break;
      case 181:
#line 642 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy384);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy384);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy384);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy178 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2533 "parse.c"
        break;
      case 184:
#line 651 "parse.y"
{yygotominor.yy178 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2538 "parse.c"
        break;
      case 185:
#line 652 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy178 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2547 "parse.c"
        break;
      case 186:
#line 658 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_CAST, yymsp[-3].minor.yy178, 0, &yymsp[-1].minor.yy384);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2555 "parse.c"
        break;
      case 187:
#line 663 "parse.y"
{
  yygotominor.yy178 = sqlite3ExprFunction(yymsp[-1].minor.yy462, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy230 && yygotominor.yy178 ){
    yygotominor.yy178->flags |= EP_Distinct;
  }
}
#line 2566 "parse.c"
        break;
      case 188:
#line 670 "parse.y"
{
  yygotominor.yy178 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2574 "parse.c"
        break;
      case 189:
#line 674 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy178 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy178 ) yygotominor.yy178->op = TK_CONST_FUNC;  
}
#line 2584 "parse.c"
        break;
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
#line 680 "parse.y"
{yygotominor.yy178 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy178, yymsp[0].minor.yy178, 0);}
#line 2596 "parse.c"
        break;
      case 198:
#line 690 "parse.y"
{yygotominor.yy440.eOperator = yymsp[0].minor.yy0; yygotominor.yy440.not = 0;}
#line 2601 "parse.c"
        break;
      case 199:
#line 691 "parse.y"
{yygotominor.yy440.eOperator = yymsp[0].minor.yy0; yygotominor.yy440.not = 1;}
#line 2606 "parse.c"
        break;
      case 202:
#line 696 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy178, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy178, 0);
  if( yymsp[0].minor.yy178 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy178, 0);
  }
  yygotominor.yy178 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy440.eOperator);
  if( yymsp[-2].minor.yy440.not ) yygotominor.yy178 = sqlite3Expr(TK_NOT, yygotominor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178, &yymsp[-3].minor.yy178->span, &yymsp[-1].minor.yy178->span);
}
#line 2621 "parse.c"
        break;
      case 203:
#line 708 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(yymsp[0].major, yymsp[-1].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-1].minor.yy178->span,&yymsp[0].minor.yy0);
}
#line 2629 "parse.c"
        break;
      case 204:
#line 712 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-2].minor.yy178->span,&yymsp[0].minor.yy0);
}
#line 2637 "parse.c"
        break;
      case 205:
#line 716 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-2].minor.yy178->span,&yymsp[0].minor.yy0);
}
#line 2645 "parse.c"
        break;
      case 206:
#line 720 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-3].minor.yy178->span,&yymsp[0].minor.yy0);
}
#line 2653 "parse.c"
        break;
      case 207:
#line 724 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy178->span);
}
#line 2661 "parse.c"
        break;
      case 208:
#line 728 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy178->span);
}
#line 2669 "parse.c"
        break;
      case 209:
#line 732 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy178->span);
}
#line 2677 "parse.c"
        break;
      case 212:
#line 739 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy178, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy178, 0);
  yygotominor.yy178 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy178, 0, 0);
  if( yygotominor.yy178 ){
    yygotominor.yy178->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy230 ) yygotominor.yy178 = sqlite3Expr(TK_NOT, yygotominor.yy178, 0, 0);
  sqlite3ExprSpan(yygotominor.yy178,&yymsp[-4].minor.yy178->span,&yymsp[0].minor.yy178->span);
}
#line 2693 "parse.c"
        break;
      case 215:
#line 755 "parse.y"
{
    yygotominor.yy178 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy178, 0, 0);
    if( yygotominor.yy178 ){
      yygotominor.yy178->pList = yymsp[-1].minor.yy462;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy462);
    }
    if( yymsp[-3].minor.yy230 ) yygotominor.yy178 = sqlite3Expr(TK_NOT, yygotominor.yy178, 0, 0);
    sqlite3ExprSpan(yygotominor.yy178,&yymsp[-4].minor.yy178->span,&yymsp[0].minor.yy0);
  }
#line 2707 "parse.c"
        break;
      case 216:
#line 765 "parse.y"
{
    yygotominor.yy178 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy178 ){
      yygotominor.yy178->pSelect = yymsp[-1].minor.yy239;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy239);
    }
    sqlite3ExprSpan(yygotominor.yy178,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2720 "parse.c"
        break;
      case 217:
#line 774 "parse.y"
{
    yygotominor.yy178 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy178, 0, 0);
    if( yygotominor.yy178 ){
      yygotominor.yy178->pSelect = yymsp[-1].minor.yy239;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy239);
    }
    if( yymsp[-3].minor.yy230 ) yygotominor.yy178 = sqlite3Expr(TK_NOT, yygotominor.yy178, 0, 0);
    sqlite3ExprSpan(yygotominor.yy178,&yymsp[-4].minor.yy178->span,&yymsp[0].minor.yy0);
  }
#line 2734 "parse.c"
        break;
      case 218:
#line 784 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy384,&yymsp[0].minor.yy384);
    yygotominor.yy178 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy178, 0, 0);
    if( yygotominor.yy178 ){
      yygotominor.yy178->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy230 ) yygotominor.yy178 = sqlite3Expr(TK_NOT, yygotominor.yy178, 0, 0);
    sqlite3ExprSpan(yygotominor.yy178,&yymsp[-3].minor.yy178->span,yymsp[0].minor.yy384.z?&yymsp[0].minor.yy384:&yymsp[-1].minor.yy384);
  }
#line 2749 "parse.c"
        break;
      case 219:
#line 795 "parse.y"
{
    Expr *p = yygotominor.yy178 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy239;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy239);
    }
  }
#line 2762 "parse.c"
        break;
      case 220:
#line 807 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy178, yymsp[-1].minor.yy178, 0);
  if( yygotominor.yy178 ){
    yygotominor.yy178->pList = yymsp[-2].minor.yy462;
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy462);
  }
  sqlite3ExprSpan(yygotominor.yy178, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2775 "parse.c"
        break;
      case 221:
#line 818 "parse.y"
{
  yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-4].minor.yy462, yymsp[-2].minor.yy178, 0);
  yygotominor.yy462 = sqlite3ExprListAppend(yygotominor.yy462, yymsp[0].minor.yy178, 0);
}
#line 2783 "parse.c"
        break;
      case 222:
#line 822 "parse.y"
{
  yygotominor.yy462 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy178, 0);
  yygotominor.yy462 = sqlite3ExprListAppend(yygotominor.yy462, yymsp[0].minor.yy178, 0);
}
#line 2791 "parse.c"
        break;
      case 231:
#line 849 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy384, &yymsp[-5].minor.yy384, sqlite3SrcListAppend(0,&yymsp[-3].minor.yy384,0), yymsp[-1].minor.yy462, yymsp[-9].minor.yy230,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy230);
}
#line 2799 "parse.c"
        break;
      case 232:
      case 277:
#line 855 "parse.y"
{yygotominor.yy230 = OE_Abort;}
#line 2805 "parse.c"
        break;
      case 233:
#line 856 "parse.y"
{yygotominor.yy230 = OE_None;}
#line 2810 "parse.c"
        break;
      case 236:
#line 866 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy384.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy384.z, yymsp[-1].minor.yy384.n);
  }
  yygotominor.yy462 = sqlite3ExprListAppend(yymsp[-4].minor.yy462, p, &yymsp[-2].minor.yy384);
  if( yygotominor.yy462 ) yygotominor.yy462->a[yygotominor.yy462->nExpr-1].sortOrder = yymsp[0].minor.yy230;
}
#line 2823 "parse.c"
        break;
      case 237:
#line 875 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy384.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy384.z, yymsp[-1].minor.yy384.n);
  }
  yygotominor.yy462 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy384);
  if( yygotominor.yy462 ) yygotominor.yy462->a[yygotominor.yy462->nExpr-1].sortOrder = yymsp[0].minor.yy230;
}
#line 2836 "parse.c"
        break;
      case 239:
#line 889 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy285, yymsp[-1].minor.yy230);}
#line 2841 "parse.c"
        break;
      case 240:
      case 241:
#line 893 "parse.y"
{sqlite3Vacuum(pParse);}
#line 2847 "parse.c"
        break;
      case 242:
      case 244:
#line 899 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy384,&yymsp[-2].minor.yy384,&yymsp[0].minor.yy384,0);}
#line 2853 "parse.c"
        break;
      case 243:
#line 900 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy384,&yymsp[-2].minor.yy384,&yymsp[0].minor.yy0,0);}
#line 2858 "parse.c"
        break;
      case 245:
#line 902 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy384,&yymsp[-2].minor.yy384,&yymsp[0].minor.yy384,1);
}
#line 2865 "parse.c"
        break;
      case 246:
#line 905 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy384,&yymsp[-3].minor.yy384,&yymsp[-1].minor.yy384,0);}
#line 2870 "parse.c"
        break;
      case 247:
#line 906 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy384,&yymsp[0].minor.yy384,0,0);}
#line 2875 "parse.c"
        break;
      case 253:
#line 918 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy384.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy384.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy247, &all);
}
#line 2885 "parse.c"
        break;
      case 254:
#line 927 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy384, &yymsp[-6].minor.yy384, yymsp[-5].minor.yy230, yymsp[-4].minor.yy132.a, yymsp[-4].minor.yy132.b, yymsp[-2].minor.yy285, yymsp[-1].minor.yy230, yymsp[0].minor.yy178, yymsp[-9].minor.yy230);
  yygotominor.yy384 = (yymsp[-6].minor.yy384.n==0?yymsp[-7].minor.yy384:yymsp[-6].minor.yy384);
}
#line 2893 "parse.c"
        break;
      case 255:
      case 258:
#line 933 "parse.y"
{ yygotominor.yy230 = TK_BEFORE; }
#line 2899 "parse.c"
        break;
      case 256:
#line 934 "parse.y"
{ yygotominor.yy230 = TK_AFTER;  }
#line 2904 "parse.c"
        break;
      case 257:
#line 935 "parse.y"
{ yygotominor.yy230 = TK_INSTEAD;}
#line 2909 "parse.c"
        break;
      case 259:
      case 260:
#line 940 "parse.y"
{yygotominor.yy132.a = yymsp[0].major; yygotominor.yy132.b = 0;}
#line 2915 "parse.c"
        break;
      case 261:
#line 942 "parse.y"
{yygotominor.yy132.a = TK_UPDATE; yygotominor.yy132.b = yymsp[0].minor.yy160;}
#line 2920 "parse.c"
        break;
      case 262:
      case 263:
#line 945 "parse.y"
{ yygotominor.yy230 = TK_ROW; }
#line 2926 "parse.c"
        break;
      case 264:
#line 947 "parse.y"
{ yygotominor.yy230 = TK_STATEMENT; }
#line 2931 "parse.c"
        break;
      case 265:
#line 951 "parse.y"
{ yygotominor.yy178 = 0; }
#line 2936 "parse.c"
        break;
      case 266:
#line 952 "parse.y"
{ yygotominor.yy178 = yymsp[0].minor.yy178; }
#line 2941 "parse.c"
        break;
      case 267:
#line 956 "parse.y"
{
  if( yymsp[-2].minor.yy247 ){
    yymsp[-2].minor.yy247->pLast->pNext = yymsp[-1].minor.yy247;
  }else{
    yymsp[-2].minor.yy247 = yymsp[-1].minor.yy247;
  }
  yymsp[-2].minor.yy247->pLast = yymsp[-1].minor.yy247;
  yygotominor.yy247 = yymsp[-2].minor.yy247;
}
#line 2954 "parse.c"
        break;
      case 268:
#line 965 "parse.y"
{ yygotominor.yy247 = 0; }
#line 2959 "parse.c"
        break;
      case 269:
#line 971 "parse.y"
{ yygotominor.yy247 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy384, yymsp[-1].minor.yy462, yymsp[0].minor.yy178, yymsp[-4].minor.yy230); }
#line 2964 "parse.c"
        break;
      case 270:
#line 976 "parse.y"
{yygotominor.yy247 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy384, yymsp[-4].minor.yy160, yymsp[-1].minor.yy462, 0, yymsp[-7].minor.yy230);}
#line 2969 "parse.c"
        break;
      case 271:
#line 979 "parse.y"
{yygotominor.yy247 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy384, yymsp[-1].minor.yy160, 0, yymsp[0].minor.yy239, yymsp[-4].minor.yy230);}
#line 2974 "parse.c"
        break;
      case 272:
#line 983 "parse.y"
{yygotominor.yy247 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy384, yymsp[0].minor.yy178);}
#line 2979 "parse.c"
        break;
      case 273:
#line 986 "parse.y"
{yygotominor.yy247 = sqlite3TriggerSelectStep(yymsp[0].minor.yy239); }
#line 2984 "parse.c"
        break;
      case 274:
#line 989 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy178 ){
    yygotominor.yy178->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy178, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 2995 "parse.c"
        break;
      case 275:
#line 996 "parse.y"
{
  yygotominor.yy178 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy384); 
  if( yygotominor.yy178 ) {
    yygotominor.yy178->iColumn = yymsp[-3].minor.yy230;
    sqlite3ExprSpan(yygotominor.yy178, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3006 "parse.c"
        break;
      case 276:
#line 1006 "parse.y"
{yygotominor.yy230 = OE_Rollback;}
#line 3011 "parse.c"
        break;
      case 278:
#line 1008 "parse.y"
{yygotominor.yy230 = OE_Fail;}
#line 3016 "parse.c"
        break;
      case 279:
#line 1013 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy285);
}
#line 3023 "parse.c"
        break;
      case 280:
#line 1019 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy178, yymsp[-1].minor.yy178, yymsp[0].minor.yy292);
}
#line 3030 "parse.c"
        break;
      case 281:
#line 1024 "parse.y"
{ yygotominor.yy292 = 0; }
#line 3035 "parse.c"
        break;
      case 282:
#line 1025 "parse.y"
{ yygotominor.yy292 = yymsp[0].minor.yy178; }
#line 3040 "parse.c"
        break;
      case 285:
#line 1031 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy178);
}
#line 3047 "parse.c"
        break;
      case 286:
#line 1037 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3052 "parse.c"
        break;
      case 287:
#line 1038 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy384, &yymsp[0].minor.yy384);}
#line 3057 "parse.c"
        break;
      case 288:
#line 1043 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3062 "parse.c"
        break;
      case 289:
#line 1044 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy384, &yymsp[0].minor.yy384);}
#line 3067 "parse.c"
        break;
      case 290:
#line 1049 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy285,&yymsp[0].minor.yy384);
}
#line 3074 "parse.c"
        break;
      case 291:
#line 1052 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy384);
}
#line 3081 "parse.c"
        break;
      case 292:
#line 1055 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy285);
}
#line 3088 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  if( !pParse->parseError ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
    pParse->parseError = 1;
  }
#line 3156 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    /* if( yymajor==0 ) return; // not sure why this was here... */
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
