/**
  * $Id: CMRThreadsList-Filter.m,v 1.2.2.3 2006-08-15 13:43:23 masakih Exp $
  * 
  * CMRThreadsList-Filter.m
  *
  * Copyright (c) 2003, Takanori Ishikawa.
  * See the file LICENSE for copying permission.
  */

#if 0

#import "CMRThreadsList_p.h"
#import "BoardManager.h"
#import "CMRSearchOptions.h"

@implementation CMRThreadsList(Filter)
- (void) filterByStatus : (int       ) status
		displayWithPath : (NSString *) filepath
{
	NSDictionary		*matched_;
	unsigned int		index_;
	
	[self filterByStatus : status];
	
	matched_ = [self seachThreadByPath : filepath];
	if(nil == matched_) return;
	
	// w肳ꂽOt@CXbhtB^[
	// zɊ܂܂ĂȂΒǉB
	index_ = [[self filteredThreads] indexOfObject : matched_];
	if(NSNotFound == index_){
		NSString *sortKey_;
		
		[[self filteredThreads] addObject : matched_];
		//\[g
		sortKey_ = [[BoardManager defaultManager] sortColumnForBoard : [self boardName]];
		[self _sortArrayByKey:sortKey_ array:[self filteredThreads]];
	}
}
- (void) filterByDisplayingThreadAtPath : (NSString *) filepath
{
	[self filterByStatus:[self filteringMask] displayWithPath:filepath];
}

/**
  * XbhꗗiׂāEE擾jȂǂŕ
  * ȂBstatusɂThreadStatusrbgORl
  * nB
  * 
  * @param    status  ނXe[^X
  */
- (void) filterByStatus : (int) status
{
	ThreadStatus filters[]  = {ThreadNoCacheStatus,
							   ThreadLogCachedStatus,
							   ThreadUpdatedStatus,
							   ThreadNewCreatedStatus,
							   ThreadHeadModifiedStatus};
	int					i, cnt;
	NSMutableArray		*sorted_;
	NSMutableArray		*filtered_ = [NSMutableArray array];
	NSString			*sortKey_  = [[BoardManager defaultManager] sortColumnForBoard : [self boardName]];
	
	if(ThreadStandardStatus == status){
		[filtered_ addObjectsFromArray : [self threads]];
		[self _sortArrayByKey:sortKey_ array:filtered_];
		[self setFilteredThreads : filtered_];
		return;
	}
	
	sorted_ = [NSMutableArray arrayWithArray : [self threads]];
	[self _sortArrayByKey:CMRThreadStatusKey array:sorted_];
	
	i = 0;
	cnt = (sizeof(filters) / sizeof(ThreadStatus));
	for(i = 0; i < cnt; i++){
		if(status & filters[i]){
			NSArray *subarray_;
			NSRange  found_;
			subarray_ = [self _arrayWithStatus : filters[i]
					           fromSortedArray : sorted_
							     subarrayRange : &found_];
			if(subarray_ != nil){
				[filtered_ addObjectsFromArray : subarray_];
				[sorted_ removeObjectsInRange : found_];
			}
		}
	}
	
	[self _sortArrayByKey:sortKey_ array:filtered_];
	[self setFilteredThreads : filtered_];
	return;
}

/**
  * Xe[^XŃ\[gς݂̔zIuWFNg
  * w肳ꂽXe[^X̔zԂB
  * 
  * @param    status  Xe[^X
  * @param    array   Xe[^XŃ\[gς݂̔z
  * @param    aRange  ͈
  *                   (Ȃlocation == NSNotFound)
  * @return           w肳ꂽXe[^X̔z
  */
- (NSArray *) _arrayWithStatus : (ThreadStatus    ) status
               fromSortedArray : (NSMutableArray *) array
			     subarrayRange : (NSRangePointer  ) aRange
{
	int firstIndex_, lastIndex_;
	int i, cnt;
	NSRange rng_;		//w肳ꂽXe[^XGgɎ͈
	
	//z͊Ƀ\[gĂ̂ŁA
	//Oォw肳ꂽXe[^XGgɎ
	//̃CfbNX߁AŐ؂oB
	rng_ = NSMakeRange(NSNotFound, 0);
	
	firstIndex_ = NSNotFound;  //vf0肷ꍇB
	lastIndex_ = 0;
	i = 0;
	cnt = [array count];
	
	for(i = 0; i < cnt; i++){
		NSDictionary *thread_;
		NSNumber     *thStatus_;
		thread_ = [array objectAtIndex : i];
		thStatus_ = [thread_ objectForKey : CMRThreadStatusKey];
		
		if(thStatus_ != nil){
			ThreadStatus st_;
			st_ = [thStatus_ unsignedIntValue];
			if(st_ == status){
				//ŏ̃CfbNXL^
				firstIndex_ = i;
				break;
			}
		}
		//Ȃ
		if(i == (cnt -1)){
			firstIndex_ = NSNotFound;
			break;
		}
	}
	
	if(firstIndex_ == NSNotFound){
		if(aRange != NULL) *aRange = rng_;
		return nil;
	}
	
	
	for(i = cnt -1; i >= firstIndex_; i--){
		NSDictionary *thread_;
		NSNumber     *thStatus_;
		thread_ = [array objectAtIndex : i];
		thStatus_ = [thread_ objectForKey : CMRThreadStatusKey];
		
		if(thStatus_ != nil){
			ThreadStatus st_;
			st_ = [thStatus_ unsignedIntValue];
			if(st_ == status){
				break;
			}
		}
	}
	lastIndex_ = i;
	//͈͂
	rng_.location = firstIndex_;
	rng_.length = (lastIndex_ - firstIndex_) + 1;
	if(aRange != NULL) *aRange = rng_;
	//rng_ = NSMakeRange(firstIndex_, (lastIndex_ - firstIndex_) + 1);
	return [array subarrayWithRange : rng_];
}

//-------------------------------------------------------------------
//------- Filter(search) --------------------------------------------
//-------------------------------------------------------------------
- (id) temporaryArrayWithFindOperation : (CMRSearchOptions *) operation
							 fromArray : (NSArray       *) array
{
	NSMutableArray			*foundArray_;
	NSEnumerator			*iter_;
	id						thread_;
	NSString				*searchString_;
	//CMRSearchMask			searchOption_;
	//id						userInfo_;
	//NSCharacterSet			*ignoreSet_ = nil;
	//BOOL					ignoreSpecificCharacters_;
	
	foundArray_ = SGTemporaryArray();
	
	searchString_ = [operation findObject];
	UTILRequireCondition(array && operation, ErrSearch);
	UTILRequireCondition(
		searchString_ && 
		[searchString_ isKindOfClass : [NSString class]] &&
		NO == [searchString_ isEmpty],
		ErrSearch);
	
	iter_ = [array objectEnumerator];
	
	//searchOption_ = 0;
	//userInfo_ = [operation userInfo];
	//if(userInfo_ && [userInfo_ respondsToSelector : @selector(unsignedIntValue)])
	//	searchOption_ = [userInfo_ unsignedIntValue];
	
	
	//ignoreSpecificCharacters_ = (searchOption_ & CMRSearchOptionIgnoreSpecified);
	
	
	/*if(ignoreSpecificCharacters_){
		if(nil == ignoreSet_){
			NSString		*igchars_;
			
			igchars_ = [CMRPref ignoreTitleCharacters];
			ignoreSet_ = [NSCharacterSet 
							characterSetWithCharactersInString : igchars_];
		}
		
		// 񂩂疳镶͎菜B
		searchString_ = [searchString_ stringByDeleteCharactersInSet : ignoreSet_];
		UTILRequireCondition(NO == [searchString_ isEmpty], ErrSearch);
	}*/
	
	searchString_ = [searchString_ precomposedStringWithCompatibilityMapping];
	UTILRequireCondition(NO == [searchString_ isEmpty], ErrSearch);
	
	while(thread_ = [iter_ nextObject]){
		NSString	*title_;
		NSRange		include_;
		NSRange		searchRng_;
		
		UTILAssertKindOfClass(thread_, NSDictionary);
		title_ = [thread_ objectForKey : CMRThreadTitleKey];
		UTILAssertNotNil(title_);
		
		
		//if(ignoreSpecificCharacters_)
		//	title_ = [title_ stringByDeleteCharactersInSet : ignoreSet_];
			
		title_ = [title_ precomposedStringWithCompatibilityMapping]; // Unicode KC
		
		searchRng_ = NSMakeRange(0, [title_ length]);
		include_ = [title_ rangeOfString : searchString_ 
								 options : NSCaseInsensitiveSearch
								   range : searchRng_];
		
		if(0 == include_.length || NSNotFound == include_.location)
			continue;
		
		[foundArray_ addObject : thread_];
	}
	//z񂪋A܂茟ʂu܂vƂ͓ʂȔzĕԂB
	//ڍׂ CMRThreadsList.m  filteredThreads \bhӂ̃RgQƁB
	if ([foundArray_ count] == 0)
		[foundArray_ addObject : @"SearchNotFound"];
	ErrSearch:
		return foundArray_;
}
- (BOOL) filterByFindOperation : (CMRSearchOptions *) operation
{
	id				result;
	NSMutableArray	*filtered_;
		
	[self setFilteredThreads : nil];
	/*
		2004-12-05 tsawada2 `V̗
		_filteredThreadsnilɂ邱ƂŁA-filteredThreads:ŁuSXbhXe[^XŃtB^́vԂĂB
		(see CMRThreadsList.m)
		nilɂȂƁA-filteredThreads:ŁuSXbh𒼑ǑʂŃtB^́vԂĂĂ܂߁A
		ʂ\Ԃŕʂ̌Ō蒼ƂɕssłB
	*/
	result = [self temporaryArrayWithFindOperation:operation fromArray:[self filteredThreads]];
	//NSLog(@"%d",[result count]);
	UTILRequireCondition(result && [result count], ErrFilterByFindOperation);
	filtered_ = [result mutableCopyWithZone : [self zone]];
	[self setFilteredThreads : filtered_];
	[filtered_ release];

	if ([result containsObject : @"SearchNotFound"]) {
		// ʂ󂾂ꍇłAresult LCɂĂKvB
		[result removeAllObjects];
		return NO;
	} else {
		[result removeAllObjects];	
		return YES;
	}
	
ErrFilterByFindOperation:
	return NO;
}


- (void) _filteredThreadsLock
{
	[_filteredThreadsLock lock];
}
- (void) _filteredThreadsUnlock
{
	[_filteredThreadsLock unlock];
}
@end

@implementation CMRThreadsList(SearchThreads)
- (NSMutableDictionary *) seachThreadByPath : (NSString *) filepath
{
	id	thread_;
	
	// ɃO擾Ă΁AɊi[ĂB
	// O݂ȂꍇNSNulli[ĂB
	thread_ = [[self threadsInfo] objectForKey : filepath];
	if(thread_ != nil && (NO == [thread_ isEqual : [NSNull null]]))
		return thread_;

	// OȂ΁Aꗗ猟B
	thread_ = [self seachThreadByPath : filepath inArray : [self threads]];
	return thread_;
}

- (NSMutableDictionary *) seachThreadByPath : (NSString *) filepath
									inArray : (NSArray  *) array
{
	NSArray *matched_;
	
	matched_ = [self _searchThreadsInArray : array context : filepath];
	if([matched_ count] == 0) return nil;
	
	//pẌvXbh͂ЂƂȂB
	NSAssert(([matched_ count] == 1), @"duplicated threadsList.");
	
	return [matched_ objectAtIndex : 0];
}

- (NSArray *) _searchThreadsInArray : (NSArray *) array context : (NSString *) context
{
	NSMutableArray		*result_;
	NSEnumerator		*iter_;
	NSDictionary		*thread_;
	NSAutoreleasePool	*pool_;
	
	result_ = [NSMutableArray array];
	if (nil == array || nil == context)
		return result_;

	pool_ = [[NSAutoreleasePool alloc] init];
	iter_ = [array objectEnumerator];

	while (thread_ = [iter_ nextObject]) {
		NSString *target_;

		target_ = [CMRThreadAttributes pathFromDictionary : thread_];
		if (target_ == nil)
			continue;
		if([context isSameAsString : target_])
			[result_ addObject : thread_];
	}
	[pool_ release];
	return result_;
}
@end

#endif
