#!/bin/bash -eE
                  #// Content-Type: text/plain; charset=utf-8
                  #// -eE オプションは、エラーが起きたら中断します
                  #// -x オプションは、１行ずつコマンドを表示します

g_AllArguments="$@"
g_FuncName=${1#--*}  #// cut -- from $1


if [ "${BASH_VERSINFO[0]}" -ge "4" ];then
  declare_AssociativeArrayClass="declare -A"  #// bash ver4
else
  declare_AssociativeArrayClass="declare"  #// bash ver3
fi

$declare_AssociativeArrayClass  g_Object

function  Main_func()
{
  local  AppKey="$2" ; AppKeyClass.newWritable_method  "$AppKey"  "$PWD"
  if [ "$g_FuncName" == "" ]; then
    if true; then
      T_IsNumeric_func  "$@"
      T_StringClass_length_func  "$@"
      T_StringClass_substring_func  "$@"
      T_StringClass_trim_func  "$@"
      T_StringClass_right_func  "$@"
      T_StringClass_cutLast_func  "$@"
      T_StringClass_replace_func  "$@"
      T_StringEscapeUtilsClass_func  "$@"
      T_ArrayClass_getLength_func  "$@"
      T_ArrayClass_get_set_func  "$@"
      T_ArrayClass_remove_func  "$@"
      T_ArrayClass_clear_func  "$@"
      T_ArrayClass_Lines_func  "$@"
      T_StringClass_index_func  "$@"
      T_StringClass_toLoHi_func  "$@"
      T_MultiLine_func  "$@"
      T_ArrayFromCSV_func  "$@"
      T_IsSameArrayOutOfOrder_func  "$@"
      T_LeftRightOfStr_func  "$@"
      T_Attr_func  "$@"
      T_Attr3_func  "$@"
      T_ArrayAttr_func  "$@"
      T_SetAttrInFunc_func  "$@"
      T_CopyArray_func  "$@"
      if [ "${BASH_VERSINFO[0]}" -ge "4" ];then
        T_CopyAssociativeArray4_func  "$@"
      fi
      T_CopyAssociativeArray3_func  "$@"
      T_CopyArrayAttr_func  "$@"
      T_CheckArgCount_func  "$@"
      T_GetLongOptions_func  "$@"
      T_local_func  "$@"
      T_SetOutputAsArray_func  "$@"
    fi
  else
    $g_FuncName  "$@"
  fi
  ColorText_func  "Pass."  "Green" "Bold" ; echo_e_func  "$g_Ret"
}


 
#//*********************************************************************
#// <<< [T_IsNumeric_func] >>> 
#//*********************************************************************
function  T_IsNumeric_func()
{
  local  var

  EchoTestStart_func  "${FUNCNAME[0]}"

  var=0
  IsNumeric_func $var ; if [ "$g_Ret" == "0" ];then  Error_func  ;fi

  var=-1
  IsNumeric_func $var ; if [ "$g_Ret" == "0" ];then  Error_func  ;fi

  var="a"
  IsNumeric_func $var ; if [ "$g_Ret" == "1" ];then  Error_func  ;fi
}


 
#//*********************************************************************
#// <<< [T_StringClass_length_func] >>> 
#//*********************************************************************
function  T_StringClass_length_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  StringClass.length_method  "" ;     Assert_func  '"$g_Ret" == "0"'
  StringClass.length_method  "ABCD" ; Assert_func  '"$g_Ret" == "4"'
  StringClass.length_method  "A\nD" ; Assert_func  '"$g_Ret" == "4"'

  local  var; var=`echo -e  "A\nD"`
  StringClass.length_method  "$var" ; var="$g_Ret"
  Assert_func  '"$var" == "3"'

  StringClass.length_method  "あいう" ; Assert_func  '"$g_Ret" == "3"'
}


 
#//*********************************************************************
#// <<< [T_StringClass_substring_func] >>> 
#//*********************************************************************
function  T_StringClass_substring_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  var="ABCDE"
  StringClass.substring_method "$var"  2 ;    Assert_func  "$g_Ret" = "CDE"
  StringClass.substring_method "$var"  2  4 ; Assert_func  "$g_Ret" = "CD"
  StringClass.substring_method "$var"  0  5 ; Assert_func  "$g_Ret" = "ABCDE"

  local  var="  AB  あDE "
  StringClass.substring_method "$var"  4  7 ; Assert_func  "$g_Ret" = "  あ"
}


 
#//*********************************************************************
#// <<< [T_StringClass_trim_func] >>> 
#//*********************************************************************
function  T_StringClass_trim_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  T_StringClass_trim_sub_func  " (out)out_Arg "  "(out)out_Arg"
  T_StringClass_trim_sub_func  "  ab  ${Tab}${LF}cあ  "  "ab  ${Tab}${LF}cあ"
  T_StringClass_trim_sub_func  "abc${Tab}  ${LF}あ"      "abc${Tab}  ${LF}あ"
  T_StringClass_trim_sub_func  "${Tab}${LF}abc${Tab}${LF}  あ${Tab}${LF}"  "abc${Tab}${LF}  あ"
  T_StringClass_trim_sub_func  " *.sh "  "*.sh"
  T_StringClass_trim_sub_func  "   $LF"  ""
}


function  T_StringClass_trim_sub_func()
{
  local  String="$1"
  local  Ans="$2"
  local  trim_str

  StringClass.trim_method  "$String"
  trim_str="$g_Ret"
  Assert_func  '"$trim_str" == "$Ans"'
  echo  "$trim_str"
}


 
#//*********************************************************************
#// <<< [T_StringClass_right_func] >>> 
#//*********************************************************************
function  T_StringClass_right_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  var="ABCDE"
  StringClass.right_method  "$var"  3 ; Assert_func  "$g_Ret" = "CDE"
  StringClass.right_method  "$var"  5 ; Assert_func  "$g_Ret" = "ABCDE"
}


 
#//*********************************************************************
#// <<< [T_StringClass_cutLast_func] >>> 
#//*********************************************************************
function  T_StringClass_cutLast_func()
{
  local  var

  var="folder/"
  StringClass.cutLastOf_method  "$var"  "/"
  echo  "$g_Ret"
  Assert_func  "$g_Ret" = "folder"

  var="folder"
  StringClass.cutLastOf_method  "$var"  "/"
  Assert_func  "$g_Ret" = "folder"
}


 
#//*********************************************************************
#// <<< [T_StringClass_replace_func] >>> 
#//*********************************************************************
function  T_StringClass_replace_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  StringClass.replace_method  "abcde"  "c"  "xx"
  echo  "$g_Ret"
  Assert_func  '"$g_Ret" == "abxxde"'

  StringClass.replace_method  'ab/c\de'  '/c\'  'x\*x'
  echo  "$g_Ret"
  Assert_func  '"$g_Ret" == "abx\\*xde"'

  StringClass.replace_method  'abc'  '.b'  'xx'  #// not regular expression test
  echo  "$g_Ret"
  Assert_func  '"$g_Ret" == "abc"'

  StringClass.replace_method  'abcde'  'a*e'  'xx'  #// not regular expression test
  echo  "$g_Ret"
  Assert_func  '"$g_Ret" == "abcde"'

  StringClass.replace_method  '*.txt'  '*'  'a'  #// not regular expression test
  echo  "$g_Ret"
  Assert_func  '"$g_Ret" == "a.txt"'
}


 
#//*********************************************************************
#// <<< [T_StringEscapeUtilsClass_func] >>> 
#//*********************************************************************
function  T_StringEscapeUtilsClass_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  StringEscapeUtilsClass.escapeGrep_method  'a -o . $ ^ { } [ ] * + ? \'
  echo  "$g_Ret"
  if [ "$g_Ret" != 'a \-o \. \$ \^ \{ \} \[ \] \* \+ \? \\' ];then  Error_func  ;fi

  StringEscapeUtilsClass.escapeSed_method  'a . $ ^ [ ] * ? \ /'
  echo  "$g_Ret"
  if [ "$g_Ret" != 'a \. \$ \^ \[ \] \* \? \\ \/' ];then  Error_func  ;fi

  StringEscapeUtilsClass.escapeBashReplace_method  'a } ( ) * ? \ /'
  echo  "$g_Ret"
  if [ "$g_Ret" != 'a \} \( \) \* \? \\ \/' ];then  Error_func  ;fi

  StringEscapeUtilsClass.escapeBashDoubleQuot_method  'a $ \'
  echo  "$g_Ret"
  if [ "$g_Ret" != 'a \$ \\' ];then  Error_func  ;fi

  StringEscapeUtilsClass.escapeBashParam_method  'a $ \'
  echo  "$g_Ret"
  if [ "$g_Ret" != 'a\ \$\ \\' ];then  Error_func  ;fi
}


 
#//*********************************************************************
#// <<< [T_ArrayClass_getLength_func] >>> 
#//*********************************************************************
function  T_ArrayClass_getLength_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  arr

  arr=( "a b" "c" "d" )
  ArrayClass.getLength_method  arr
  Assert_func  '"$g_Ret" == "3"'

  arr=( )
  ArrayClass.getLength_method  arr
  Assert_func  '"$g_Ret" == "0"'
}


 
#//*********************************************************************
#// <<< [T_ArrayClass_get_set_func] >>> 
#//*********************************************************************
function  T_ArrayClass_get_set_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  arr
  local  a1

  #// Test Main
  arr=( "a  b" "c" "d" )
  ArrayClass.get_method  arr  0
  Assert_func  '"$g_Ret" == "a  b"'

  ArrayClass.get_method  arr  1
  Assert_func  '"$g_Ret" == "c"'

  #// Test Main : index is out of range
  while TryStart_func; do
    ArrayClass.get_method  arr  3
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" == "0" ]; then  Error_func  "Error exptected"  ;fi
  echo "${g_Err_Desc}${LF}This error is OK";  ErrClass.clear_method

  while TryStart_func; do
    ArrayClass.get_method  arr  -1
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" == "0" ]; then  Error_func  "Error exptected"  ;fi
  echo "${g_Err_Desc}${LF}This error is OK";  ErrClass.clear_method


  #// Test Main : set
  arr=( "a  b" "c" "d" )
  ArrayClass.set_method  arr  1  "b  c"

  ArrayClass.get_method  arr  1
  Assert_func  '"$g_Ret" == "b  c"'

  ArrayClass.get_method  arr  0
  Assert_func  '"$g_Ret" == "a  b"'

  ArrayClass.set_method  arr  5  "e"
  ArrayClass.get_method  arr  5
  Assert_func  '"$g_Ret" == "e"'

  ArrayClass.getLength_method  arr
  Assert_func  '"$g_Ret" == "6"'

  while TryStart_func; do
    ArrayClass.set_method  arr  -1  "x"  #// index is out of range
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" == "0" ]; then  Error_func  "Error exptected"  ;fi
  echo "${g_Err_Desc}${LF}This error is OK";  ErrClass.clear_method
}


 
#//*********************************************************************
#// <<< [T_ArrayClass_remove_func] >>> 
#//*********************************************************************
function  T_ArrayClass_remove_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  arr
  local  a1

  #// Test Main
  arr=( "a" "b" "c" )
  ArrayClass.remove_method  arr  1

  Assert_func  '"${arr[0]}" == "a"'
  Assert_func  '"${arr[1]}" == "c"'
}


 
#//*********************************************************************
#// <<< [T_ArrayClass_clear_func] >>> 
#//*********************************************************************
function  T_ArrayClass_clear_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  arr

  #// Test Main : undefined variable
  ArrayClass.clear_method  arr

  #// Test Main : basic variable
  arr=1
  ArrayClass.clear_method  arr

  #// Test Main : array variable
  arr=( "a" "b" "c" )
  ArrayClass.clear_method  arr
  Assert_func  '${#arr[@]} == 0'

  #// Test Main : associative array variable
  SetAttr_func  arr  "Attr1"  "Value1"
  SetAttr_func  arr  "Attr2"  "Value2"
  ArrayClass.clear_method  arr
}


 
#//*********************************************************************
#// <<< [T_ArrayClass_Lines_func] >>> 
#//*********************************************************************
function  T_ArrayClass_Lines_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  lines
  local  arr

  #// Test Main
  lines="abc${LF}cde${LF}efg"
  ArrayClass.fromLines_method  arr  "$lines"
  Assert_func  '"${arr[0]}" == "abc"'
  Assert_func  '"${arr[1]}" == "cde"'
  Assert_func  '"${arr[2]}" == "efg"'
  Assert_func  '"${#arr[@]}" == "3"'

  #// Test Main
  lines="abc${LF}"
  ArrayClass.fromLines_method  arr  "$lines"
  Assert_func  '"${arr[0]}" == "abc"'
  Assert_func  '"${#arr[@]}" == "1"'

  #// Test Main
  lines=""
  ArrayClass.fromLines_method  arr  "$lines"
  Assert_func  '"${#arr[@]}" == "0"'
}


 
#//*********************************************************************
#// <<< [T_LeftRightOfStr_func] >>> 
#//*********************************************************************
function  T_LeftRightOfStr_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  LeftOfStr_func   "abc=123=ABC"  "=" ; Assert_func  '"$g_Ret" == "abc"'
  RightOfStr_func  "abc=123=ABC"  "=" ; Assert_func  '"$g_Ret" == "123=ABC"'
  LeftOfLastStr_func   "abc=123=ABC"  "=" ; Assert_func  '"$g_Ret" == "abc=123"'
  RightOfLastStr_func  "abc=123=ABC"  "=" ; Assert_func  '"$g_Ret" == "ABC"'

  T_LeftOfStrSub_func       '123/456/789'  '/'  '123'
  T_RightOfStrSub_func      '123/456/789'  '/'  '456/789'
  T_LeftOfLastStrSub_func   '123/456/789'  '/'  '123/456'
  T_RightOfLastStrSub_func  '123/456/789'  '/'  '789'

  T_LeftOfStrSub_func       '123*456*789'  '*'  '123'
  T_RightOfStrSub_func      '123*456*789'  '*'  '456*789'
  T_LeftOfLastStrSub_func   '123*456*789'  '*'  '123*456'
  T_RightOfLastStrSub_func  '123*456*789'  '*'  '789'

  T_LeftOfStrSub_func       '123\456\789'  '\'  '123'
  T_RightOfStrSub_func      '123\456\789'  '\'  '456\789'
  T_LeftOfLastStrSub_func   '123\456\789'  '\'  '123\456'
  T_RightOfLastStrSub_func  '123\456\789'  '\'  '789'

  T_LeftOfLastStrSub_func   '123\456${LF}\789'  '\'  '123\456${LF}'
}


function  T_LeftOfStrSub_func()
{
  local  Str="$1"
  local  Key="$2"
  local  Ans="$3"

  local  ret

  LeftOfStr_func  "$Str"  "$Key" ; ret="$g_Ret"
  echo  LeftOfStr_func  \"$Str\"  \"$Key\" = \"$ret\"
  Assert_func  "$ret" == "$Ans"
}


function  T_LeftOfLastStrSub_func()
{
  local  Str="$1"
  local  Key="$2"
  local  Ans="$3"

  local  ret

  LeftOfLastStr_func  "$Str"  "$Key" ; ret="$g_Ret"
  echo  LeftOfLastStr_func  \"$Str\"  \"$Key\" = \"$ret\"
  Assert_func  "$ret" == "$Ans"
}


function  T_RightOfStrSub_func()
{
  local  Str="$1"
  local  Key="$2"
  local  Ans="$3"

  local  ret

  RightOfStr_func  "$Str"  "$Key" ; ret="$g_Ret"
  echo  RightOfStr_func  \"$Str\"  \"$Key\" = \"$ret\"
  Assert_func  "$ret" == "$Ans"
}


function  T_RightOfLastStrSub_func()
{
  local  Str="$1"
  local  Key="$2"
  local  Ans="$3"

  local  ret

  RightOfLastStr_func  "$Str"  "$Key" ; ret="$g_Ret"
  echo  RightOfLastStr_func  \"$Str\"  \"$Key\" = \"$ret\"
  Assert_func  "$ret" == "$Ans"
}


 
#//*********************************************************************
#// <<< [T_StringClass_index_func] >>> 
#//*********************************************************************
function  T_StringClass_index_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  var="ABCDEABCDE"
  StringClass.indexOf_method  "$var"  "BC"    ; Assert_func  '$g_Ret == 1'
  StringClass.indexOf_method  "$var"  "BC"  5 ; Assert_func  '$g_Ret == 6'
  StringClass.indexOf_method  "$var"  "X"     ; Assert_func  '$g_Ret == -1'
  StringClass.indexOf_method  "$var"  "X"  5  ; Assert_func  '$g_Ret == -1'

  local  var="ABCDEABCDE"
  StringClass.lastIndexOf_method  "$var"  "BC"    ; Assert_func  '$g_Ret == 6'
  StringClass.lastIndexOf_method  "$var"  "BC"  5 ; Assert_func  '$g_Ret == 1'
  StringClass.lastIndexOf_method  "$var"  "X"     ; Assert_func  '$g_Ret == -1'
  StringClass.lastIndexOf_method  "$var"  "X"  5  ; Assert_func  '$g_Ret == -1'
}


 
#//*********************************************************************
#// <<< [T_StringClass_toLoHi_func] >>> 
#//*********************************************************************
function  T_StringClass_toLoHi_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  StringClass.toLowerCase_method  "ABCDEf" ; Assert_func  '"$g_Ret" == "abcdef"'
  StringClass.toUpperCase_method  "abcdeF" ; Assert_func  '"$g_Ret" == "ABCDEF"'
}


 
#//*********************************************************************
#// <<< [T_MultiLine_func] >>> 
#//*********************************************************************
function  T_MultiLine_func()
{
  local  str

  EchoTestStart_func  "${FUNCNAME[0]}"


  #//=== $LF

  MultiLine_func "$LF" \
    "abc" \
    "def"
  str="$g_Ret"
  Assert_func  '"$str" == "abc${LF}def"'
  echo  "$str"


  MultiLine_func "$LF" \
    "abc" \
    "def"
  str="$g_Ret$LF"
  Assert_func  '"$str" == "abc${LF}def${LF}"'
  echo  "$str"


  MultiLine_func "$LF" \
    "abc" \
    "def" \
    ""
  str="$g_Ret"
  Assert_func  '"$str" == "abc${LF}def"'
  echo  "$str"


  MultiLine_func "$LF" \
    "abc" \
    "def" \
    " "
  str="$g_Ret"
  Assert_func  '"$str" == "abc${LF}def${LF} "'
  echo  "$str"


  #//=== \n

  MultiLine_func "\n" \
    "abc" \
    "def"
  str="$g_Ret"
  Assert_func  '"$str" == "abc\ndef"'
  echo  "$str"


  MultiLine_func "\n" \
    "abc" \
    "def"
  str="$g_Ret\n"
  Assert_func  '"$str" == "abc\ndef\n"'
  echo  "$str"


  MultiLine_func "\n" \
    "abc" \
    "def" \
    ""
  str="$g_Ret"
  Assert_func  '"$str" == "abc\ndef"'
  echo  "$str"


  MultiLine_func "\n" \
    "abc" \
    "def" \
    " "
  str="$g_Ret"
  Assert_func  '"$str" == "abc\ndef\n "'
  echo  "$str"


  #//=== space or tab in 1 line
  MultiLine_func "$LF"  ""  "ab  c"  ""  "de${Tab}f"
  str="$g_Ret"
  Assert_func  '"$str" == "${LF}ab  c${LF}${LF}de${Tab}f"'
  echo  "$str"

  MultiLine_func "\n"   ""  "ab  c"  ""  "de\tf"
  str="$g_Ret"
  Assert_func  '"$str" == "\nab  c\n\nde\tf"'
  echo  "$str"


  #//=== no param
  MultiLine_func "$LF"
  str="$g_Ret"
  Assert_func  '"$str" == ""'

  MultiLine_func "\n"
  str="$g_Ret"
  Assert_func  '"$str" == ""'
}


 
#//*********************************************************************
#// <<< [T_ArrayFromCSV_func] >>> 
#//*********************************************************************
function  T_ArrayFromCSV_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  arr
  local  csv


  #//=== Test Main
  csv=" AB  C , D E  D , \" G H  G \""
  echo  "'""$csv""'"
  ArrayClass.fromCSV_method  arr  "$csv"  #//[out] arr

  #// check
  Assert_func  '${#arr[@]} == 3'
  echo  "  '""${arr[0]}""'"
  echo  "  '""${arr[1]}""'"
  echo  "  '""${arr[2]}""'"
  Assert_func  '"${arr[0]}" == "AB  C"'
  Assert_func  '"${arr[1]}" == "D E  D"'
  Assert_func  '"${arr[2]}" == " G H  G "'


  #//=== Test Main : no item
  csv=" "
  echo  "'""$csv""'"
  ArrayClass.fromCSV_method  arr  "$csv"  #//[out] arr

  #// check
  Assert_func  '${#arr[@]} == 0'


  #//=== Test Main : 1 item
  csv="ABC"
  echo  "'""$csv""'"
  ArrayClass.fromCSV_method  arr  "$csv"  #//[out] arr

  #// check
  Assert_func  '${#arr[@]} == 1'
  echo  "  '""${arr[0]}""'"
  Assert_func  '"${arr[0]}" == "ABC"'


  #//=== Test Main : wildcard
  csv="*.sh, *.html"
  echo  "'""$csv""'"
  ArrayClass.fromCSV_method  arr  "$csv"  #//[out] arr

  #// check
  Assert_func  '${#arr[@]} == 2'
  echo  "  '""${arr[0]}""'"
  echo  "  '""${arr[1]}""'"
  Assert_func  '"${arr[0]}" == "*.sh"'
  Assert_func  '"${arr[1]}" == "*.html"'
}


 
#//*********************************************************************
#// <<< [T_IsSameArrayOutOfOrder_func] >>>
#//*********************************************************************
function  T_IsSameArrayOutOfOrder_func()
{
  local  arr_a
  local  arr_b

  arr_a=( )
  arr_b=( )
  IsSameArrayOutOfOrder_func  ${#arr_a[@]}  "${arr_a[@]}"  "${arr_b[@]}"
  if [ "$g_Ret" == "0" ];then  Error_func  ;fi

  arr_a=( "a" )
  arr_b=( "a" )
  IsSameArrayOutOfOrder_func  ${#arr_a[@]}  "${arr_a[@]}"  "${arr_b[@]}"
  if [ "$g_Ret" == "0" ];then  Error_func  ;fi

  arr_a=( "a" "b" )
  arr_b=( "b" "a" )
  IsSameArrayOutOfOrder_func  ${#arr_a[@]}  "${arr_a[@]}"  "${arr_b[@]}"
  if [ "$g_Ret" == "0" ];then  Error_func  ;fi

  arr_a=( "a" "b" "c" )
  arr_b=( "b" "a" )
  IsSameArrayOutOfOrder_func  ${#arr_a[@]}  "${arr_a[@]}"  "${arr_b[@]}"
  if [ "$g_Ret" == "1" ];then  Error_func  ;fi

  arr_a=( "a" "b" "c" )
  arr_b=( "b" "d" "c" )
  IsSameArrayOutOfOrder_func  ${#arr_a[@]}  "${arr_a[@]}"  "${arr_b[@]}"
  if [ "$g_Ret" == "1" ];then  Error_func  ;fi

  arr_a=( "a" "a" "c" )
  arr_b=( "c" "a" "a" )
  IsSameArrayOutOfOrder_func  ${#arr_a[@]}  "${arr_a[@]}"  "${arr_b[@]}"
  if [ "$g_Ret" == "0" ];then  Error_func  ;fi

  arr_a=( "a" "a" ""  )
  arr_b=( ""  "a" "a" )
  IsSameArrayOutOfOrder_func  ${#arr_a[@]}  "${arr_a[@]}"  "${arr_b[@]}"
  if [ "$g_Ret" == "0" ];then  Error_func  ;fi
}


 
#//*********************************************************************
#// <<< [T_Attr_func] >>> 
#//*********************************************************************
function  T_Attr_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  obj
  local  objects; objects=( "object_a"  "object_b" )
  local  ans

  for obj  in  ${objects[@]};do  $declare_AssociativeArrayClass  $obj  ; done

  if [ "${BASH_VERSINFO[0]}" -ge "4" ];then
    object_a["Attr1"]="Value  1"
    object_a["Attr2"]="Value2"

    Attr_func  object_a  Attr1
    object_b["Attr1"]="$g_Ret"
    object_b["Attr2"]="Value  4"
  else
    SetAttr_func  object_a  Attr1  "Value  1"
    SetAttr_func  object_a  Attr2  "Value2"

    Attr_func  object_a  Attr1
    SetAttr_func  object_b  Attr1  "$g_Ret"
    SetAttr_func  object_b  Attr2  "Value  4"
  fi

  ans="Value2"
  for obj  in ${objects[@]};do
    Attr_func  $obj  "Attr1" ; echo  "$g_Ret"
    if [ "$g_Ret" != "Value  1" ];then  Error_func  ;fi
    Attr_func  $obj  "Attr2" ; echo  "$g_Ret"
    if [ "$g_Ret" != "$ans" ];then  Error_func  ;fi
    ans="Value  4"
  done ; done_func $?

  for obj  in  ${objects[@]};do  AssociativeArrayClass.destroy_method  $obj  ; done
}


 
#//*********************************************************************
#// <<< [T_Attr3_func] >>> 
#//*********************************************************************
function  T_Attr3_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  i
  local  name
  local  name_0
  local  obj="g_Object"
  local  assoc
  local  keys

  SetAttr_func  $obj  Class  "AClass"
  Attr_func  $obj  "Class"
  Assert_func  "$g_Ret" == "AClass"

  SetAttr_func  $obj  Attr1  "Value1"
  Attr_func  $obj  "Attr1"
  Assert_func  "$g_Ret" == "Value1"

  SetAttr_func  $obj  Attr1  "Value11"
  Attr_func  $obj  "Attr1"
  Assert_func  "$g_Ret" == "Value11"

  i="0"
  AssociativeArrayClass.getKeys_method  $obj ; keys="$g_Ret"
  for name  in $keys ;do
    if [ "$i" == "0" ];then  name_0="$name"  ;fi
    if [ "$i" == "1" ];then
      if [ "$name_0" == "Class" ];then
        Assert_func  "$name" == "Attr1"
      elif [ "$name_0" == "Attr1" ];then
        Assert_func  "$name" == "Class"
      else
        Error_func
      fi
    fi
    if [ "$i" == "2" ];then  Error_func  ;fi
    i=`expr "$i" + 1`
  done ; done_func $?

  echo  "$keys"


  SetAttr_as_AssociativeArrayName_func  $obj  Assoc  \
    AttrA  "ValueA" \
    AttrB  "ValueB"

  Attr_func  $obj  "Assoc" ; assoc="$g_Ret"
  Attr_func  $assoc  "AttrA"
  Assert_func  "$g_Ret" == "ValueA"
  Attr_func  $assoc  "AttrB"
  Assert_func  "$g_Ret" == "ValueB"

  AssociativeArrayClass.getKeys_method  $assoc
  echo  "$g_Ret"
}


 
#//*********************************************************************
#// <<< [T_ArrayAttr_func] >>> 
#//*********************************************************************
function  T_ArrayAttr_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  local  obj="g_Object"
  local  arr

  SetAttr_as_ArrayName_func  $obj  "Attr1Values"  \
    "Value11"  "Value12"  "Value13"

  SetAttr_as_ArrayName_func  $obj  "Attr2Values"  \
    "Value21"  "Value22"

  CopyArrayAttr_func  $obj  "Attr1Values"  arr  #//[out] arr

  Assert_func  '"${#arr[@]}" == "3"'
  Assert_func  '"${arr[0]}" == "Value11"'
  Assert_func  '"${arr[1]}" == "Value12"'
  Assert_func  '"${arr[2]}" == "Value13"'

  CopyArrayAttr_func  $obj  "Attr2Values"  arr  #//[out] arr

  Assert_func  '"${#arr[@]}" == "2"'
  Assert_func  '"${arr[0]}" == "Value21"'
  Assert_func  '"${arr[1]}" == "Value22"'
}


 
#//*********************************************************************
#// <<< [T_SetAttrInFunc_func] >>> 
#//*********************************************************************
function  T_SetAttrInFunc_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  $declare_AssociativeArrayClass  object_a

  T_SetAttrInFuncSub_func  object_a
  Attr_func  object_a  "Attr1" ; echo  "$g_Ret"
  if [ "$g_Ret" != "Value  1" ];then  Error_func  ;fi
  Attr_func  object_a  "Attr2" ; echo  "$g_Ret"
  if [ "$g_Ret" != "Value  2" ];then  Error_func  ;fi
  AssociativeArrayClass.destroy_method  object_a
}

function  T_SetAttrInFuncSub_func()
{
  local  AssocArrayName="$1"
  SetAttr_func  $AssocArrayName  Attr1  "Value  1"
  SetAttr_func  $AssocArrayName  Attr2  "Value  2"
}


 
#//*********************************************************************
#// <<< [T_CopyArray_func] >>> 
#//*********************************************************************
function  T_CopyArray_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  local  ArrayA
  ArrayA[0]="Value0"
  ArrayA[1]="Value1"
  ArrayA[2]="Value2"
  local  self=ArrayA

  local  ArrayB
  ArrayB[3]="Value3"
  CopyArray_func  ArrayB  $self

  echo  "${!ArrayB[@]}"
  echo  "${ArrayB[@]}"

  Assert_func  '"${#ArrayB[@]}" == "3"'
  Assert_func  '"${ArrayB[0]}" == "Value0"'
  Assert_func  '"${ArrayB[1]}" == "Value1"'
  Assert_func  '"${ArrayB[2]}" == "Value2"'
}


 
#//*********************************************************************
#// <<< [T_CopyAssociativeArray4_func] >>> 
#//*********************************************************************
function  T_CopyAssociativeArray4_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  declare -A  ObjectA  #// associative array
  ObjectA["Attr1"]="Value1"
  ObjectA[Attr2]="Value2"
  ObjectA["Attr3"]="Value3"
  local  self=ObjectA

  declare -A  ObjectB  #// associative array
  ObjectB["Attr4"]="Value4"
  CopyArray_func  ObjectB  $self

  echo  "${!ObjectB[@]}"
  echo  "${ObjectB[@]}"

  Assert_func  '"${#ObjectB[@]}" == "3"'
  Assert_func  '"${ObjectB["Attr1"]}" == "Value1"'
  Assert_func  '"${ObjectB["Attr2"]}" == "Value2"'
  Assert_func  '"${ObjectB["Attr3"]}" == "Value3"'
}


 
#//*********************************************************************
#// <<< [T_CopyAssociativeArray3_func] >>> 
#//*********************************************************************
function  T_CopyAssociativeArray3_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}

  local  arr
  local  ans

  $declare_AssociativeArrayClass  ObjectA
  SetAttr_func  ObjectA  "Attr1"  "Value1"
  SetAttr_func  ObjectA  "Attr2"  "Value2"
  SetAttr_func  ObjectA  "Attr3"  "Value3"
  local  self=ObjectA

  $declare_AssociativeArrayClass  ObjectB
  SetAttr_func  ObjectB  "Attr4"  "Value4"
  CopyArray_func  ObjectB  $self

  AssociativeArrayClass.getKeys_method   ObjectB ; arr=( $g_Ret )
  echo  "${arr[@]}"
  ans=( "Attr1"  "Attr2"  "Attr3" )
  IsSameArrayOutOfOrder_func  ${#arr[@]}  "${arr[@]}"  "${ans[@]}"
  if [ "$g_Ret" == "0" ];then  Error_func  ;fi

  AssociativeArrayClass.getItems_method  ObjectB ; arr=( $g_Ret )
  echo  "${arr[@]}"
  ans=( "Value1"  "Value2"  "Value3" )
  IsSameArrayOutOfOrder_func  ${#arr[@]}  "${arr[@]}"  "${ans[@]}"
  if [ "$g_Ret" == "0" ];then  Error_func  ;fi

  AssociativeArrayClass.getLength_method  ObjectB
  Assert_func  '"$g_Ret" == "3"'
  if [ "${BASH_VERSINFO[0]}" -ge "4" ];then
    Assert_func  '"${ObjectB[Attr1]}" == "Value1"'
    Assert_func  '"${ObjectB[Attr2]}" == "Value2"'
    Assert_func  '"${ObjectB[Attr3]}" == "Value3"'
  else
    Assert_func  '"$ObjectB__Attr1" == "Value1"'
    Assert_func  '"$ObjectB__Attr2" == "Value2"'
    Assert_func  '"$ObjectB__Attr3" == "Value3"'
  fi

  AssociativeArrayClass.destroy_method  ObjectA
  AssociativeArrayClass.destroy_method  ObjectB
}


 
#//*********************************************************************
#// <<< [T_CopyArrayAttr_func] >>> 
#//*********************************************************************
function  T_CopyArrayAttr_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  $declare_AssociativeArrayClass  obj
  local  arr

  SetAttr_as_ArrayName_func  obj  "AttrA"  "a" "b" "c"
  CopyArrayAttr_func  obj  "AttrA"  arr  #//[out] arr

  Assert_func  '"${arr[0]}" = "a"'
  Assert_func  '"${arr[1]}" = "b"'
  Assert_func  '"${arr[2]}" = "c"'
}


 
#//*********************************************************************
#// <<< [T_CheckArgCount_func] >>> 
#//*********************************************************************
function  T_CheckArgCount_func()
{
  EchoTestStart_func  "${FUNCNAME[0]}"

  FuncArg2_func  a b

  while TryStart_func; do
    FuncArg2_func  a
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" != "1" ]; then  Error_func  "Error exptected"  ;fi
  echo "This error is OK";  ErrClass.clear_method

  while TryStart_func; do
    FuncArg2_func  a b c
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" != "1" ]; then  Error_func  "Error exptected"  ;fi
  echo "This error is OK";  ErrClass.clear_method


  FuncMinArg2_func  a b
  FuncMinArg2_func  a b c

  while TryStart_func; do
    FuncMinArg2_func  a
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" != "1" ]; then  Error_func  "Error exptected"  ;fi
  echo "This error is OK";  ErrClass.clear_method


  FuncMaxArg2_func  a
  FuncMaxArg2_func  a b

  while TryStart_func; do
    FuncMaxArg2_func  a b c
  TryEnd1_func; done ;TryEnd2_func $?
  if [ "$g_ExitStatus" != "1" ]; then  Error_func  "Error exptected"  ;fi
  echo "This error is OK";  ErrClass.clear_method
}


function  FuncArg2_func()
{
  CheckArgCount_func  2  "$@"
}


function  FuncMinArg2_func()
{
  CheckMinArgCount_func  2  "$@"
}


function  FuncMaxArg2_func()
{
  CheckMaxArgCount_func  2  "$@"
}


 
#//*********************************************************************
#// <<< [T_GetLongOptions_func] >>> 
#//*********************************************************************
function  T_GetLongOptions_func()
{
  EchoTestStart_func  ${FUNCNAME[0]}
  T_GetLongOptionsSub_func  --opt1  arg1  --opt2=a,b  --opt3="a b"  arg2  arg3
}

function  T_GetLongOptionsSub_func()
{
  local  arguments
  $declare_AssociativeArrayClass  option

  GetLongOptions_func  arguments  option  "$@"  #//[out] arguments, option
  Assert_func  '"${arguments[0]}" == "arg1"'
  Assert_func  '"${arguments[1]}" == "arg2"'
  Assert_func  '"${arguments[2]}" == "arg3"'
  Assert_func  '${#arguments[@]} == 3'
  Attr_func  option  "opt1" ; Assert_func  '"$g_Ret" == "1"'
  Attr_func  option  "not"  ; Assert_func  '"$g_Ret"  == ""'
  Attr_func  option  "opt2" ; Assert_func  '"$g_Ret" == "a,b"'
  Attr_func  option  "opt3" ; Assert_func  '"$g_Ret" == "a b"'

  AssociativeArrayClass.destroy_method  option
}


 
#//*********************************************************************
#// <<< [T_local_func] >>> 
#//*********************************************************************
function  T_local_func()
{
  local  tmp1="a"
  local  tmp2="b"
  local  tmp3

  EchoTestStart_func  ${FUNCNAME[0]}

  EchoTestStart_func  "T_local_1_func"
  T_local_1_func
  Assert_func  "$tmp1" == "a"
  Assert_func  "$tmp2" == "b"

  EchoTestStart_func  "T_local_Arg_func"
  T_local_Arg_func  "a"  "b" ; tmp3="$g_Ret"
  echo  "$tmp3"
  Assert_func  '"$tmp3" == "a,b"'

  EchoTestStart_func  "T_local_Out_func  tmp3"
  tmp3=""
  T_local_Out_func  tmp3  #//[out] tmp3
  Assert_func  "$tmp3" == "xxx"
  Assert_func  "$tmp1" == "a"
  Assert_func  "$tmp2" == "b"

  #// collision
  EchoTestStart_func  "T_local_Out_func  tmp2"
  while TryStart_func; do
    T_local_Out_func  tmp2  #//[out] tmp2
  TryEnd1_func; done ;TryEnd2_func $?
  echo  "$g_Err_Desc"
  if [ "$g_ExitStatus" == "0" ]; then  Error_func  "Error exptected"  ;fi
  StringClass.indexOf_method  "$g_Err_Desc"  "出力引数"
  if [ "$g_Ret" == "-1" ];then
    StringClass.indexOf_method  "$g_Err_Desc"  "Output argument"
    if [ "$g_Ret" == "-1" ];then  Error_func  ;fi
  fi
  ErrClass.clear_method
  echo  "This error is OK"

  EchoTestStart_func  "T_local_InOut_func  tmp3"
  tmp3=""
  T_local_InOut_func  tmp1  tmp3  #//[out] tmp3
  Assert_func  "$tmp3" == "xxx"
  Assert_func  "$tmp1" == "a"
  Assert_func  "$tmp2" == "b"

  #// collision
  EchoTestStart_func  "T_local_InOut_func  tmp2"
  while TryStart_func; do
    T_local_InOut_func  tmp1  tmp2  #//[out] tmp2
  TryEnd1_func; done ;TryEnd2_func $?
  echo  "$g_Err_Desc"
  if [ "$g_ExitStatus" == "0" ]; then  Error_func  "Error exptected"  ;fi
  StringClass.indexOf_method  "$g_Err_Desc"  "出力引数"
  if [ "$g_Ret" == "-1" ];then
    StringClass.indexOf_method  "$g_Err_Desc"  "Output argument"
    if [ "$g_Ret" == "-1" ];then  Error_func  ;fi
  fi
  ErrClass.clear_method
  echo  "This error is OK"
}

function  T_local_1_func()
{
  echo       '--local=" tmp1, tmp2"  "$@"'
  local_func  --local=" tmp1, tmp2"  "$@" ; eval "$g_Ret"

  tmp1="xxx"
  tmp2="xxx"
}

function  T_local_Arg_func()
{
  echo       '--arg="a1, a2"  --local=" tmp1, tmp2"  "$@"'
  local_func  --arg="a1, a2"  --local=" tmp1, tmp2"  "$@" ; eval  $g_Ret

  tmp1="xxx"
  tmp2="xxx"
  g_Ret="$a1,$a2"
}

function  T_local_Out_func()
{
  echo       '--arg=" (out)out_Arg, a2 "  --local=tmp2  "$@"'
  local_func  --arg=" (out)out_Arg, a2 "  --local=tmp2  "$@" ; eval  "$g_Ret"

  SetOutput_func  $out_Arg  "xxx"
  tmp2="xxx"
}

function  T_local_InOut_func()
{
  echo       '--arg=" a1, (in_out)in_out_Arg"  --local=tmp2  "$@"'
  local_func  --arg=" a1, (in_out)in_out_Arg"  --local=tmp2  "$@" ; eval  "$g_Ret"

  SetOutput_func  $in_out_Arg  "xxx"
  tmp2="xxx"
}


 
#//*********************************************************************
#// <<< [T_SetOutputAsArray_func] >>> 
#//*********************************************************************
function  T_SetOutputAsArray_func()
{
  local  var

  EchoTestStart_func  ${FUNCNAME[0]}

  T_SetOutputAsArraySub_func  var  #//[out] var
  echo  "${var[1]}"
  Assert_func  '"${var[0]}" = "A"'
  Assert_func  '"${var[1]}" = "B  C"'
}


function  T_SetOutputAsArraySub_func()
{
  local  out="$1"

  SetOutputAsArray_func  $out  "A"  "B  C"
}


 





#//--- start of bashlib include ------------------------------------------------------ 

#// <<< set up bashlib and call Main_func >>> 

#// bashlib is provided under 3-clause BSD license.
#// Copyright (C) 2011 Sofrware Design Gallery "Sage Plaisir 21" All Rights Reserved.

g_BashLibPath="scriptlib/bashlib_inc.sh"; g_Ver="1.0"
g_StartInPath=`pwd`; cd "`dirname "$BASH_SOURCE"`"; g_Arguments=( "$BASH_SOURCE" "$@" )
for (( i = 0; i < 20; i ++ ));do
  if [ -e "$g_BashLibPath" ];then break ;else  g_BashLibPath="../$g_BashLibPath" ;fi ;done
if [ "$i" == "20" ];then  echo "${g_BashLibPath##*../} が見つかりません。
bashlib $g_Ver をダウンロードして scriptlib フォルダーをコピーしてください。"; exit 1 ;fi
source  "$g_BashLibPath"  #// include
CallMain_func
#//--- end of bashlib include --------------------------------------------------------
 
