﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using BTS.Backlog;
using CookComputing.XmlRpc;

namespace BTS.Backlog.Test
{
    [TestFixture]
    public class 接続のテスト
    {
        [TestFixtureSetUp]
        public void TestFixtureSetUp()
        {
        }

        [TestFixtureTearDown]
        public void TestFixtureTearDown()
        {
        }

        [SetUp]
        public void SetUp()
        {
        }

        [TearDown]
        public void TearDown()
        {
        }

        [TestCase( "https://kaoruntest.backlog.jp" )]
        [TestCase( "https://kaoruntest.backlog.jp/" )]
        public void Connectに正しい接続情報を与えると接続状態になる( string url )
        {
            Backlog.Connect( url, プロジェクト情報.ユーザー名, プロジェクト情報.パスワード );

            Assert.That( Backlog.IsConnected );
            Assert.AreEqual( Backlog.Url, url );
            Assert.AreEqual( Backlog.UserName, プロジェクト情報.ユーザー名 );
            Assert.AreEqual( Backlog.Password, プロジェクト情報.パスワード );
            Assert.AreEqual( Backlog.XmlRpcUrl, "https://kaoruntest.backlog.jp/XML-RPC" );

            Backlog.Close();

            Assert.That( !Backlog.IsConnected );
        }

        [TestCase( "http://kaoruntest.backlog.jp" )]
        [TestCase( "https://kaoruntest.backlog.jp/XMLRPC" )]
        [ExpectedException( typeof( XmlRpcServerException ) )]
        public void Connectに間違った接続情報を与えると例外が発生( string url )
        {
            Backlog.Connect( url, プロジェクト情報.ユーザー名, プロジェクト情報.パスワード );
        }

        [Test]
        [ExpectedException( typeof( XmlRpcServerException ) )]
        public void Connectに間違ったユーザー名を与えると例外が発生()
        {
            Backlog.Connect( プロジェクト情報.URL, "へんなユーザー名", プロジェクト情報.パスワード );
        }

        [Test]
        [ExpectedException( typeof( XmlRpcServerException ) )]
        public void Connectに間違ったパスワードを与えると例外が発生()
        {
            Backlog.Connect( プロジェクト情報.URL, プロジェクト情報.ユーザー名, "へんなパスワード" );
        }


        [TestCase( "https://kaoruntest.backlog.jp" )]
        [TestCase( "https://kaoruntest.backlog.jp/" )]
        public void TryConnectに正しい接続情報を与えるとtrueが返り未接続状態( string url )
        {
            bool ret = Backlog.TryConnect( url, プロジェクト情報.ユーザー名, プロジェクト情報.パスワード );

            Assert.True( ret );
            Assert.False( Backlog.IsConnected );

            Assert.True( string.IsNullOrEmpty( Backlog.Url ) );
            Assert.True( string.IsNullOrEmpty( Backlog.UserName ) );
            Assert.True( string.IsNullOrEmpty( Backlog.Password ) );
            Assert.True( string.IsNullOrEmpty( Backlog.XmlRpcUrl ) );
        }

        [TestCase( "http://kaoruntest.backlog.jp" )]
        [TestCase( "https://kaoruntest.backlog.jp/XMLRPC" )]
        public void TryConnectに間違った接続情報を与えると失敗し未接続状態( string url )
        {
            bool ret = Backlog.TryConnect( url, プロジェクト情報.ユーザー名, プロジェクト情報.パスワード );
            Assert.False( ret );
            Assert.False( Backlog.IsConnected );
        }

        [Test]
        public void TryConnectに間違ったユーザー名を与えると失敗し未接続状態()
        {
            bool ret = Backlog.TryConnect( プロジェクト情報.URL, "へんなユーザー名", プロジェクト情報.パスワード );
            Assert.False( ret );
            Assert.False( Backlog.IsConnected );
        }

        [Test]
        public void TryConnectに間違ったパスワードを与えると失敗し未接続状態()
        {
            bool ret = Backlog.TryConnect( プロジェクト情報.URL, プロジェクト情報.ユーザー名, "へんなパスワード" );
            Assert.False( ret );
            Assert.False( Backlog.IsConnected );
        }
    }
}
