﻿using System;
using System.Collections.Generic;
using CookComputing.XmlRpc;

namespace BTS.Backlog
{
    /// <summary>
    /// XML-RPC 属性制御
    /// </summary>
    public class XmlRpcAttributes
    {
        /// <summary>
        /// XML-RPC パラメータ
        /// </summary>
        public XmlRpcStruct Value
        {
            get;
            set;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public XmlRpcAttributes()
        {
            Value = new XmlRpcStruct();
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="Attributes"></param>
        public XmlRpcAttributes( XmlRpcStruct Attributes )
        {
            Value = Attributes;
        }

        /// <summary>
        /// キーの有無
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        public bool IsContains( string key )
        {
            return Value.Contains( key );
        }

        /// <summary>
        /// 属性を取得
        /// </summary>
        /// <typeparam name="T">値の型</typeparam>
        /// <param name="key">キー</param>
        /// <returns>値</returns>
        public T Get<T>( string key )
        {
            T result = default( T );
            if ( IsContains( key ) && (Value[key] is T) ) {
                result = (T)Value[key];
            }

            return result;
        }

        /// <summary>
        /// 属性の設定
        /// </summary>
        /// <typeparam name="T">値の型</typeparam>
        /// <param name="key">キー</param>
        /// <param name="value">値</param>
        public void Set<T>( string key, T value )
        {
            this.Value[key] = value;
        }
    }
}
