﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using BTS.Backlog;
using CookComputing.XmlRpc;

namespace BTS.Backlog.Test
{
    [TestFixture]
    public class 優先度のテスト
    {
        XmlRpcStruct param;

        [TestFixtureSetUp]
        public void TestFixtureSetUp()
        {
        }

        [TestFixtureTearDown]
        public void TestFixtureTearDown()
        {
        }

        [SetUp]
        public void SetUp()
        {
            param = new XmlRpcStruct();
            param["id"] = 10;
            param["name"] = "優先度名";
        }

        [TearDown]
        public void TearDown()
        {
        }

        [Test]
        public void データをパースして戻せる()
        {
            Priority pri = new Priority( param );
            Assert.AreEqual( pri.Id, param["id"] );
            Assert.AreEqual( pri.Name, param["name"] );

            XmlRpcStruct ret = pri.ToXmlRpcStruct();
            Assert.AreEqual( ret["id"], param["id"] );
            Assert.AreEqual( ret["name"], param["name"] );
        }

        [Test]
        [ExpectedException( typeof( NullReferenceException ) )]
        public void idがないと例外()
        {
            param.Remove( "id" );

            Priority pri = new Priority( param );
        }

        [Test]
        [ExpectedException( typeof( NullReferenceException ) )]
        public void nameがないと例外()
        {
            param.Remove( "name" );

            Priority pri = new Priority( param );
        }
    }
}
