﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CookComputing.XmlRpc;

namespace BTS.Backlog
{
    public interface IBacklog : IXmlRpcProxy
    {
        /// <summary>
        /// プロジェクトの一覧を取得する
        /// </summary>
        /// <returns></returns>
        [XmlRpcMethod( "backlog.getProjects" )]
        XmlRpcStruct[] GetProjects();

        /// <summary>
        /// プロジェクトIDからプロジェクト情報を取得する
        /// </summary>
        /// <param name="projectId">プロジェクトID</param>
        /// <returns></returns>
        [XmlRpcMethod( "backlog.getProject" )]
        XmlRpcStruct GetProject( int projectId );

        /// <summary>
        /// プロジェクトキーからプロジェクト情報を取得する
        /// </summary>
        /// <param name="projectKey">プロジェクトキー</param>
        /// <returns></returns>
        [XmlRpcMethod( "backlog.getProject" )]
        XmlRpcStruct GetProject( string projectKey );

        /// <summary>
        /// ユーザーの一覧を取得する
        /// </summary>
        /// <param name="projectId"></param>
        /// <returns></returns>
        [XmlRpcMethod( "backlog.getUsers" )]
        XmlRpcStruct[] GetUsers( int projectId );

        /// <summary>
        /// コンポーネント（カテゴリー）の一覧を取得する
        /// </summary>
        /// <param name="projectId"></param>
        /// <returns></returns>
        [XmlRpcMethod( "backlog.getComponents" )]
        XmlRpcStruct[] GetComponents( int projectId );

        /// <summary>
        /// バージョン/マイルストーンの一覧を取得する
        /// </summary>
        /// <param name="projectId"></param>
        /// <returns></returns>
        [XmlRpcMethod( "backlog.getVersions" )]
        XmlRpcStruct[] GetVersions( int projectId );

        /// <summary>
        /// プロジェクトの種別を取得する
        /// </summary>
        /// <param name="projectId"></param>
        /// <returns></returns>
        [XmlRpcMethod( "backlog.getIssueTypes" )]
        XmlRpcStruct[] GetIssueTypes( int projectId );

        /// <summary>
        /// 課題を作成する
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        [XmlRpcMethod( "backlog.createIssue" )]
        XmlRpcStruct CreateIssue( XmlRpcStruct param );

        /// <summary>
        /// 課題を検索する
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        [XmlRpcMethod( "backlog.findIssue" )]
        XmlRpcStruct[] FindIssue( XmlRpcStruct param );

        /// <summary>
        /// 課題の数を取得する
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        [XmlRpcMethod( "backlog.countIssue" )]
        int CountIssue( XmlRpcStruct param );

        /// <summary>
        /// 課題を取得する
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        [XmlRpcMethod( "backlog.getIssue" )]
        XmlRpcStruct GetIssue( string key );

        /// <summary>
        /// 課題を取得する
        /// </summary>
        /// <param id="param"></param>
        /// <returns></returns>
        [XmlRpcMethod( "backlog.getIssue" )]
        XmlRpcStruct GetIssue( int id );

        /// <summary>
        /// 課題の更新
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        [XmlRpcMethod( "backlog.updateIssue" )]
        XmlRpcStruct UpdateIssue( XmlRpcStruct param );

        /// <summary>
        /// 課題のコメントを取得
        /// </summary>
        /// <param issueId="param"></param>
        /// <returns></returns>
        [XmlRpcMethod( "backlog.getComments" )]
        XmlRpcStruct[] GetComments( int issueId );

        /// <summary>
        /// 課題の状態を変更する
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        [XmlRpcMethod( "backlog.switchStatus" )]
        XmlRpcStruct SwitchStatus( XmlRpcStruct param );

        /// <summary>
        /// ユーザーを取得する
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        [XmlRpcMethod("backlog.getUser")]
        XmlRpcStruct GetUser(string userId);
    }
}
