﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using BTS.Backlog;
using CookComputing.XmlRpc;

namespace BTS.Backlog.Test
{
    [TestFixture]
    public class ユーザーのテスト
    {
        Project project;
        XmlRpcStruct param;

        [TestFixtureSetUp]
        public void TestFixtureSetUp()
        {
            Backlog.Connect( プロジェクト情報.URL, プロジェクト情報.ユーザー名, プロジェクト情報.パスワード );
            project = new Project( プロジェクト情報.デフォルトプロジェクトID );
        }

        [TestFixtureTearDown]
        public void TestFixtureTearDown()
        {
            Backlog.Close();
        }

        [SetUp]
        public void SetUp()
        {
            param = new XmlRpcStruct();
            param["id"] = 100;
            param["name"] = "ユーザー名";
        }

        [TearDown]
        public void TearDown()
        {
        }

        [Test]
        public void 全てのユーザが取得できる()
        {
            List<User> users = project.GetUsers();

            Assert.That( users.Count == 2 );

            Assert.That( users[0].Id == 32718 );
            Assert.That( users[0].Name == "ikikko" );

            Assert.That( users[1].Id == 32717 );
            Assert.That( users[1].Name == "かおるん" );
        }

        [Test]
        public void データをパースして戻せる()
        {
            User user = new User( param );
            Assert.AreEqual( user.Id, param["id"] );
            Assert.AreEqual( user.Name, param["name"] );

            XmlRpcStruct ret = user.ToXmlRpcStruct();
            Assert.AreEqual( ret["id"], param["id"] );
            Assert.AreEqual( ret["name"], param["name"] );
        }

        [Test]
        [ExpectedException( typeof( NullReferenceException ) )]
        public void idがないと例外()
        {
            param.Remove( "id" );

            User user = new User( param );
        }

        [Test]
        [ExpectedException( typeof( NullReferenceException ) )]
        public void nameがないと例外()
        {
            param.Remove( "name" );

            User user = new User( param );
        }
    }
}
