/*
 * LightVisionView.java
 */

package cerot.blight.ui;

import java.awt.event.ItemEvent;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;

import cerot.blight.btrace.BTraceController;
import cerot.blight.btrace.MethodExpression;
import cerot.blight.sequence.SequenceConverter;
import cerot.blight.sequence.SequenceCreator;
import cerot.blight.sequence.entity.Connector;

import org.jdesktop.application.FrameView;
import org.jdesktop.application.SingleFrameApplication;
import org.jgraph.JGraph;

/**
 * The application's main frame.
 */
public class LightVisionView extends FrameView {

	public LightVisionView(SingleFrameApplication app) {
		super(app);
		initComponents();
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	// <editor-fold defaultstate="collapsed"
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        mainPanel = new javax.swing.JPanel();
        button = new javax.swing.JButton();
        jvmCombo = new javax.swing.JComboBox();
        targetText = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        menuBar = new javax.swing.JMenuBar();
        jvmFinder1 = new cerot.blight.ui.JvmFinder();

        mainPanel.setName("mainPanel"); // NOI18N
        mainPanel.setPreferredSize(new java.awt.Dimension(400, 200));

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(cerot.blight.ui.LightVision.class).getContext().getResourceMap(LightVisionView.class);
        button.setText(resourceMap.getString("button.text")); // NOI18N
        button.setEnabled(false);
        button.setName("button"); // NOI18N
        button.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                buttonMouseClicked(evt);
            }
        });

        jvmCombo.setName("jvmCombo"); // NOI18N

        org.jdesktop.beansbinding.ELProperty eLProperty = org.jdesktop.beansbinding.ELProperty.create("${jvmList}");
        org.jdesktop.swingbinding.JComboBoxBinding jComboBoxBinding = org.jdesktop.swingbinding.SwingBindings.createJComboBoxBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, jvmFinder1, eLProperty, jvmCombo);
        bindingGroup.addBinding(jComboBoxBinding);

        jvmCombo.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jvmComboItemStateChanged(evt);
            }
        });

        targetText.setText(resourceMap.getString("targetText.text")); // NOI18N
        targetText.setName("targetText"); // NOI18N

        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1"); // NOI18N

        javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jvmCombo, 0, 376, Short.MAX_VALUE)
                    .addGroup(mainPanelLayout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(targetText, javax.swing.GroupLayout.DEFAULT_SIZE, 301, Short.MAX_VALUE))
                    .addComponent(button))
                .addContainerGap())
        );
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jvmCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(targetText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addComponent(button)
                .addContainerGap(22, Short.MAX_VALUE))
        );

        menuBar.setName("menuBar"); // NOI18N

        setComponent(mainPanel);
        setMenuBar(menuBar);

        bindingGroup.bind();
    }// </editor-fold>//GEN-END:initComponents

	private void jvmComboItemStateChanged(java.awt.event.ItemEvent evt) {// GEN-FIRST:event_jvmComboItemStateChanged
		if (evt.getStateChange() == ItemEvent.SELECTED) {
			String data = (String) jvmCombo.getSelectedItem();
			int separatorIndex = data.indexOf(" : ");

			if (separatorIndex > 0) {
				button.setEnabled(true);
			} else {
				button.setEnabled(false);
			}
		}
	}// GEN-LAST:event_jvmComboItemStateChanged

	private void buttonMouseClicked(java.awt.event.MouseEvent evt) {// GEN-FIRST:event_buttonMouseClicked
		if (button.isEnabled() == false) {
			return;
		}

		if (isTracing) {
			BTraceDettachWorker worker = new BTraceDettachWorker();
			worker.execute();
			isTracing = false;
			jvmCombo.setEnabled(true);
			button.setText("Start");
		} else {
			String pid = calcPid();
			if (pid == null) {
				return;
			}

			BTraceAttachWorker worker = new BTraceAttachWorker(pid);
			worker.execute();
			isTracing = true;
			jvmCombo.setEnabled(false);
			button.setText("Stop");
		}
	}// GEN-LAST:event_buttonMouseClicked

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton button;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JComboBox jvmCombo;
    private cerot.blight.ui.JvmFinder jvmFinder1;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JTextField targetText;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

	private boolean isTracing = false;
	private BTraceController btraceController;

	private String calcPid() {
		String item = (String) jvmCombo.getSelectedItem();
		if (item == null) {
			return null;
		}

		int separatorIndex = item.indexOf(" : ");
		if (separatorIndex < 0) {
			return null;
		}

		String pid = item.substring(0, separatorIndex);
		return pid;
	}

	private class BTraceAttachWorker extends SwingWorker<Object, Object> {
		private String pid;

		public BTraceAttachWorker(String pid) {
			this.pid = pid;
		}

		@Override
		protected Object doInBackground() throws Exception {
			btraceController = new BTraceController();
			btraceController.beginTrace(this.pid);
			return null;
		}
	}

	private class BTraceDettachWorker extends SwingWorker<Object, Object> {
		@Override
		protected Object doInBackground() throws Exception {
			btraceController.stopTrace();
			return null;
		}

		@Override
		protected void done() {
			List<MethodExpression> methodExpressionList = btraceController
					.getResult();
			List<Connector> connectorList = SequenceConverter
					.toConnectorList(methodExpressionList);
			SequenceCreator sequence = new SequenceCreator(connectorList);
			JGraph graph = sequence.createGraph();

			JFrame frame = new JFrame();
			frame.getContentPane().add(new JScrollPane(graph));
			frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			frame.pack();
			frame.setVisible(true);
		}
	}
}
