package cerot.tools.taskcoach.entity;

import java.util.Date;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import cerot.tools.taskcoach.entity.adapter.DateAdapter;

/**
 * エフォートのモデルクラス。
 * @author cero-t
 * 
 */
public class Effort {
	/** ストップ */
	@XmlAttribute
	@XmlJavaTypeAdapter(DateAdapter.class)
	public Date start;

	/** ストップ */
	@XmlAttribute
	@XmlJavaTypeAdapter(DateAdapter.class)
	public Date stop;

	/** ステータス */
	@XmlAttribute
	public String status;

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}
}
