package cerot.tools.redmine.timelog.entity;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * 経過時間のモデルクラス。
 * @author cero-t
 * 
 */
public class TimeEntry {
	/** チケット */
	private Integer issueId;

	/** 日付 */
	private String spentOn;

	/** 時間 */
	private String hours;

	/** コメント */
	private String comments;

	/** 活動 */
	private Integer activityId;

	/**
	 * チケットを取得します。
	 * @return チケット
	 */
	public Integer getIssueId() {
		return issueId;
	}

	/**
	 * チケットを設定します。
	 * @param issueId チケット
	 */
	public void setIssueId(Integer issueId) {
		this.issueId = issueId;
	}

	/**
	 * 日付を取得します。
	 * @return 日付
	 */
	public String getSpentOn() {
		return spentOn;
	}

	/**
	 * 日付を設定します。
	 * @param spentOn 日付
	 */
	public void setSpentOn(String spentOn) {
		this.spentOn = spentOn;
	}

	/**
	 * 時間を取得します。
	 * @return 時間
	 */
	public String getHours() {
		return hours;
	}

	/**
	 * 時間を設定します。
	 * @param hours 時間
	 */
	public void setHours(String hours) {
		this.hours = hours;
	}

	/**
	 * コメントを取得します。
	 * @return コメント
	 */
	public String getComments() {
		return comments;
	}

	/**
	 * コメントを設定します。
	 * @param comments コメント
	 */
	public void setComments(String comments) {
		this.comments = comments;
	}

	/**
	 * 活動を取得します。
	 * @return 活動
	 */
	public Integer getActivityId() {
		return activityId;
	}

	/**
	 * 活動を設定します。
	 * @param activityId 活動
	 */
	public void setActivityId(Integer activityId) {
		this.activityId = activityId;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}
}
