package cerot.blight.btrace;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;

import cerot.util.ResourceUtils;

import com.sun.btrace.client.Client;
import com.sun.btrace.comm.MessageCommand;
import com.sun.btrace.compiler.Compiler;

/**
 * BTraceの操作を行うクラス。
 * @author cero-t
 * 
 */
public class BTraceController {
	/** 対象メソッドの正規表現 */
	private static final String TARGET_METHOD = "/.*/";

	/** BTraceクライアント */
	private Client client;

	/** BTraceクライアントが利用するポート番号 */
	private static final int DEFAULT_PORT = 2020;

	/** BTraceクライアントコマンドのリスナー */
	private MemoryCommandListener listener;

	/**
	 * トレースを開始します。
	 * @param pid トレース対象のプロセスID
	 * @param targetPackage トレース対象のパッケージ
	 * @throws IOException BTraceスクリプトの読み込みに失敗した場合か、アタッチに失敗した場合
	 */
	public void beginTrace(String pid, String targetPackage) throws IOException {
		String source = ResourceUtils.readResourceToString("/Trace.txt");
		targetPackage = targetPackage.replaceAll("\\.", "\\\\.");
		source = source.replaceAll("%CLASS_NAME%", "/" + targetPackage + ".*/");
		source = source.replaceAll("%METHOD_NAME%", TARGET_METHOD);

		com.sun.btrace.compiler.Compiler compiler = new Compiler();
		Map<String, byte[]> classMap = compiler.compile("Trace.java", source,
				new OutputStreamWriter(System.err), null, null);

		this.client = new Client(DEFAULT_PORT);
		this.client.attach(pid);
		this.listener = new MemoryCommandListener(this.client);
		this.client.submit(classMap.get("Trace"), new String[0], this.listener);
	}

	/**
	 * トレースを終了します。
	 * @throws IOException トレースの終了に失敗した場合
	 */
	public void stopTrace() throws IOException {
		this.client.sendExit();
	}

	/**
	 * トレース結果を取得します。
	 * @return トレース結果
	 */
	public List<MethodExpression> getResult() {
		List<MessageCommand> messageList = this.listener.getMessageList();
		List<MethodExpression> result = BTraceConverter
				.toMethodExpressionList(messageList);

		// TODO: debug code
		for (MethodExpression methodExpression : result) {
			System.out.println(methodExpression);
		}

		return result;
	}
}
