/**
 * $Id: mxCellHandler.java,v 1.6 2009/01/14 14:39:55 gaudenz Exp $
 * Copyright (c) 2008, Gaudenz Alder
 */
package com.mxgraph.swing.handler;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

import javax.swing.JComponent;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxCellState;

/**
 * @author Administrator
 * 
 */
public class mxCellHandler
{

	/**
	 * 
	 */
	protected mxGraphComponent graphComponent;

	/**
	 * 
	 */
	protected mxCellState state;

	/**
	 * 
	 */
	protected Rectangle[] handles;

	/**
	 * 
	 */
	protected boolean labelMovable;

	/**
	 *
	 */
	protected boolean handlesVisible = true;

	/**
	 * 
	 */
	protected transient JComponent preview;

	/**
	 * 
	 */
	protected transient Point start;

	/**
	 * 
	 */
	protected transient int index;

	/**
	 * 
	 * @param graphComponent Enclosing graph component.
	 * @param state Cell state for which the handler is created.
	 */
	public mxCellHandler(mxGraphComponent graphComponent, mxCellState state)
	{
		this.graphComponent = graphComponent;
		this.state = state;

		String label = graphComponent.getGraph().getLabel(state.getCell());
		labelMovable = graphComponent.getGraph()
				.isLabelMovable(state.getCell())
				&& label != null && label.length() > 0;

		handles = createHandles();
	}

	/**
	 * 
	 */
	public boolean isLabelMovable()
	{
		return labelMovable;
	}

	/**
	 * 
	 */
	public boolean isHandlesVisible()
	{
		return handlesVisible;
	}

	/**
	 * 
	 */
	public void setHandlesVisible(boolean handlesVisible)
	{
		this.handlesVisible = handlesVisible;
	}

	/**
	 * Returns true if the given index is the index of the last handle.
	 */
	public boolean isLabel(int index)
	{
		return index == getHandleCount() - 1;
	}

	/**
	 * 
	 */
	protected Rectangle[] createHandles()
	{
		return null;
	}

	/**
	 * 
	 */
	protected int getHandleCount()
	{
		return (handles != null) ? handles.length : 0;
	}

	/**
	 * 
	 * @return Returns the cell state that is associated with this handler.
	 */
	public mxCellState getState()
	{
		return state;
	}

	/**
	 * Hook for subclassers to return tooltip texts for certain points on the
	 * handle.
	 */
	public String getToolTipText(MouseEvent e)
	{
		return null;
	}

	/**
	 * 
	 * @param x
	 * @param y
	 * @return Returns the handle index for the given location.
	 */
	protected int getIndexAt(int x, int y)
	{
		if (handles != null && handlesVisible)
		{
			Rectangle rect = new Rectangle(x, y, 1, 1);

			for (int i = handles.length - 1; i >= 0; i--)
			{
				if (isHandleVisible(i) && handles[i].intersects(rect))
				{
					return i;
				}
			}
		}

		return -1;
	}

	/**
	 * 
	 * @param e
	 */
	public void mousePressed(MouseEvent e)
	{
		if (!e.isConsumed())
		{
			int tmp = getIndexAt(e.getX(), e.getY());

			if (!isIgnoredEvent(e) && tmp >= 0)
			{
				graphComponent.stopEditing(true);
				start(e, tmp);
				e.consume();
			}
		}
	}
	
	/**
	 * 
	 */
	public void start(MouseEvent e, int index)
	{
		this.index = index;
		start = e.getPoint();
		preview = createPreview();
		graphComponent.getGraphControl().add(preview, 0);
	}

	/**
	 * 
	 */
	protected boolean isIgnoredEvent(MouseEvent e)
	{
		return graphComponent.isEditEvent(e);
	}

	/**
	 * 
	 */
	protected JComponent createPreview()
	{
		return null;
	}

	/**
	 * 
	 * @param e
	 */
	public void mouseDragged(MouseEvent e)
	{
		// empty
	}

	/**
	 * 
	 * @param e
	 */
	public void mouseReleased(MouseEvent e)
	{
		reset();
	}

	/**
	 * 
	 */
	public void reset()
	{
		if (preview != null)
		{
			preview.setVisible(false);
			preview.getParent().remove(preview);
			preview = null;
		}

		start = null;
	}

	/**
	 * 
	 * @param e
	 */
	public void mouseMoved(MouseEvent e)
	{
		if (!e.isConsumed() && handles != null)
		{
			int index = getIndexAt(e.getX(), e.getY());

			if (index >= 0)
			{
				Cursor cursor = getCursor(e, index);

				if (cursor != null)
				{
					graphComponent.getGraphControl().setCursor(cursor);
					e.consume();
				}
				else
				{
					graphComponent.getGraphControl().setCursor(
							mxConnectionHandler.DEFAULT_CURSOR);
				}
			}
		}
	}

	/**
	 * 
	 * @param e
	 * @param index
	 * @return Returns the cursor for the given event and index.
	 */
	protected Cursor getCursor(MouseEvent e, int index)
	{
		return null;
	}

	/**
	 * 
	 * @param g
	 */
	public void paint(Graphics g)
	{
		if (handles != null && handlesVisible)
		{
			for (int i = 0; i < handles.length; i++)
			{
				if (isHandleVisible(i))
				{
					g.setColor(getHandleFillColor(i));
					g.fillRect(handles[i].x, handles[i].y, handles[i].width,
							handles[i].height);

					g.setColor(getHandleBorderColor(i));
					g.drawRect(handles[i].x, handles[i].y,
							handles[i].width - 1, handles[i].height - 1);
				}
			}
		}
	}

	/**
	 * 
	 */
	protected boolean isHandleVisible(int index)
	{
		return !isLabel(index) || isLabelMovable();
	}

	/**
	 * 
	 */
	protected Color getHandleFillColor(int index)
	{
		if (isLabel(index))
		{
			return mxConstants.LABEL_HANDLE_FILLCOLOR;
		}

		return mxConstants.HANDLE_FILLCOLOR;
	}

	/**
	 * 
	 */
	protected Color getHandleBorderColor(int index)
	{
		return mxConstants.HANDLE_BORDERCOLOR;
	}

}
