/*
 * $HeadURL: https://svn.apache.org/repos/asf/httpcomponents/httpcore/tags/4.0-beta3/module-main/src/test/java/org/apache/http/entity/TestBasicHttpEntity.java $
 * $Revision: 618017 $
 * $Date: 2008-02-03 17:42:22 +0100 (Sun, 03 Feb 2008) $
 * 
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package org.apache.http.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

import org.apache.http.protocol.HTTP;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * Unit tests for {@link BasicHttpEntity}.
 *
 * @author <a href="mailto:oleg at ural.ru">Oleg Kalnichevski</a>
 */
public class TestBasicHttpEntity extends TestCase {

    public TestBasicHttpEntity(String testName) {
        super(testName);
    }

    public static void main(String args[]) {
        String[] testCaseName = { TestBasicHttpEntity.class.getName() };
        junit.textui.TestRunner.main(testCaseName);
    }

    public static Test suite() {
        return new TestSuite(TestBasicHttpEntity.class);
    }

    public void testBasics() throws Exception {
        
        byte[] bytes = "Message content".getBytes(HTTP.US_ASCII);
        InputStream content = new ByteArrayInputStream(bytes);
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContent(content);
        httpentity.setContentLength(bytes.length);
        
        assertEquals(bytes.length, httpentity.getContentLength());
        assertFalse(httpentity.isRepeatable());
        assertTrue(httpentity.isStreaming());
    }
    
    public void testContent() throws Exception {
        byte[] bytes = "Message content".getBytes(HTTP.US_ASCII);
        InputStream content = new ByteArrayInputStream(bytes);
        BasicHttpEntity httpentity = new BasicHttpEntity();
        try {
            httpentity.getContent();
            fail("IllegalStateException should have been thrown");
        } catch (IllegalStateException ex) {
            // expected
        }

        httpentity.setContent(null);
        try {
            httpentity.getContent();
            fail("IllegalStateException should have been thrown");
        } catch (IllegalStateException ex) {
            // expected
        }

        httpentity.setContent(content);
        httpentity.getContent();
        try {
            httpentity.getContent();
            fail("IllegalStateException should have been thrown");
        } catch (IllegalStateException ex) {
            // expected
        }

    }
    
    public void testWriteTo() throws Exception {
        byte[] bytes = "Message content".getBytes(HTTP.US_ASCII);
        InputStream content = new ByteArrayInputStream(bytes);
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContent(content);
        
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        httpentity.writeTo(out);
        byte[] bytes2 = out.toByteArray();
        assertNotNull(bytes2);
        assertEquals(bytes.length, bytes2.length);
        for (int i = 0; i < bytes.length; i++) {
            assertEquals(bytes[i], bytes2[i]);
        }
        out = new ByteArrayOutputStream();
        try {
            httpentity.writeTo(out);
            fail("IllegalStateException should have been thrown");
        } catch (IllegalStateException ex) {
            // expected
        }

        httpentity.setContent(null);
        out = new ByteArrayOutputStream();
        try {
            httpentity.writeTo(out);
            fail("IllegalStateException should have been thrown");
        } catch (IllegalStateException ex) {
            // expected
        }

        try {
            httpentity.writeTo(null);
            fail("IllegalArgumentException should have been thrown");
        } catch (IllegalArgumentException ex) {
            // expected
        }
    }

    public void testConsumeContent() throws Exception {
        byte[] bytes = "Message content".getBytes(HTTP.US_ASCII);
        InputStream content = new ByteArrayInputStream(bytes);
        BasicHttpEntity httpentity = new BasicHttpEntity();
        httpentity.setContent(null);
        httpentity.consumeContent();
        httpentity.setContent(content);
        httpentity.consumeContent();
    }
    
}
