/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.aggregation;

import com.sun.btrace.aggregation.AggregationValue;
import com.sun.btrace.aggregation.HistogramData;
import java.util.concurrent.atomic.AtomicInteger;

class Quantize
implements AggregationValue {
    private static final int ZERO_INDEX = 32;
    private AtomicInteger[] buckets = new AtomicInteger[64];

    public Quantize() {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new AtomicInteger();
        }
    }

    @Override
    public void add(int data) {
        int pos = Quantize.getBucketIndex(data);
        this.buckets[pos].incrementAndGet();
    }

    private static int logBase2(int value) {
        int pos = 0;
        if (value >= 65536) {
            value >>= 16;
            pos += 16;
        }
        if (value >= 256) {
            value >>= 8;
            pos += 8;
        }
        if (value >= 16) {
            value >>= 4;
            pos += 4;
        }
        if (value >= 4) {
            value >>= 2;
            pos += 2;
        }
        if (value >= 2) {
            ++pos;
        }
        return pos;
    }

    @Override
    public int getValue() {
        for (int i = this.buckets.length - 1; i >= 0; --i) {
            int value = this.buckets[i].get();
            if (value <= 0) continue;
            return Quantize.getBucketLabel(i);
        }
        return 0;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i].set(0);
        }
    }

    @Override
    public HistogramData getData() {
        int minIndex = this.buckets.length;
        int maxIndex = -1;
        for (int i = 0; i < this.buckets.length; ++i) {
            if (this.buckets[i].get() == 0) continue;
            minIndex = Math.min(i, minIndex);
            maxIndex = Math.max(i, maxIndex);
        }
        if (minIndex > maxIndex) {
            return null;
        }
        if (maxIndex < this.buckets.length - 1) {
            ++maxIndex;
        }
        if (minIndex > 0) {
            --minIndex;
        }
        int rows = maxIndex - minIndex + 1;
        int[] values = new int[rows];
        int[] counts = new int[rows];
        for (int i = 0; i < rows; ++i) {
            values[i] = Quantize.getBucketLabel(minIndex + i);
            counts[i] = this.buckets[minIndex + i].get();
        }
        return new HistogramData(values, counts);
    }

    private static int getBucketIndex(int data) {
        if (data == 0) {
            return 32;
        }
        if (data > 0) {
            return 33 + Quantize.logBase2(data);
        }
        if (data == Integer.MIN_VALUE) {
            return 0;
        }
        return 31 - Quantize.logBase2(0 - data);
    }

    private static int getBucketLabel(int index) {
        if (index == 32) {
            return 0;
        }
        if (index == 0) {
            return Integer.MIN_VALUE;
        }
        if (index > 32) {
            index = index - 32 - 1;
            return 1 << index;
        }
        index = 32 - index - 1;
        return 0 - (1 << index);
    }
}

