/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.handler.mxConnectionHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxCellState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class mxCellHandler {
    protected mxGraphComponent graphComponent;
    protected mxCellState state;
    protected Rectangle[] handles;
    protected boolean labelMovable;
    protected boolean handlesVisible = true;
    protected transient JComponent preview;
    protected transient Point start;
    protected transient int index;

    public mxCellHandler(mxGraphComponent mxGraphComponent2, mxCellState mxCellState2) {
        this.graphComponent = mxGraphComponent2;
        this.state = mxCellState2;
        String string = mxGraphComponent2.getGraph().getLabel(mxCellState2.getCell());
        this.labelMovable = mxGraphComponent2.getGraph().isLabelMovable(mxCellState2.getCell()) && string != null && string.length() > 0;
        this.handles = this.createHandles();
    }

    public boolean isLabelMovable() {
        return this.labelMovable;
    }

    public boolean isHandlesVisible() {
        return this.handlesVisible;
    }

    public void setHandlesVisible(boolean bl) {
        this.handlesVisible = bl;
    }

    public boolean isLabel(int n) {
        return n == this.getHandleCount() - 1;
    }

    protected Rectangle[] createHandles() {
        return null;
    }

    protected int getHandleCount() {
        return this.handles != null ? this.handles.length : 0;
    }

    public mxCellState getState() {
        return this.state;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return null;
    }

    protected int getIndexAt(int n, int n2) {
        if (this.handles != null && this.handlesVisible) {
            Rectangle rectangle = new Rectangle(n, n2, 1, 1);
            for (int i = this.handles.length - 1; i >= 0; --i) {
                if (!this.isHandleVisible(i) || !this.handles[i].intersects(rectangle)) continue;
                return i;
            }
        }
        return -1;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            int n = this.getIndexAt(mouseEvent.getX(), mouseEvent.getY());
            if (!this.isIgnoredEvent(mouseEvent) && n >= 0) {
                this.graphComponent.stopEditing(true);
                this.start(mouseEvent, n);
                mouseEvent.consume();
            }
        }
    }

    public void start(MouseEvent mouseEvent, int n) {
        this.index = n;
        this.start = mouseEvent.getPoint();
        this.preview = this.createPreview();
        this.graphComponent.getGraphControl().add((Component)this.preview, 0);
    }

    protected boolean isIgnoredEvent(MouseEvent mouseEvent) {
        return this.graphComponent.isEditEvent(mouseEvent);
    }

    protected JComponent createPreview() {
        return null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.reset();
    }

    public void reset() {
        if (this.preview != null) {
            this.preview.setVisible(false);
            this.preview.getParent().remove(this.preview);
            this.preview = null;
        }
        this.start = null;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        if (!mouseEvent.isConsumed() && this.handles != null && (n = this.getIndexAt(mouseEvent.getX(), mouseEvent.getY())) >= 0) {
            Cursor cursor = this.getCursor(mouseEvent, n);
            if (cursor != null) {
                this.graphComponent.getGraphControl().setCursor(cursor);
                mouseEvent.consume();
            } else {
                this.graphComponent.getGraphControl().setCursor(mxConnectionHandler.DEFAULT_CURSOR);
            }
        }
    }

    protected Cursor getCursor(MouseEvent mouseEvent, int n) {
        return null;
    }

    public void paint(Graphics graphics) {
        if (this.handles != null && this.handlesVisible) {
            for (int i = 0; i < this.handles.length; ++i) {
                if (!this.isHandleVisible(i)) continue;
                graphics.setColor(this.getHandleFillColor(i));
                graphics.fillRect(this.handles[i].x, this.handles[i].y, this.handles[i].width, this.handles[i].height);
                graphics.setColor(this.getHandleBorderColor(i));
                graphics.drawRect(this.handles[i].x, this.handles[i].y, this.handles[i].width - 1, this.handles[i].height - 1);
            }
        }
    }

    protected boolean isHandleVisible(int n) {
        return !this.isLabel(n) || this.isLabelMovable();
    }

    protected Color getHandleFillColor(int n) {
        if (this.isLabel(n)) {
            return mxConstants.LABEL_HANDLE_FILLCOLOR;
        }
        return mxConstants.HANDLE_FILLCOLOR;
    }

    protected Color getHandleBorderColor(int n) {
        return mxConstants.HANDLE_BORDERCOLOR;
    }
}

