/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.annotations.Kind;
import com.sun.btrace.annotations.Where;
import com.sun.btrace.org.objectweb.asm.AnnotationVisitor;
import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassVisitor;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.MethodAdapter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.runtime.ArrayAccessInstrumentor;
import com.sun.btrace.runtime.ArrayAllocInstrumentor;
import com.sun.btrace.runtime.CatchInstrumentor;
import com.sun.btrace.runtime.ClassFilter;
import com.sun.btrace.runtime.Constants;
import com.sun.btrace.runtime.ErrorReturnInstrumentor;
import com.sun.btrace.runtime.FieldAccessInstrumentor;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.LineNumberInstrumentor;
import com.sun.btrace.runtime.Location;
import com.sun.btrace.runtime.MethodCallInstrumentor;
import com.sun.btrace.runtime.MethodCopier;
import com.sun.btrace.runtime.MethodEntryInstrumentor;
import com.sun.btrace.runtime.MethodInstrumentor;
import com.sun.btrace.runtime.MethodReturnInstrumentor;
import com.sun.btrace.runtime.ObjectAllocInstrumentor;
import com.sun.btrace.runtime.OnMethod;
import com.sun.btrace.runtime.Preprocessor;
import com.sun.btrace.runtime.SynchronizedInstrumentor;
import com.sun.btrace.runtime.ThrowInstrumentor;
import com.sun.btrace.runtime.TypeCheckInstrumentor;
import com.sun.btrace.runtime.TypeUtils;
import com.sun.btrace.runtime.Verifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Instrumentor
extends ClassAdapter {
    private String btraceClassName;
    private ClassReader btraceClass;
    private List<OnMethod> onMethods;
    private List<OnMethod> applicableOnMethods;
    private Set<OnMethod> calledOnMethods;
    private String className;
    private Class clazz;

    public Instrumentor(Class clazz, String btraceClassName, ClassReader btraceClass, List<OnMethod> onMethods, ClassVisitor cv) {
        super(cv);
        this.clazz = clazz;
        this.btraceClassName = btraceClassName.replace('.', '/');
        this.btraceClass = btraceClass;
        this.onMethods = onMethods;
        this.applicableOnMethods = new ArrayList<OnMethod>();
        this.calledOnMethods = new HashSet<OnMethod>();
    }

    public Instrumentor(Class clazz, String btraceClassName, byte[] btraceCode, List<OnMethod> onMethods, ClassVisitor cv) {
        this(clazz, btraceClassName, new ClassReader(btraceCode), onMethods, cv);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        String externalName = name.replace('/', '.');
        for (OnMethod om : this.onMethods) {
            String probeClazz = om.getClazz();
            if (probeClazz.length() == 0) continue;
            char firstChar = probeClazz.charAt(0);
            if (firstChar == '/' && Constants.REGEX_SPECIFIER.matcher(probeClazz).matches()) {
                if (!externalName.matches(probeClazz = probeClazz.substring(1, probeClazz.length() - 1))) continue;
                this.applicableOnMethods.add(om);
                continue;
            }
            if (firstChar == '+') {
                String superType = probeClazz.substring(1);
                String superTypeInternal = superType.replace('.', '/');
                if (!ClassFilter.isSubTypeOf(this.clazz, superType) && !superName.equals(superTypeInternal) && !Instrumentor.isInArray(interfaces, superTypeInternal)) continue;
                this.applicableOnMethods.add(om);
                continue;
            }
            if (!probeClazz.equals(externalName)) continue;
            this.applicableOnMethods.add(om);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        String extName = Type.getType(desc).getClassName();
        for (OnMethod om : this.onMethods) {
            String probeClazz = om.getClazz();
            if (probeClazz.length() <= 0 || probeClazz.charAt(0) != '@' || (probeClazz = probeClazz.substring(1)).length() == 0) continue;
            if (Constants.REGEX_SPECIFIER.matcher(probeClazz).matches()) {
                if (!extName.matches(probeClazz = probeClazz.substring(1, probeClazz.length() - 1))) continue;
                this.applicableOnMethods.add(om);
                continue;
            }
            if (!probeClazz.equals(extName)) continue;
            this.applicableOnMethods.add(om);
        }
        return av;
    }

    @Override
    public MethodVisitor visitMethod(final int access, final String name, final String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.applicableOnMethods.size() == 0 || (access & 0x400) != 0 || (access & 0x100) != 0 || name.startsWith("$btrace$")) {
            return methodVisitor;
        }
        for (OnMethod om : this.applicableOnMethods) {
            if (om.getLocation().getValue() == Kind.LINE) {
                methodVisitor = this.instrumentorFor(om, methodVisitor, access, name, desc);
                continue;
            }
            String methodName = om.getMethod();
            if (methodName.equals("")) {
                methodName = om.getTargetName();
            }
            if (methodName.equals(name) && this.typeMatches(om.getType(), desc)) {
                methodVisitor = this.instrumentorFor(om, methodVisitor, access, name, desc);
                continue;
            }
            if (methodName.charAt(0) != '/' || !Constants.REGEX_SPECIFIER.matcher(methodName).matches() || !name.matches(methodName = methodName.substring(1, methodName.length() - 1)) || !this.typeMatches(om.getType(), desc)) continue;
            methodVisitor = this.instrumentorFor(om, methodVisitor, access, name, desc);
        }
        return new MethodAdapter(methodVisitor){

            @Override
            public AnnotationVisitor visitAnnotation(String annoDesc, boolean visible) {
                for (OnMethod om : Instrumentor.this.applicableOnMethods) {
                    String extAnnoName = Type.getType(annoDesc).getClassName();
                    String annoName = om.getMethod();
                    if (annoName.length() <= 0 || annoName.charAt(0) != '@' || (annoName = annoName.substring(1)).length() == 0) continue;
                    if (Constants.REGEX_SPECIFIER.matcher(annoName).matches()) {
                        if (!extAnnoName.matches(annoName = annoName.substring(1, annoName.length() - 1))) continue;
                        this.mv = Instrumentor.this.instrumentorFor(om, this.mv, access, name, desc);
                        continue;
                    }
                    if (!annoName.equals(extAnnoName)) continue;
                    this.mv = Instrumentor.this.instrumentorFor(om, this.mv, access, name, desc);
                }
                return this.mv.visitAnnotation(annoDesc, visible);
            }
        };
    }

    private MethodVisitor instrumentorFor(final OnMethod om, MethodVisitor mv, int access, String name, String desc) {
        final Location loc = om.getLocation();
        final Where where = loc.getWhere();
        final Type[] actionArgTypes = Type.getArgumentTypes(om.getTargetDescriptor());
        final int numActionArgs = actionArgTypes.length;
        switch (loc.getValue()) {
            case ARRAY_GET: {
                return new ArrayAccessInstrumentor(mv, access, name, desc){

                    @Override
                    protected void onBeforeArrayLoad(int opcode) {
                        if (numActionArgs == 2 && where == Where.BEFORE && TypeUtils.getArrayType(opcode).equals(actionArgTypes[0]) && Type.INT_TYPE.equals(actionArgTypes[1])) {
                            this.dup2();
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }

                    @Override
                    protected void onAfterArrayLoad(int opcode) {
                        if (numActionArgs == 1 && where == Where.AFTER && TypeUtils.getElementType(opcode).equals(actionArgTypes[0])) {
                            this.dupArrayValue(opcode);
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }
                };
            }
            case ARRAY_SET: {
                return new ArrayAccessInstrumentor(mv, access, name, desc){
                    private int maxLocal;
                    {
                        super(x0, x1, x2, x3);
                        this.maxLocal = 0;
                    }

                    @Override
                    public void visitCode() {
                        this.maxLocal = this.getArgumentTypes().length;
                        super.visitCode();
                    }

                    @Override
                    public void visitVarInsn(int opcode, int var) {
                        if (var > this.maxLocal) {
                            this.maxLocal = var;
                        }
                        super.visitVarInsn(opcode, var);
                    }

                    @Override
                    protected void onBeforeArrayStore(int opcode) {
                        Type elementType = TypeUtils.getElementType(opcode);
                        if (where == Where.BEFORE && numActionArgs == 3 && TypeUtils.getArrayType(opcode).equals(actionArgTypes[0]) && Type.INT_TYPE.equals(actionArgTypes[1]) && elementType.equals(actionArgTypes[2])) {
                            this.storeLocal(elementType, this.maxLocal + 1);
                            this.dup2();
                            this.loadLocal(elementType, this.maxLocal + 1);
                            Instrumentor.this.invokeBTraceAction(this, om);
                            this.storeLocal(elementType, this.maxLocal + 1);
                        }
                    }

                    @Override
                    protected void onAfterArrayStore(int opcode) {
                        if (numActionArgs == 0 && where == Where.BEFORE) {
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }
                };
            }
            case CALL: {
                return new MethodCallInstrumentor(mv, access, name, desc){
                    private String className;
                    private String methodName;
                    private int maxLocal;
                    {
                        super(x0, x1, x2, x3);
                        this.className = loc.getClazz();
                        this.methodName = loc.getMethod();
                        this.maxLocal = 0;
                    }

                    @Override
                    public void visitCode() {
                        this.maxLocal = this.getArgumentTypes().length;
                        super.visitCode();
                    }

                    @Override
                    public void visitVarInsn(int opcode, int var) {
                        if (var > this.maxLocal) {
                            this.maxLocal = var;
                        }
                        super.visitVarInsn(opcode, var);
                    }

                    private void callAction(boolean isStatic, String method, Type[] probeArgs, Type[] callArgs) {
                        int i;
                        int upper = callArgs.length - 1;
                        for (i = 0; i < callArgs.length; ++i) {
                            this.storeLocal(callArgs[upper - i], this.maxLocal + i);
                        }
                        if (!isStatic) {
                            this.storeLocal(TypeUtils.objectType, this.maxLocal + callArgs.length);
                        }
                        if (probeArgs.length == 1 && TypeUtils.isAnyTypeArray(probeArgs[0])) {
                            this.preAnyTypeAction(isStatic, method, callArgs);
                        } else if (probeArgs.length == 1 && TypeUtils.isString(probeArgs[0])) {
                            this.preOnlyNameAction(method);
                        } else if (probeArgs.length > 1) {
                            this.preMatchAction(isStatic, method, callArgs);
                        }
                        Instrumentor.this.invokeBTraceAction(this, om);
                        if (!isStatic) {
                            this.loadLocal(TypeUtils.objectType, this.maxLocal + callArgs.length);
                        }
                        for (i = callArgs.length - 1; i > -1; --i) {
                            this.loadLocal(callArgs[upper - i], this.maxLocal + i);
                        }
                    }

                    private void preOnlyNameAction(String method) {
                        super.visitLdcInsn(method);
                    }

                    private void preMatchAction(boolean isStatic, String method, Type[] args) {
                        if (!isStatic) {
                            this.loadLocal(TypeUtils.objectType, this.maxLocal + args.length);
                        }
                        super.visitLdcInsn(method);
                        for (int i = args.length - 1; i > -1; --i) {
                            this.loadLocal(args[args.length - 1 - i], this.maxLocal + i);
                        }
                    }

                    private void preAnyTypeAction(boolean isStatic, String method, Type[] args) {
                        int upper = args.length - 1;
                        this.push(args.length + (isStatic ? 0 : 1) + 1);
                        super.visitTypeInsn(189, TypeUtils.objectType.getInternalName());
                        if (!isStatic) {
                            this.dup();
                            this.push(0);
                            this.loadLocal(TypeUtils.objectType, this.maxLocal + args.length);
                            this.arrayStore(TypeUtils.objectType);
                        }
                        int start = isStatic ? 0 : 1;
                        this.dup();
                        this.push(start++);
                        super.visitLdcInsn(method);
                        this.arrayStore(TypeUtils.objectType);
                        for (int i = 0; i < args.length; ++i) {
                            this.dup();
                            this.push(i + start);
                            this.loadLocal(args[upper - i], this.maxLocal + i);
                            this.box(args[upper - i]);
                            this.arrayStore(TypeUtils.objectType);
                        }
                    }

                    @Override
                    protected void onBeforeCallMethod(int opcode, String owner, String name, String desc) {
                        if (where == Where.BEFORE && Instrumentor.this.matches(this.className, owner.replace('/', '.')) && Instrumentor.this.matches(this.methodName, name) && Instrumentor.this.typeMatches(loc.getType(), desc)) {
                            String method = name + desc;
                            Type[] calledMethodArgs = Type.getArgumentTypes(desc);
                            if (opcode == 184) {
                                boolean doCall = false;
                                doCall |= actionArgTypes.length == 1 && TypeUtils.isAnyTypeArray(actionArgTypes[0]);
                                doCall |= actionArgTypes.length == 1 && TypeUtils.isString(actionArgTypes[0]);
                                if (calledMethodArgs.length + 1 == numActionArgs) {
                                    Type[] tmp = new Type[numActionArgs - 1];
                                    System.arraycopy(actionArgTypes, 1, tmp, 0, tmp.length);
                                    doCall |= TypeUtils.isString(actionArgTypes[1]) && TypeUtils.isCompatible(tmp, calledMethodArgs);
                                }
                                if (doCall) {
                                    this.callAction(true, method, actionArgTypes, calledMethodArgs);
                                }
                            } else {
                                if (name.equals("<init>")) {
                                    return;
                                }
                                boolean doCall = false;
                                doCall |= actionArgTypes.length == 1 && TypeUtils.isAnyTypeArray(actionArgTypes[0]);
                                doCall |= actionArgTypes.length == 1 && TypeUtils.isString(actionArgTypes[0]);
                                if (calledMethodArgs.length + 2 == numActionArgs) {
                                    Type[] tmp = new Type[numActionArgs - 2];
                                    System.arraycopy(actionArgTypes, 2, tmp, 0, tmp.length);
                                    doCall |= (TypeUtils.isObject(actionArgTypes[0]) || TypeUtils.isCompatible(actionArgTypes[0], Type.getObjectType(owner))) && TypeUtils.isString(actionArgTypes[1]) && TypeUtils.isCompatible(tmp, calledMethodArgs);
                                }
                                if (doCall) {
                                    this.callAction(false, method, actionArgTypes, calledMethodArgs);
                                }
                            }
                        }
                    }

                    @Override
                    protected void onAfterCallMethod(int opcode, String owner, String name, String desc) {
                        if (where == Where.AFTER && Instrumentor.this.matches(this.className, owner.replace('/', '.')) && Instrumentor.this.matches(this.methodName, name) && Instrumentor.this.typeMatches(loc.getType(), desc)) {
                            Type rt = this.getReturnType();
                            switch (numActionArgs) {
                                case 0: {
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                    break;
                                }
                                case 1: {
                                    if (rt.equals(Type.VOID_TYPE) || !TypeUtils.isCompatible(actionArgTypes[0], rt)) break;
                                    this.dupValue(rt);
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                }
                            }
                        }
                    }
                };
            }
            case CATCH: {
                return new CatchInstrumentor(mv, access, name, desc){

                    @Override
                    protected void onCatch(String type) {
                        if (numActionArgs == 1 && Type.getObjectType(type).equals(actionArgTypes[0])) {
                            this.dup();
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }
                };
            }
            case CHECKCAST: {
                return new TypeCheckInstrumentor(mv, access, name, desc){

                    private void callAction(int opcode, String desc) {
                        if (opcode == 192 && numActionArgs == 1 && Type.getType(desc).equals(actionArgTypes[0])) {
                            this.dup();
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }

                    @Override
                    protected void onBeforeTypeCheck(int opcode, String desc) {
                        if (where == Where.BEFORE) {
                            this.callAction(opcode, desc);
                        }
                    }

                    @Override
                    protected void onAfterTypeCheck(int opcode, String desc) {
                        if (where == Where.AFTER) {
                            this.callAction(opcode, desc);
                        }
                    }
                };
            }
            case ENTRY: {
                return new MethodEntryInstrumentor(mv, access, name, desc){

                    private void callAction(boolean isStatic) {
                        if (!isStatic) {
                            this.loadThis();
                        }
                        this.loadArguments();
                        Instrumentor.this.invokeBTraceAction(this, om);
                    }

                    @Override
                    protected void onMethodEntry() {
                        if (numActionArgs == 0) {
                            Instrumentor.this.invokeBTraceAction(this, om);
                        } else {
                            boolean isStatic;
                            boolean bl = isStatic = (this.getAccess() & 8) != 0;
                            if (numActionArgs == 1 && TypeUtils.isAnyTypeArray(actionArgTypes[0])) {
                                this.loadArgumentArray();
                                Instrumentor.this.invokeBTraceAction(this, om);
                                return;
                            }
                            if (isStatic) {
                                Type[] probedMethodArgs = this.getArgumentTypes();
                                if (TypeUtils.isCompatible(actionArgTypes, probedMethodArgs)) {
                                    this.callAction(true);
                                }
                            } else {
                                Type[] probedMethodArgs = this.getArgumentTypes();
                                if (probedMethodArgs.length + 1 == numActionArgs) {
                                    Type[] tmp = new Type[numActionArgs - 1];
                                    System.arraycopy(actionArgTypes, 1, tmp, 0, tmp.length);
                                    if ((TypeUtils.isObject(actionArgTypes[0]) || TypeUtils.isCompatible(actionArgTypes[0], Type.getObjectType(Instrumentor.this.className))) && TypeUtils.isCompatible(tmp, probedMethodArgs)) {
                                        this.callAction(false);
                                    }
                                }
                            }
                        }
                    }
                };
            }
            case ERROR: {
                return new ErrorReturnInstrumentor(mv, access, name, desc){

                    @Override
                    protected void onErrorReturn() {
                        switch (numActionArgs) {
                            case 0: {
                                Instrumentor.this.invokeBTraceAction(this, om);
                                break;
                            }
                            case 1: {
                                if (!TypeUtils.isThrowable(actionArgTypes[0])) break;
                                this.dup();
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                        }
                    }
                };
            }
            case FIELD_GET: {
                return new FieldAccessInstrumentor(mv, access, name, desc){
                    private String className;
                    private String fieldName;
                    {
                        super(x0, x1, x2, x3);
                        this.className = loc.getClazz();
                        this.fieldName = loc.getField();
                    }

                    @Override
                    protected void onBeforeGetField(int opcode, String owner, String name, String desc) {
                        if (where == Where.BEFORE && Instrumentor.this.matches(this.className, owner.replace('/', '.')) && Instrumentor.this.matches(this.fieldName, name)) {
                            if (opcode == 180) {
                                switch (numActionArgs) {
                                    case 0: {
                                        Instrumentor.this.invokeBTraceAction(this, om);
                                        break;
                                    }
                                    case 1: {
                                        if (!TypeUtils.isObject(actionArgTypes[0]) && !TypeUtils.isCompatible(actionArgTypes[0], Type.getObjectType(owner))) break;
                                        this.dup();
                                        Instrumentor.this.invokeBTraceAction(this, om);
                                    }
                                }
                            } else if (opcode == 178 && numActionArgs == 0) {
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                        }
                    }

                    @Override
                    protected void onAfterGetField(int opcode, String owner, String name, String desc) {
                        if (where == Where.AFTER && Instrumentor.this.matches(this.className, owner.replace('/', '.')) && Instrumentor.this.matches(this.fieldName, name)) {
                            switch (numActionArgs) {
                                case 0: {
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                    break;
                                }
                                case 1: {
                                    if (!TypeUtils.isObject(actionArgTypes[0]) && !TypeUtils.isCompatible(actionArgTypes[0], Type.getType(desc))) break;
                                    this.dupValue(desc);
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                }
                            }
                        }
                    }
                };
            }
            case FIELD_SET: {
                return new FieldAccessInstrumentor(mv, access, name, desc){
                    private String className;
                    private String fieldName;
                    private int maxLocal;
                    {
                        super(x0, x1, x2, x3);
                        this.className = loc.getClazz();
                        this.fieldName = loc.getField();
                        this.maxLocal = 0;
                    }

                    @Override
                    public void visitCode() {
                        this.maxLocal = this.getArgumentTypes().length;
                        super.visitCode();
                    }

                    @Override
                    public void visitVarInsn(int opcode, int var) {
                        if (var > this.maxLocal) {
                            this.maxLocal = var;
                        }
                        super.visitVarInsn(opcode, var);
                    }

                    @Override
                    protected void onBeforePutField(int opcode, String owner, String name, String desc) {
                        if (where == Where.BEFORE && Instrumentor.this.matches(this.className, owner.replace('/', '.')) && Instrumentor.this.matches(this.fieldName, name)) {
                            block0 : switch (numActionArgs) {
                                case 0: {
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                    break;
                                }
                                case 2: {
                                    Type fieldType = Type.getType(desc);
                                    if (!TypeUtils.isObject(actionArgTypes[0]) && !TypeUtils.isCompatible(actionArgTypes[0], Type.getObjectType(owner)) || !fieldType.equals(actionArgTypes[1])) break;
                                    switch (fieldType.getSize()) {
                                        case 1: {
                                            this.dup2();
                                            Instrumentor.this.invokeBTraceAction(this, om);
                                            break block0;
                                        }
                                        case 2: {
                                            this.storeLocal(fieldType, this.maxLocal + 1);
                                            this.dup();
                                            this.loadLocal(fieldType, this.maxLocal + 1);
                                            Instrumentor.this.invokeBTraceAction(this, om);
                                            this.loadLocal(fieldType, this.maxLocal + 1);
                                        }
                                    }
                                }
                            }
                        }
                    }

                    @Override
                    protected void onAfterPutField(int opcode, String owner, String name, String desc) {
                        if (where == Where.AFTER && Instrumentor.this.matches(this.className, owner) && Instrumentor.this.matches(this.fieldName, name) && numActionArgs == 0) {
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }
                };
            }
            case INSTANCEOF: {
                return new TypeCheckInstrumentor(mv, access, name, desc){

                    private void callAction(int opcode, String desc) {
                        if (numActionArgs == 1 && opcode == 193) {
                            this.dup();
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }

                    @Override
                    protected void onBeforeTypeCheck(int opcode, String desc) {
                        if (where == Where.BEFORE && Type.getType(desc).equals(actionArgTypes[0])) {
                            this.callAction(opcode, desc);
                        }
                    }

                    @Override
                    protected void onAfterTypeCheck(int opcode, String desc) {
                        if (where == Where.AFTER && Type.BOOLEAN_TYPE.equals(actionArgTypes[0])) {
                            this.callAction(opcode, desc);
                        }
                    }
                };
            }
            case LINE: {
                return new LineNumberInstrumentor(mv, access, name, desc){
                    private int onLine;
                    {
                        super(x0, x1, x2, x3);
                        this.onLine = loc.getLine();
                    }

                    private void callOnLine(int line) {
                        if (numActionArgs == 0) {
                            Instrumentor.this.invokeBTraceAction(this, om);
                        } else if (numActionArgs == 1 && actionArgTypes[0].equals(Type.INT_TYPE)) {
                            this.push(line);
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }

                    @Override
                    protected void onBeforeLine(int line) {
                        if ((line == this.onLine || this.onLine == -1) && where == Where.BEFORE) {
                            this.callOnLine(line);
                        }
                    }

                    @Override
                    protected void onAfterLine(int line) {
                        if ((line == this.onLine || this.onLine == -1) && where == Where.AFTER) {
                            this.callOnLine(line);
                        }
                    }
                };
            }
            case NEW: {
                return new ObjectAllocInstrumentor(mv, access, name, desc){

                    @Override
                    protected void onObjectNew(String desc) {
                        String extName = desc.replace('/', '.');
                        if (Instrumentor.this.matches(loc.getClazz(), extName)) {
                            switch (numActionArgs) {
                                case 0: {
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                    break;
                                }
                                case 1: {
                                    if (!TypeUtils.isString(actionArgTypes[0])) break;
                                    this.visitLdcInsn(extName);
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                }
                            }
                        }
                    }
                };
            }
            case NEWARRAY: {
                return new ArrayAllocInstrumentor(mv, access, name, desc){

                    @Override
                    protected void onBeforeArrayNew(String desc, int dims) {
                        if (numActionArgs == 0 && where == Where.BEFORE) {
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }

                    @Override
                    protected void onAfterArrayNew(String desc, int dims) {
                        if (where == Where.AFTER && numActionArgs == 1 && TypeUtils.isCompatible(actionArgTypes[0], Type.getType(desc))) {
                            this.dup();
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                    }
                };
            }
            case RETURN: {
                return new MethodReturnInstrumentor(mv, access, name, desc){

                    @Override
                    protected void onMethodReturn(int opcode) {
                        switch (numActionArgs) {
                            case 0: {
                                Instrumentor.this.invokeBTraceAction(this, om);
                                break;
                            }
                            case 1: {
                                Type rt = this.getReturnType();
                                if (rt.equals(Type.VOID_TYPE) || !TypeUtils.isCompatible(actionArgTypes[0], this.getReturnType())) break;
                                this.dupReturnValue(opcode);
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                        }
                    }
                };
            }
            case SYNC_ENTRY: {
                return new SynchronizedInstrumentor(this.className, mv, access, name, desc){

                    private void callAction() {
                        switch (numActionArgs) {
                            case 0: {
                                Instrumentor.this.invokeBTraceAction(this, om);
                                break;
                            }
                            case 1: {
                                if (!TypeUtils.isObjectOrAnyType(actionArgTypes[0])) break;
                                this.dup();
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                        }
                    }

                    @Override
                    protected void onBeforeSyncEntry() {
                        if (where == Where.BEFORE) {
                            this.callAction();
                        }
                    }

                    @Override
                    protected void onAfterSyncEntry() {
                        if (where == Where.AFTER) {
                            this.callAction();
                        }
                    }

                    @Override
                    protected void onBeforeSyncExit() {
                    }

                    @Override
                    protected void onAfterSyncExit() {
                    }
                };
            }
            case SYNC_EXIT: {
                return new SynchronizedInstrumentor(this.className, mv, access, name, desc){

                    private void callAction() {
                        switch (numActionArgs) {
                            case 0: {
                                Instrumentor.this.invokeBTraceAction(this, om);
                                break;
                            }
                            case 1: {
                                if (!TypeUtils.isObjectOrAnyType(actionArgTypes[0])) break;
                                this.dup();
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                        }
                    }

                    @Override
                    protected void onBeforeSyncEntry() {
                    }

                    @Override
                    protected void onAfterSyncEntry() {
                    }

                    @Override
                    protected void onBeforeSyncExit() {
                        if (where == Where.BEFORE) {
                            this.callAction();
                        }
                    }

                    @Override
                    protected void onAfterSyncExit() {
                        if (where == Where.AFTER) {
                            this.callAction();
                        }
                    }
                };
            }
            case THROW: {
                return new ThrowInstrumentor(mv, access, name, desc){

                    @Override
                    protected void onThrow() {
                        switch (numActionArgs) {
                            case 0: {
                                Instrumentor.this.invokeBTraceAction(this, om);
                                break;
                            }
                            case 1: {
                                if (!TypeUtils.isThrowable(actionArgTypes[0])) break;
                                this.dup();
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                        }
                    }
                };
            }
        }
        return mv;
    }

    @Override
    public void visitEnd() {
        int size = this.applicableOnMethods.size();
        ArrayList<MethodCopier.MethodInfo> mi = new ArrayList<MethodCopier.MethodInfo>(size);
        for (OnMethod om : this.calledOnMethods) {
            mi.add(new MethodCopier.MethodInfo(om.getTargetName(), om.getTargetDescriptor(), this.getActionMethodName(om.getTargetName()), 10));
        }
        MethodCopier copier = new MethodCopier(this.btraceClass, this.cv, mi){

            @Override
            protected MethodVisitor addMethod(int access, String name, String desc, String signature, String[] exceptions) {
                desc = desc.replace(Constants.ANYTYPE_DESC, Constants.OBJECT_DESC);
                if (signature != null) {
                    signature = signature.replace(Constants.ANYTYPE_DESC, Constants.OBJECT_DESC);
                }
                return super.addMethod(access, name, desc, signature, exceptions);
            }
        };
        copier.visitEnd();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: java com.sun.btrace.runtime.Instrumentor <btrace-class> <target-class>]");
            System.exit(1);
        }
        String className = args[0].replace('.', '/') + ".class";
        FileInputStream fis = new FileInputStream(className);
        byte[] buf = new byte[(int)new File(className).length()];
        fis.read(buf);
        fis.close();
        ClassWriter writer = InstrumentUtils.newClassWriter();
        Verifier verifier = new Verifier(new Preprocessor(writer));
        InstrumentUtils.accept(new ClassReader(buf), verifier);
        buf = writer.toByteArray();
        FileOutputStream fos = new FileOutputStream(className);
        fos.write(buf);
        fos.close();
        String targetClass = args[1].replace('.', '/') + ".class";
        fis = new FileInputStream(targetClass);
        writer = InstrumentUtils.newClassWriter();
        ClassReader reader = new ClassReader(fis);
        InstrumentUtils.accept(reader, new Instrumentor(null, verifier.getClassName(), buf, verifier.getOnMethods(), (ClassVisitor)writer));
        fos = new FileOutputStream(targetClass);
        fos.write(writer.toByteArray());
    }

    private String getActionMethodName(String name) {
        return "$btrace$" + this.btraceClassName.replace('/', '$') + "$" + name;
    }

    private void invokeBTraceAction(MethodInstrumentor mv, OnMethod om) {
        mv.invokeStatic(this.className, this.getActionMethodName(om.getTargetName()), om.getTargetDescriptor().replace(Constants.ANYTYPE_DESC, Constants.OBJECT_DESC));
        this.calledOnMethods.add(om);
    }

    private boolean matches(String pattern, String input) {
        if (pattern.length() == 0) {
            return false;
        }
        if (pattern.charAt(0) == '/' && Constants.REGEX_SPECIFIER.matcher(pattern).matches()) {
            return input.matches(pattern.substring(1, pattern.length() - 1));
        }
        return pattern.equals(input);
    }

    private boolean typeMatches(String decl, String desc) {
        if (decl.isEmpty()) {
            return true;
        }
        String d = TypeUtils.declarationToDescriptor(decl);
        Type[] args1 = Type.getArgumentTypes(d);
        Type[] args2 = Type.getArgumentTypes(desc);
        return TypeUtils.isCompatible(args1, args2);
    }

    private static boolean isInArray(String[] candidates, String given) {
        for (String c : candidates) {
            if (!c.equals(given)) continue;
            return true;
        }
        return false;
    }
}

