/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.aggregation;

import java.io.PrintWriter;
import java.io.Serializable;

public class HistogramData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] values;
    private int[] counts;

    public HistogramData(int[] values, int[] counts) {
        if (values.length != counts.length) {
            throw new IllegalArgumentException("values and counts are different lengths");
        }
        this.values = values;
        this.counts = counts;
    }

    public int[] getValues() {
        return this.values;
    }

    public int[] getCounts() {
        return this.counts;
    }

    public void print(PrintWriter p) {
        int i;
        int totalCount = 0;
        for (i = 0; i < this.counts.length; ++i) {
            totalCount += this.counts[i];
        }
        p.println("          value  ------------- Distribution ------------- count");
        for (i = 0; i < this.values.length; ++i) {
            p.print(String.format("%15d", this.values[i]));
            p.print(" |");
            int lineLength = 40 * this.counts[i] / totalCount;
            for (int j = 0; j < 40; ++j) {
                p.print(j < lineLength ? "@" : " ");
            }
            p.print(" ");
            p.println(this.counts[i]);
        }
    }
}

