/*
Wrapper of operation part in xoper/xloper12.
xlVar and xlRange is twins.
A class which operates as Excel's values like an Excel's Variant.
*/

#pragma once

#define XL_OPERATOR_IMPL(OP)   xlVar tmp; m_excel12 ? OP<xloper12, XLPROC12>(&src, &tmp) : OP<xloper4, XLPROC4>(&src, &tmp); return tmp;
#define XL_OPERATOR_IMPL_V(OP) xlVar tmp; m_excel12 ? OP<xloper12, XLPROC12>(&xlVar(src), &tmp) : OP<xloper, XLPROC4>(&xlVar(src), &tmp); return tmp;

#define asArgFromXL xlbitXLFree
#define asResToXL   xlbitDLLFree

namespace xl{

	/////////////// xlVar: wrapper class of XLOPER/XLOPER12 /////////////////	
	/////////////// And the variant class for Excel         /////////////////
	class xlRange;
	class xlVar : public xlBase{ 
		friend class xlAPI;
		friend class xlRange;
		friend class xlFunc;

	public:
		// constructors
		xlVar(){XL_CALL_FUNC_0(f_createDefault);}// default constructor
		xlVar(void* op, int bitFree = 0){ m_excel12 ? f_createVoidPtr12(op,bitFree) : f_createVoidPtr4(op, bitFree);}
		xlVar(const double val){ m_excel12 ? f_createDouble<xloper12>(val) : f_createDouble<xloper4>(val);}
		xlVar(const int val){ m_excel12 ? f_createInt<xloper12>(val) : f_createInt<xloper4>(val);}
		xlVar(const bool val){ m_excel12 ? f_createBool<xloper12>(val) : f_createBool<xloper4>(val);}
		xlVar(const char* c){ m_excel12 ? f_createCharW(c) : f_createChar(c); }
		xlVar(const wchar_t* c){ m_excel12 ? f_createCharW(c) : f_createChar(c); }
		xlVar(const std::string str){ m_excel12 ? f_createStringW(str) : f_createString(str); }
		xlVar(const std::wstring str){ m_excel12 ? f_createStringW(str) : f_createString(str); }
		xlVar(const int rows, const int cols){ m_excel12 ? f_createArray<xloper12>(rows, cols) : f_createArray<xloper4>(rows, cols); }

		// copy constructor
		xlVar(const xlVar& from){ 
			m_excel12 ? f_copyThis12(&from) : f_copyThis4(&from);
		}

		// destructor
		~xlVar(){ 
			*m_refcount > 0 ? *m_refcount -= 1 : XL_CALL_FUNC_0(f_deleteSubstance);
		}

		// properties
		Property(double, Num);
		Property(int, Int);
		Property(bool,Bool);
		Property(int, Err);
		Property(std::string, String);
		Property(std::wstring, WString);
		PrReader(xlVar, First);

		// property implements
		double getNum(){return XL_CALL_FUNC_0(f_getNum);}
		void putNum(double val){ m_excel12 ? f_putNum<xloper12>(val) : f_putNum<xloper4>(val);}

		int getInt(){return XL_CALL_FUNC_0(f_getInt);}
		void putInt(int val){ m_excel12 ? f_putInt<xloper12>(val) : f_putInt<xloper4>(val);}

		bool getBool(){return XL_CALL_FUNC_0(f_getBool);}
		void putBool(bool val){ m_excel12 ? f_putBool<xloper12>(val) : f_putBool<xloper4>(val);}

		int getErr(){return XL_CALL_FUNC_0(f_getErr);}
		void putErr(int val){ m_excel12 ? f_putErr<xloper12>(val) : f_putErr<xloper4>(val);}

		std::string getString(){ return m_excel12 ? f_getString12() : f_getString4();}
		void putString(std::string str){ m_excel12 ? f_putString12(str) : f_putString4(str);}

		std::wstring getWString(){ return m_excel12 ? f_getWString12() : f_getWString4();}
		void putWString(std::wstring str){ m_excel12 ? f_putWString12(str) : f_putWString4(str);}

		xlVar getFirst(){ return m_excel12 ? f_getFirst<xloper12>() : f_getFirst<xloper4>();}

		//operators
		void operator =(const xlVar& src){ m_excel12 ? f_asignOper12(&src) : f_asignOper4(&src);}
		void operator =(const double src){ putNum(src); }
		void operator =(const int src){ putInt(src);}
		void operator =(const bool src){ putBool(src);}
		void operator =(const char* src){ putString(src);}
		void operator =(const std::string src){ putString(src);}
		void operator =(const wchar_t* src){ putWString(src);}
		void operator =(const std::wstring src){ putWString(src);}

		void operator +=(const xlVar& src){ m_excel12 ? f_incOper12(&src): f_incOper4(&src); }
		void operator +=(const double src){ m_excel12 ? f_incOper12(&xlVar(src)): f_incOper4(&xlVar(src));}
		void operator +=(const char* src){ m_excel12 ? f_incOper12(&xlVar(src)): f_incOper4(&xlVar(src));}
		void operator +=(const std::string src){ m_excel12 ? f_incOper12(&xlVar(src)): f_incOper4(&xlVar(src));}
		void operator +=(const wchar_t* src){ m_excel12 ? f_incOper12(&xlVar(src)): f_incOper4(&xlVar(src));}
		void operator +=(const std::wstring src){ m_excel12 ? f_incOper12(&xlVar(src)): f_incOper4(&xlVar(src));}

		void operator -=(const xlVar& src){ XL_CALL_FUNC_1(f_decOper, &src); }
		void operator -=(const double src){ XL_CALL_FUNC_1(f_decOper, &xlVar(src)); }
		void operator -=(const char* src){ XL_CALL_FUNC_1(f_decOper, &xlVar(src)); }
		void operator -=(const std::string src){ XL_CALL_FUNC_1(f_decOper, &xlVar(src)); }
		void operator -=(const wchar_t* src){ XL_CALL_FUNC_1(f_decOper, &xlVar(src)); }
		void operator -=(const std::wstring src){ XL_CALL_FUNC_1(f_decOper, &xlVar(src)); }

		xlVar operator +(const xlVar& src){ xlVar tmp; m_excel12 ? f_addOper12(&src, &tmp): f_addOper4(&src, &tmp); return tmp;}
		xlVar operator +(const double src){ xlVar tmp; m_excel12 ? f_addOper12(&xlVar(src), &tmp): f_addOper4(&xlVar(src), &tmp); return tmp;}
		xlVar operator +(const char* src){ xlVar tmp; m_excel12 ? f_addOper12(&xlVar(src), &tmp): f_addOper4(&xlVar(src), &tmp); return tmp;}
		xlVar operator +(const std::string src){ xlVar tmp; m_excel12 ? f_addOper12(&xlVar(src), &tmp): f_addOper4(&xlVar(src), &tmp); return tmp;}
		xlVar operator +(const wchar_t* src){ xlVar tmp; m_excel12 ? f_addOper12(&xlVar(src), &tmp): f_addOper4(&xlVar(src), &tmp); return tmp;}
		xlVar operator +(const std::wstring src){ xlVar tmp; m_excel12 ? f_addOper12(&xlVar(src), &tmp): f_addOper4(&xlVar(src), &tmp); return tmp;}

		xlVar operator -(const xlVar& src){ XL_OPERATOR_IMPL(f_subOper) }
		xlVar operator -(const double src){ XL_OPERATOR_IMPL_V(f_subOper) }
		xlVar operator -(const char* src){ XL_OPERATOR_IMPL_V(f_subOper) }
		xlVar operator -(const std::string src){ XL_OPERATOR_IMPL_V(f_subOper) }
		xlVar operator -(const wchar_t* src){ XL_OPERATOR_IMPL_V(f_subOper) }
		xlVar operator -(const std::wstring src){ XL_OPERATOR_IMPL_V(f_subOper) }

		xlVar operator *(const xlVar& src){ XL_OPERATOR_IMPL(f_mulOper) }
		xlVar operator *(const double src){ XL_OPERATOR_IMPL_V(f_mulOper) }
		xlVar operator *(const char* src){ XL_OPERATOR_IMPL_V(f_mulOper) }
		xlVar operator *(const std::string src){ XL_OPERATOR_IMPL_V(f_mulOper) }
		xlVar operator *(const wchar_t* src){ XL_OPERATOR_IMPL_V(f_mulOper) }
		xlVar operator *(const std::wstring src){ XL_OPERATOR_IMPL_V(f_mulOper) }

		xlVar operator /(const xlVar& src){ XL_OPERATOR_IMPL(f_divOper) }
		xlVar operator /(const double src){ XL_OPERATOR_IMPL_V(f_divOper) }
		xlVar operator /(const char* src){ XL_OPERATOR_IMPL_V(f_divOper) }
		xlVar operator /(const std::string src){ XL_OPERATOR_IMPL_V(f_divOper) }
		xlVar operator /(const wchar_t* src){ XL_OPERATOR_IMPL_V(f_divOper) }
		xlVar operator /(const std::wstring src){ XL_OPERATOR_IMPL_V(f_divOper) }

		bool  operator ==(const xlVar src){return m_excel12 ? f_eqlOper12(&src) : f_eqlOper4(&src);}
		bool  operator ==(const double src){return m_excel12 ? f_eqlOper12(&xlVar(src)) : f_eqlOper4(&xlVar(src));}
		bool  operator ==(const char* src){return m_excel12 ? f_eqlOper12(&xlVar(src)) : f_eqlOper4(&xlVar(src));}
		bool  operator ==(const std::string src){return m_excel12 ? f_eqlOper12(&xlVar(src)) : f_eqlOper4(&xlVar(src));}
		bool  operator ==(const wchar_t* src){return m_excel12 ? f_eqlOper12(&xlVar(src)) : f_eqlOper4(&xlVar(src));}
		bool  operator ==(const std::wstring src){return m_excel12 ? f_eqlOper12(&xlVar(src)) : f_eqlOper4(&xlVar(src));}

		bool  operator !=(const xlVar src){return !(m_excel12 ? f_eqlOper12(&src) : f_eqlOper4(&src));}
		bool  operator !=(const double src){return !(m_excel12 ? f_eqlOper12(&xlVar(src)) : f_eqlOper4(&xlVar(src)));}
		bool  operator !=(const char* src){return !(m_excel12 ? f_eqlOper12(&xlVar(src)) : f_eqlOper4(&xlVar(src)));}
		bool  operator !=(const std::string src){return !(m_excel12 ? f_eqlOper12(&xlVar(src)) : f_eqlOper4(&xlVar(src)));}
		bool  operator !=(const wchar_t* src){return !(m_excel12 ? f_eqlOper12(&xlVar(src)) : f_eqlOper4(&xlVar(src)));}
		bool  operator !=(const std::wstring src){return !(m_excel12 ? f_eqlOper12(&xlVar(src)) : f_eqlOper4(&xlVar(src)));}

		xlVar operator [](const int idx){
			return xlVar(m_excel12 ? f_idxOper<xloper12>(idx) : f_idxOper<xloper4>(idx), F_KEEP_VAL);
		}

		// public methods

		bool IsError(){return getXlType() == xltypeErr;}
		xlVar Array(const int rows, const int cols){
			m_excel12 ? f_putArray<xloper12>(rows, cols) : f_putArray<xloper4>(rows, cols);
		}
		int CountRows(){return m_excel12 ? f_countRows<xloper12>() : f_countRows<xloper4>();}
		int CountCols(){return m_excel12 ? f_countCols<xloper12>() : f_countCols<xloper4>();}

		xloper12* getOper12(){ return m_xloper12; }
		xloper4* getOper4(){ return m_xloper4; }

		void AsArgFromXL(){ return m_excel12 ? f_setArgFrom<xloper12>() : f_setArgFrom<xloper4>(); }
		void* AsResToXL(){return m_excel12 ? f_setResTo<xloper12>() : f_setResTo<xloper4>(); }

		// static methods
		static xlVar NewArray(const char* sTemplate, ...){
			std::string cTemplate = s_parseArgs(sTemplate);
			int cLen = cTemplate.length();
			xlVar var(1, cLen);
			va_list pArg;
			va_start(pArg, sTemplate);
			for(int i=0; i < cLen; i++){
				switch (cTemplate[i]){
					case 'C':
						var[i] = va_arg(pArg, char*);
						break;
					case 'N':
						var[i] = va_arg(pArg, double);
						break;
					case 'V':
						var[i] = va_arg(pArg, xlVar);
						break;
					case 'W':
						var[i] = va_arg(pArg, wchar_t*);
						break;
					default:
						;
				}
			}
			return var;
		}

		static xlVar NewErr(const int err_num){
			xlVar e;
			e.Err = err_num;
			return e;
		}

	private:

		// static methods
		static std::string s_parseArgs(const char* sTemplate){
			int nLen = strlen(sTemplate);
			std::string nStr = "";
			std::string tStr = "";
			int prev_was_number = 0;
			int cLen = 0;
			for(int i=0; i< nLen; i++){
				char c = sTemplate[i];
				int len = 0;
				if('0' <= c  && c <= '9'){
					nStr += c;
					prev_was_number = 1;
					if(i == nLen - 1){
						len = strtol(nStr.c_str(), 0, 10) - 1;
						char c0 = tStr[tStr.length() - 1];
						while(len-- > 0){tStr += c0; };
					}
				}else{
					if(prev_was_number){
						len = strtol(nStr.c_str(), 0, 10) - 1;
						char c0 = tStr[tStr.length() - 1];
						while(len-- > 0){tStr += c0; };
						prev_was_number = 0;
					}else{
						tStr += c;
					}
				}
			}
			return tStr;
		}

	// constructors	
		template <class P> void f_createDouble(const double val){
			f_setSubstance<P>();
			f_setDouble<P>(val);
		}

		template <class P> void f_createInt(const int val){
			f_setSubstance<P>();
			f_setInt<P>(val);
		}

		template <class P> void f_createBool(const bool val){
			f_setSubstance<P>();
			f_setBool<P>(val);
		}

		void f_createChar(const char* c){
			f_setSubstance<xloper4>();
			f_setChar(c);
		}

		void f_createChar(const wchar_t* c){
			f_setSubstance<xloper4>();
			f_setChar(c);
		}

		void f_createCharW(const char* c){
			f_setSubstance<xloper12>();
			f_setCharW(c);
		}

		void f_createCharW(const wchar_t* c){
			f_setSubstance<xloper12>();
			f_setCharW(c);
		}

		void f_createString(const std::string str){
			f_setSubstance<xloper4>();
			f_setString(str);
		}

		void f_createString(const std::wstring str){
			f_setSubstance<xloper4>();
			f_setString(str);
		}

		void f_createStringW(const std::string str){
			f_setSubstance<xloper12>();
			f_setStringW(str);
		}

		void f_createStringW(const std::wstring str){
			f_setSubstance<xloper12>();
			f_setStringW(str);
		}

		template <class P> void f_createArray(const int rows, const int cols){
			f_setSubstance<P>();
			f_setArray<P>(rows, cols);
		}

	// public implements
		template <class P> int f_countRows(){
			if(((P*)m_xloper)->xltype != xltypeMulti) return 0;
			return ((P*)m_xloper)->val.array.rows;
		}

		template <class P> int f_countCols(){
			if(((P*)m_xloper)->xltype != xltypeMulti) return 0;
			return ((P*)m_xloper)->val.array.columns;
		}

	// property imprements
		template <class P, class F> double f_getNum(){
			if (((P*)m_xloper)->xltype != xltypeNum){
				double num; P op;
				f_coerce<P, F>(&op, (P*)m_xloper, xltypeNum);
				num = op.val.num;
				f_xlfree<P, F>(&op);
				return num;
			}
			return ((P*)m_xloper)->val.num;
		}

		template <class P> void f_putNum(const double val){
			if(f_deleteVal<P>((P*)m_xloper, *m_refcount)) f_setDouble<P>(val);
		}

		template <class P, class F> int f_getInt(){
			if (((P*)m_xloper)->xltype != xltypeInt){
				int num; P op;
				f_coerce<P, F>(&op, (P*)m_xloper, xltypeInt);
				num = op.val.w;
				f_xlfree<P, F>(&op);
				return num;
			}
			return (int)(((P*)m_xloper)->val.num);
		}

		template <class P> void f_putInt(const int val){
			if(f_deleteVal<P>((P*)m_xloper, *m_refcount)) f_setInt<P>(val);
		}

		template <class P, class F> bool f_getBool(){
			if (((P*)m_xloper)->xltype != xltypeBool){
				bool val; P op;
				f_coerce<P, F>(&op, (P*)m_xloper, xltypeBool);
				val = op.val.xbool ? true : false;
				f_xlfree<P, F>(&op);
				return val;
			}
			return ((P*)m_xloper)->val.xbool ? true : false;
		}

		template <class P> void f_putBool(const bool val){
			if(f_deleteVal<P>((P*)m_xloper, *m_refcount)) f_setBool<P>(val);
		}


		template <class P, class F> int f_getErr(){
			if(((P*)m_xloper)->xltype != xltypeErr) return 0;
			return ((P*)m_xloper)->val.err;
		}

		template <class P> void f_putErr(const int val){
			if(f_deleteVal<P>((P*)m_xloper, *m_refcount)) f_setErr<P>(val);
		}

		std::string f_getString4(){
			int len = m_xloper4->val.str[0];
			char* chr = new char[len+1];
			chr[len] = 0;
			memcpy_s(chr, len, m_xloper4->val.str+1, len); 
			std::string str = chr;
			delete [] chr;
			return str;
		}

		std::string f_getString12(){
			std::string str;
			std::wstring wstr = m_xloper12->val.str; 
			int len = (WORD)wstr[0];
			narrow(wstr.substr(1,len), str);
			return str;
		}

		void f_putString4(const std::string str){
			if(f_deleteVal<xloper4>(m_xloper4, *m_refcount)) f_setString(str);
		}

		void f_putString12(const std::string str){
			if(f_deleteVal<xloper12>(m_xloper12, *m_refcount)) f_setStringW(str);
		}

		std::wstring f_getWString4(){ // Thanks for koza San.
			int len = MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, m_xloper4->val.str+1, m_xloper4->val.str[0], 0, 0);
			wchar_t* wcs = new wchar_t[len + 1];
			MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED,  m_xloper4->val.str+1, m_xloper4->val.str[0], wcs, len);
			wcs[len] = L'\0';
			std::wstring str(wcs);
			delete [] wcs;
			return str;
		}

		std::wstring f_getWString12(){ // Thanks for koza San.
			int len = m_xloper12->val.str[0];
			wchar_t* chr = new wchar_t[len*2+1];
			chr[len] = 0;
			memcpy_s(chr, len*2, m_xloper12->val.str+1, len*2); 
			std::wstring str(chr);
			delete [] chr;
			return str;
		}

		void f_putWString4(const std::wstring str){
			if(f_deleteVal<xloper4>(m_xloper4, *m_refcount)) f_setString(str);
		}

		void f_putWString12(const std::wstring str){
			if(f_deleteVal<xloper12>(m_xloper12, *m_refcount)) f_setStringW(str);
		}

		template <class P> xlVar f_getFirst(){
			if(((P*)m_xloper)->xltype != xltypeMulti) return *this;
			if(f_countRows<P>() == 1) return (*this)[0];
			else return (*this)[0][0];
		}

	// operator implements
		template <class P, class F> int f_checkValue(const xlVar* src, P* res){
			if ((((P*)m_xloper)->xltype & 0xfff) == ((((P*)(src->m_xloper))->xltype) & 0xfff)) return 1;
			f_coerce<P, F>(res,(P*)(src->m_xloper),((P*)m_xloper)->xltype);
			return 0;
		}

		void f_asignOper4(const xlVar* src){
			if(*m_refcount == F_KEEP_VAL){                // 'this' is a part of array
				if(m_xloper4->xltype == xltypeMulti){
					if(src->m_xloper4->xltype != xltypeMulti){
						DebugP("This operation needs array but asignment source is not array!");
						return;
					}
					int m = src->m_xloper4->val.array.columns;
					int n = m_xloper4->val.array.columns;
					if (n > m) n = m;
					for(int i=0; i<n; i++){
						f_clone4(&m_xloper4->val.array.lparray[i], &src->m_xloper4->val.array.lparray[i]);
					}
				}else{
					f_clone4(m_xloper4, src->m_xloper4);
				}
			}else if(*(src->m_refcount) < 0){ // source is a part of array or a return from API call.
				f_clone4(m_xloper4, src->m_xloper4);
			//}else if(*(src->m_refcount) == F_KEEP_VAL){
			//	f_clone4(m_xloper4, src->m_xloper4);
			}else{
				*(src->m_refcount)>0 ? *m_refcount -= 1 : f_deleteSubstance<xloper4, XLPROC4>();
				m_refcount = src->m_refcount;
				*m_refcount += 1;
				m_xloper4 = src->m_xloper4;
			}
		}

		 void f_asignOper12(const xlVar* src){
			if(*m_refcount == F_KEEP_VAL){                // 'this' is a part of array
				if(m_xloper12->xltype == xltypeMulti){
					if(src->m_xloper12->xltype != xltypeMulti){
						DebugP("This operation needs array but asignment source is not array!");
						return;
					}
					int m = src->m_xloper12->val.array.columns;
					int n = m_xloper12->val.array.columns;
					if (n > m) n = m;
					for(int i=0; i<n; i++){
						f_clone12(&m_xloper12->val.array.lparray[i], &src->m_xloper12->val.array.lparray[i]);
					}
				}else{
					f_clone12(m_xloper12, src->m_xloper12);
				}
			}else if(*(src->m_refcount) < 0){ // source is a part of array or a return from API call.
				f_clone12(m_xloper12, src->m_xloper12);
			//}else if(*(src->m_refcount) == F_KEEP_VAL){
			//	f_clone12(m_xloper12, src->m_xloper12);
			}else{
				*(src->m_refcount)>0 ? *m_refcount -= 1 : f_deleteSubstance<xloper12, XLPROC12>();
				m_refcount = src->m_refcount;
				*m_refcount += 1;
				m_xloper12 = src->m_xloper12;
			}
		}

		void f_addOper4(const xlVar* src, xlVar* dest){
			xloper4 res;
			if(f_checkValue<xloper4, XLPROC4>(src, &res)) f_addOp4(m_xloper4, src->m_xloper4, dest->m_xloper4);
			else f_addOp4(m_xloper4, &res, dest->m_xloper4);
		}

		void f_addOper12(const xlVar* src, xlVar* dest){
			xloper12 res;
			if(f_checkValue<xloper12, XLPROC12>(src, &res)) f_addOp12(m_xloper12, src->m_xloper12, dest->m_xloper12);
			else f_addOp12(m_xloper12, &res, dest->m_xloper12);
		}

		template <class P, class F> void f_subOper(const xlVar* src, xlVar* dest){	
			P res;
			if(f_checkValue<P, F>(src, &res)) f_subOp<P>((P*)m_xloper, (P*)(src->m_xloper), (P*)(dest->m_xloper));
			else f_subOp<P>((P*)m_xloper, &res, (P*)(dest->m_xloper));
		}

		template <class P, class F> void f_mulOper(const xlVar* src, xlVar* dest){
			P res;
			if(f_checkValue<P, F>(src, &res)) f_mulOp<P>((P*)m_xloper, (P*)(src->m_xloper), (P*)(dest->m_xloper));
			else f_mulOp<P>((P*)m_xloper, &res, (P*)(dest->m_xloper));
		}

		template <class P, class F> void f_divOper(const xlVar* src, xlVar* dest){
			P res;
			if(f_checkValue<P, F>(src, &res)) f_divOp<P>((P*)m_xloper, (P*)(src->m_xloper), (P*)(dest->m_xloper));
			else f_divOp<P>((P*)m_xloper, &res, (P*)(dest->m_xloper));
		}

		void f_incOper4(const xlVar* src){
			xloper4 res;
			if(f_checkValue<xloper4, XLPROC4>(src, &res)) f_incOp4(m_xloper4, src->m_xloper4);
			else f_incOp4(m_xloper4, &res);
		}

		void f_incOper12(const xlVar* src){
			xloper12 res;
			if(f_checkValue<xloper12, XLPROC12>(src, &res)) f_incOp12(m_xloper12, src->m_xloper12);
			else f_incOp12(m_xloper12, &res);
		}
		
		template <class P, class F> void f_decOper(const xlVar* src){			
			P res;
			if(f_checkValue<P, F>(src, &res)) f_decOp<P>((P*)m_xloper, (P*)(src->m_xloper));
			else f_decOp<P>((P*)m_xloper, &res);
		}

		bool f_eqlOper4(const xlVar* src){
			if ((m_xloper4 ->xltype & 0xfff) != (src->m_xloper4->xltype & 0xfff)) return false;
			if (m_xloper4->xltype & xltypeNum) return m_xloper4->val.num == src->m_xloper4->val.num;
			else if (m_xloper4->xltype & xltypeStr) 
				return memcmp(m_xloper4->val.str, src->m_xloper4->val.str, (size_t)(m_xloper4->val.str[0])+1) == 0;
			else return false;
		}

		bool f_eqlOper12(const xlVar* src){
			if ((m_xloper12->xltype & 0xfff) != (src->m_xloper12->xltype & 0xfff)) return false;
			if (m_xloper12->xltype & xltypeNum) return m_xloper12->val.num == src->m_xloper12->val.num;
			else if (m_xloper12->xltype & xltypeStr) 
				return memcmp(m_xloper12->val.str, src->m_xloper12->val.str, ((size_t)(m_xloper12->val.str[0])+1)*2) == 0;
			else return false;
		}

		template <class P> void* f_idxOper(const int idx){
			if(((P*)m_xloper)->xltype != xltypeMulti) return 0; 
			if (((P*)m_xloper)->val.array.rows == 1){ // return single xlVar
				return &(((P*)m_xloper)->val.array.lparray[idx]);
			}else{ // return offset of array which keeps substance.
				P* val = new P;
				val->xltype = xltypeMulti;
				val->val.array.rows = 1;
				int col = ((P*)m_xloper)->val.array.columns;
				val->val.array.columns = col;
				val->val.array.lparray = ((P*)m_xloper)->val.array.lparray + col * idx;
				return val;
			}
		}

		template <class P> void f_putArray(const int rows, const int cols){
			f_deleteVal<P>((P*)m_xloper);
			f_setArray<P>(rows, cols);
		} 

		// utilities
		void narrow(const std::wstring &src, std::string &dest) {
			int len = WideCharToMultiByte(CP_ACP, 0, src.c_str(), -1, 0, 0, 0, 0);
			char *mbs = new char[len];
			WideCharToMultiByte(CP_ACP, 0, src.c_str(), -1, mbs, len, 0, 0);
			dest = mbs;
			delete [] mbs;
		}

		void widen(const std::string &src, std::wstring &dest) {
			wchar_t *wcs = new wchar_t[src.length() + 1];
			MultiByteToWideChar(CP_ACP, 0, src.c_str(), src.length() + 1,wcs, src.length() + 1);
			dest = wcs;
			delete [] wcs;
		}

		//template <class P, class F> std::wstring getWString(xlVar* oper){return 0;}
		//template <class P, class F> void setWString(const std::wstring){}

		template <class P> void f_setArgFrom(){
			((P*)m_xloper)->xltype |= xlbitXLFree;
		}

		template <class P> void* f_setResTo(){
			if(!(((P*)m_xloper)->xltype & xlbitXLFree )) 
				((P*)m_xloper)->xltype |= xlbitDLLFree;
			return m_xloper;
		};


	// internal methods
		template <class P> void f_setDouble(const double val){
			((P*)m_xloper)->xltype = xltypeNum;
			((P*)m_xloper)->val.num = (double)val;
		}

		template <class P> void f_setInt(const int val){
			((P*)m_xloper)->xltype = xltypeInt;
			((P*)m_xloper)->val.w = val;
		}

		template <class P> void f_setBool(const bool val){
			((P*)m_xloper)->xltype = xltypeBool;
			((P*)m_xloper)->val.xbool = val;
		}

		template <class P> void f_setErr(const int val){
			((P*)m_xloper)->xltype = xltypeErr;
			((P*)m_xloper)->val.err = val;
		}

		void f_setChar(const char* chr){
			m_xloper4->xltype = xltypeStr;
			int len = strlen(chr);
			char* str = new char[len+1];
			str[0] = (BYTE)len;
			memcpy_s(str+1, len+1, chr, len); 
			m_xloper4->val.str = str;
		}

		void f_setChar(const wchar_t* chr){  // Thanks for koza San.
			int len = WideCharToMultiByte(CP_ACP, 0, chr, -1, 0, 0, 0, 0);
			char *mbs = new char[len];
			WideCharToMultiByte(CP_ACP, 0, chr, -1, mbs+1, len-1, 0, 0);
			m_xloper4->xltype = xltypeStr;
			mbs[0] = (char)len-1;
			m_xloper4->val.str = mbs;
		}


		void f_setCharW(const char* chr){
			m_xloper12->xltype = xltypeStr;
			int len = MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, chr, -1, 0, 0);
			wchar_t* wcs = new wchar_t[len];
			MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, chr,-1, wcs+1, len-1);
			wcs[0] = (WORD)len-1;
			m_xloper12->val.str = wcs;
		}

		void f_setCharW(const wchar_t* chr){ // Thanks for koza San.
			m_xloper12->xltype = xltypeStr;
			size_t len = wcslen(chr);
			wchar_t* str = new wchar_t[len+1];
			str[0] = (wchar_t)len;
			memcpy_s(str+1, len*2, chr, len*2); 
			m_xloper12->val.str = str;
		}

		void f_setString(const std::string str){
			f_setChar(str.c_str());
		}

		void f_setString(const std::wstring str){
			f_setChar(str.c_str());
		}

		void f_setStringW(const std::string str){
			f_setCharW(str.c_str());
		}

		void f_setStringW(const std::wstring str){
			f_setCharW(str.c_str());
		}

		template <class P> void f_setArray(const int rows, const int cols){
			((P*)m_xloper)->xltype = xltypeMulti;
			((P*)m_xloper)->val.array.rows = rows;
			((P*)m_xloper)->val.array.columns = cols;
			int n = rows * cols;
			((P*)m_xloper)->val.array.lparray = new P[n];
		}

	// operator implements

		void f_addOp12(const xloper12* op, const xloper12* src, xloper12* dest){
			int typ = op->xltype;
			dest->xltype = typ;
			if(typ == xltypeNum){
				dest->val.num = op->val.num + src->val.num;
			}else if(typ==xltypeStr){
				int l1 = (WORD)op->val.str[0];
				int l2 = (WORD)src->val.str[0];
				wchar_t* chr = new wchar_t[l1 + l2 + 1];
				memcpy_s(chr + 1, l1*2, op->val.str + 1, l1*2);
				memcpy_s(chr + l1 + 1, l2*2, src->val.str + 1, l2*2);
				chr[0] = (WORD)(l1 + l2);
				dest->val.str = chr;
			}
		}

		void f_addOp4(const xloper* op, const xloper* src, xloper* dest){
			int typ = op->xltype;
			dest->xltype = typ;
			if(typ == xltypeNum){
				dest->val.num = op->val.num + src->val.num;
			}else if(typ==xltypeStr){
				int l1 = (BYTE)op->val.str[0];
				int l2 = (BYTE)src->val.str[0];
				dest->val.str = new char[l1 + l2 +1];
				memcpy_s(dest->val.str + 1, l1, op->val.str + 1, l1);
				memcpy_s(dest->val.str + l1 + 1, l2, src->val.str + 1, l2);
				dest->val.str[0] = BYTE(l1 + l2);
			}
		}

		template <class P> void f_subOp(const P* oper, const P* src, P* dest){
			int typ = oper->xltype;
			dest->xltype = typ;
			if(typ == xltypeNum){
				dest->val.num = oper->val.num - src->val.num;
			}
		}

		template <class P> void f_mulOp(const P* oper, const P* src, P* dest){
			int typ = oper->xltype;
			dest->xltype = typ;
			if(typ == xltypeNum){
				dest->val.num = oper->val.num * src->val.num;
			}
		}

		template <class P> void f_divOp(const P* oper, const P* src, P* dest){
			int typ = oper->xltype;
			dest->xltype = typ;
			if(typ == xltypeNum){
				dest->val.num = oper->val.num / src->val.num;
			}
		}

		void f_incOp4(xloper* oper, const xloper* src){
			int typ = oper->xltype;
			if(typ == xltypeNum){
				oper->val.num = oper->val.num + src->val.num;
			}else if(typ==xltypeStr){
				int l1 = (BYTE)oper->val.str[0];
				int l2 = (BYTE)src->val.str[0];
				char* chr = new char[l1 + l2 +1];
				memcpy_s(chr + 1, l1, oper->val.str + 1, l1);
				memcpy_s(chr + l1 + 1, l2, src->val.str + 1, l2);
				chr[0] = BYTE(l1 + l2);
				delete [] oper->val.str;
				oper->val.str = chr;
			}
		}

		void f_incOp12(xloper12* oper, const xloper12* src){
			int typ = oper->xltype;
			if(typ == xltypeNum){
				oper->val.num = oper->val.num + src->val.num;
			}else if(typ==xltypeStr){
				int l1 = (WORD)oper->val.str[0];
				int l2 = (WORD)src->val.str[0];
				wchar_t* chr = new wchar_t[l1 + l2 +1];
				memcpy_s(chr + 1, l1*2, oper->val.str + 1, l1*2);
				memcpy_s(chr + l1 + 1, l2*2, src->val.str + 1, l2*2);
				chr[0] = WORD(l1 + l2);
				delete [] oper->val.str;
				oper->val.str = chr;
			}
		}

		template <class P> void f_decOp(P* oper, const P* src){
			int typ = oper->xltype;
			if(typ == xltypeNum){
				oper->val.num = oper->val.num - src->val.num;
			}
		}

	};

}

