// AXL3 - An XLL Library
// Wrapper class library for Microsft Excel's xll add-in which written by C++.
//
// Copyright(c) 2009-2009, yukimi_sake@users.sourceforge.jp. All rights reserved.

#pragma once

#include <vector>

namespace xl{
	class xlFunc{
	private:
		xlVar XlGetName(){
			xlVar pret;
			API.Call(xlGetName, &pret, 0);
			return pret;
		}

	protected:
		std::string m_procedure;
		std::string m_typeText;     
		std::string m_functionText;
		std::string m_argumentText; 
		int m_macroType;
		std::string m_category;     
		std::string m_shortcutText;
		std::string m_helpTopic;    
		std::string m_functionHelp;
		std::vector<std::string> m_argumentHelps;

	public:
	// constructors
		xlFunc(){};

		xlFunc(
				const char* tProc,
				const char* tFunc,
				const char* tType,
				const char* tArg = "",
				const int	iMtype = 1,
				const char* tCategory = "",
				const char* tShortCut = "",
				const char* tHelpTopic = "",
				const char* tFuncHelp = ""
			){
			m_procedure = tProc;
			m_typeText = tType;
			m_functionText = tFunc;
			m_argumentText = tArg; 
			m_macroType = iMtype;
			m_category = tCategory;     
			m_shortcutText = tShortCut;
			m_helpTopic = tHelpTopic;    
			m_functionHelp = tFuncHelp;
		}
	// destructor
		~xlFunc(){
		}

		xlFunc AddFuncHelp(const char* hlp){
			m_argumentHelps.push_back(hlp);
			return *this;
		}

		xlFunc AddFuncHelp(const char* hlp1, const char* hlp2){
			m_argumentHelps.push_back(hlp1);
			m_argumentHelps.push_back(hlp2);
			return *this;
		}

		xlFunc AddFuncHelp(const char* hlp1, const char* hlp2, const char* hlp3){
			m_argumentHelps.push_back(hlp1);
			m_argumentHelps.push_back(hlp2);
			m_argumentHelps.push_back(hlp3);
			return *this;
		}

		xlFunc AddFuncHelp(const char* hlp1, const char* hlp2, const char* hlp3, const char* hlp4){
			m_argumentHelps.push_back(hlp1);
			m_argumentHelps.push_back(hlp2);
			m_argumentHelps.push_back(hlp3);
			m_argumentHelps.push_back(hlp4);
			return *this;
		}

		xlFunc AddFuncHelp(int count, ...){
			va_list ap;
			va_start(ap, count);
			for(int i=0; i < count; i++){
				std::string tHlp = va_arg(ap, char*);
				m_argumentHelps.push_back(tHlp);
			}
			va_end(ap);
			return *this;
		}

		int Register(){
			xlVar* args[30];
			xlVar pret;
			API.Call(xlGetName, &pret, 0);
			std::string m_moduleText = pret.String;
			if (xl::API.IsExcel12()){
				for(UINT i = 0; i < m_typeText.size(); i ++){
					if (m_typeText[i] == 'R') m_typeText[i] = 'U';
					else if (m_typeText[i] == 'P') m_typeText[i] = 'Q';
				}
			}else{
				for(UINT i = 0; i < m_typeText.size(); i ++){
					if (m_typeText[i] == 'U') m_typeText[i] = 'R';
					else if (m_typeText[i] == 'Q') m_typeText[i] = 'P';
				}
			}		
			args[0] = new xlVar(m_moduleText);
			args[1] = new xlVar(m_procedure);
			args[2] = new xlVar(m_typeText);
			args[3] = new xlVar(m_functionText);
			args[4] = new xlVar(m_argumentText);
			args[5] = new xlVar(m_macroType);
			args[6] = new xlVar(m_category);
			args[7] = new xlVar(m_shortcutText);
			args[8] = new xlVar(m_helpTopic);
			args[9] = new xlVar(m_functionHelp);
			
			int n = m_argumentHelps.size();
			if(n > 0) m_argumentHelps[n-1] += " ";
			int i; 
			for(i = 0; i < n; i++){ args[10 + i] = new xlVar(m_argumentHelps[i]); }
			int r = API.Callv(xlfRegister, 0, 10 + i, args);
			for(i = 0; i < 10 + n; i++){
				delete args[i]; 
			}
			return r;
		}
	};

	class xlCmd : public xlFunc {
	public:
		xlCmd(
				const char* tProc,
				const char* tFunc
			){
			m_procedure = tProc;
			m_typeText = "";     
			m_functionText = tFunc;
			m_argumentText = ""; 
			m_macroType = 2;
			m_category = "";     
			m_shortcutText = "";
			m_helpTopic = "";    
			m_functionHelp = "";
		}
	};
}
