// AXL3 - An XLL Library
// Wrapper class library for Microsft Excel's xll add-in which written by C++.
//
// Copyright(c) 2009-2009, yukimi_sake@users.sourceforge.jp. All rights reserved.

// A class to keep IdSheet.
// Works like an Excel VBA's Worksheet object.

#pragma once

namespace xl{
	class xlSheet{
	private:
		IDSHEET m_sheetId; // Thanks for koza San.

		static void getDocument(xlVar *res, int type_num){
			API.Call(xlfGetDocument, res, "I", type_num);
		}		
		
		static IDSHEET  getSheetId(const xlVar* sName){
			xlRange id;
			int r = API.Call(xlSheetId, &id, "P", sName);
			if(API.IsExcel12()) return id.m_xloper12->val.mref.idSheet;
			else return id.m_xloper4->val.mref.idSheet;
		}

	public:
	// static methods
		static xlSheet Insert(const int pos=1){
			xlVar nm;
			API.Call(xlcWorkbookInsert, 0, "I", 1);
			getDocument(&nm, 1);
			return xlSheet(nm);
		}

		static xlSheet Insert(const xlVar& shName, const int pos=1){
			xlSheet sh = Insert();
			sh.Name = shName;
			return sh;
		}

		static xlSheet Insert(const char* shName, const int pos=1){
			return Insert(xlVar(shName), pos);
		}

		static xlSheet ActiveSheet(){
			xlVar nm;
			getDocument(&nm, 1);
			return xlSheet(nm);
		}

	// constructors
		xlSheet();

		xlSheet(const xlVar& name){
			m_sheetId = getSheetId(&name);
		}

		xlSheet(const char* name){
			m_sheetId = getSheetId(&xlVar(name));
		}

	// destructor
	//	~xlSheet();

	// properties
		Property(xlVar, Name);

	// access methods
		xlVar getName(){ 
			xlVar op;
			API.Call(xlSheetNm, &op,"P", &xlRange(m_sheetId));
			std::string s = op.String;
			std::string ss = s.substr(s.find(']') + 1);
			return xlVar(ss);
		}

		void putName(const xlVar& name){
			API.Call(xlcWorkbookName, 0, "PP", &xlVar(getName()), &name);
		}

		void putName(const char* name){
			putName(xlVar(name));
		}
		
	// public methods (XLM's WORKBOOK commands)
		xlVar GetFullName(){
			xlVar op;
			API.Call(xlSheetNm, &op,"P", &xlRange(m_sheetId));
			return op;
		}

		xlRange ActiveCell(){
			Activate();
			return xlRange::ActiveCell();
		}

		xlRange Range(int row, int col){
			return xlRange(row, col, &xlRange(m_sheetId));
		}

		xlRange Range(int rFirst, int cFirst, int rLast, int cLast){
			return xlRange(rFirst, cFirst, rLast, cLast, &xlRange(m_sheetId));
		}

		xlRange Selection(){
			Activate();
			return xlRange::Selection();
		}

		xlSheet& Activate(){
			API.Call(xlcWorkbookActivate, 0, "P", &xlVar(GetFullName()));
			return *this;
		}

		xlSheet Copy(const xlVar& bookName, const int pos){
			API.Call(xlcWorkbookCopy, 0, "PPI", &xlVar(GetFullName()), &bookName, pos);
			return xlSheet(getName());
		}

		xlSheet Copy(const int pos){ 
			xlVar bknm;
			getDocument(&bknm, 88); 
			return Copy(bknm, pos);
		}

		xlSheet& Hide(bool veryHidden = false){
			API.Call(xlcWorkbookHide, 0, "PB", &xlVar(getName()), veryHidden);
			return *this;
		}

		xlSheet& Show(){
			xlVar nm = getName();
			int r = API.Call(xlcWorkbookUnhide, 0, "P", &nm); 
			return *this;
		}

		xlSheet& Move(const xlVar& bookName, const int pos){
			API.Call(xlcWorkbookMove, 0, "PPI", &xlVar(GetFullName()), &bookName, pos);
			return *this;
		}

		xlSheet& Move(const int pos){
			xlVar bknm; 
			getDocument(&bknm, 88); 
			return Move(bknm, pos);
		}

		void Delete(){ 
			API.Call(xlcWorkbookDelete, 0, "P", &xlVar(GetFullName()));
		}

		void Protect(const std::string passwd = "", const bool objects = true, const bool scenarios = true){
			Activate();
			API.Call(xlcProtectDocument, 0, "B_SBB", true, passwd, objects, scenarios);
		}

		void UnProtect(const std::string passwd = ""){
			Activate();
			API.Call(xlcProtectDocument, 0, "B_S", false, passwd);
		}
	};
}