// AXL3 - An XLL Library
// Wrapper class library for Microsft Excel's xll add-in which written by C++.
//
// Copyright(c) 2009-2009, yukimi_sake@users.sourceforge.jp. All rights reserved.

#pragma once

#define XL_EXPORT extern "C" __declspec(dllexport)

#define XL_DELETE_SUBSTANCE(P, X) \
	int typ = P->xltype & 0xfff;\
	if (typ == xltypeStr) delete [] P->val.str;\
	else if(typ == xltypeRef) delete [] P->val.mref.lpmref;\
	else if (typ == xltypeMulti){\
		int size = P->val.array.rows * P->val.array.columns;\
		X p = P->val.array.lparray;\
		for(; size-- > 0; p++) if(p->xltype == xltypeStr) delete [] p->val.str;\
		delete [] P->val.array.lparray;}\
	delete P;

#define XL_AUTO_OPEN_BEGIN \
	extern "C" __declspec(dllexport) void xlAutoFree12(LPXLOPER12 px){\
		XL_DELETE_SUBSTANCE(px, LPXLOPER12)\
	}\
	extern "C" __declspec(dllexport) void xlAutoFree(LPXLOPER px){\
		XL_DELETE_SUBSTANCE(px, LPXLOPER)\
	}\
	extern "C" __declspec(dllexport) int xlAutoOpen(){ try{\
	if(!xl::API.Initialized()) xl::API.InitXlFunc();

#define XL_AUTO_OPEN_END return 1;}catch(...){return 0;} }

#define XL_PERFORM_ADDIN_MANAGER_INFO(x, y)\
	if(!xl::API.Initialized()) xl::API.InitXlFunc();\
	xlVar a(y, asArgFromXL);\
	xlVar s(x);\
	if(a.Num == 1) return xlVar(s).AsResToXL();\
	else return xlVar::NewErr(xlerrValue).AsResToXL();

#define XL_ADDIN_MANAGER_INFO(s) \
	XL_EXPORT void* xlAddInManagerInfo12(void* pAction){XL_PERFORM_ADDIN_MANAGER_INFO(s, pAction)}\
	XL_EXPORT void* xlAddInManagerInfo(void* pAction){XL_PERFORM_ADDIN_MANAGER_INFO(s, pAction)}


#define F_CALL_XLFREE -1
#define F_KEEP_VAL -2

#define Property(t,x) __declspec(property(get=get##x, put=put##x)) t x
#define PrReader(t,x) __declspec(property(get=get##x)) t x
#define PrWriter(t,x) __declspec(property(put=put##x)) t x

#define XL_CALL_FUNC_0(F) m_excel12 ? F<xloper12, XLPROC12>() : F<xloper4, XLPROC4>()
#define XL_CALL_FUNC_1(F, A1) m_excel12 ? F<xloper12, XLPROC12>(A1) : F<xloper4, XLPROC4>(A1)
#define XL_CALL_FUNC_2(F, A1, A2) m_excel12 ? F<xloper12, XLPROC12>(A1, A2) : F<xloper4, XLPROC4>(A1, A2)	

typedef xloper xloper4;
typedef int (PASCAL *XLPROC4)(int iXlfnc, int nArgs, xloper4** rgpxloper, xloper4* pRet);
typedef int (PASCAL *XLPROC12)(int iXlfnc, int nArgs, xloper12** rgpxloper, xloper12* pRet);


namespace xl{
	static void DebugP(const char* format, ...){
		char ch[256];
		va_list plist;
		va_start(plist, format);
		wvsprintfA(ch, format, plist);
		va_end(plist);
		OutputDebugStringA(ch);
	}

	class xlBase{
		friend class xlAPI;

	public:
	// properties
		PrReader(int, XlType);

	// access methods
		int getXlType(){
			if(m_excel12) return m_xloper12->xltype;
			else  return m_xloper4->xltype;
		}

	protected:
		static bool m_excel12;
		static void* m_xlproc;

		union{
			void *    m_xloper;   // dummy member for casting
			xloper*   m_xloper4;
			xloper12* m_xloper12;
		};

		int* m_refcount;

		template <class P> void f_setSubstance(){
			m_xloper = (void*)(new P);
			m_refcount = new int(0);
		}

		template <class P, class F> void f_createDefault(int optype = xltypeMissing){
			f_setSubstance<P>();
			((P*)m_xloper)->xltype = optype;
		}

		template <class P, class F> void f_createVoidPtr( void * op, int bitFree){
			if(bitFree < 0){
				m_xloper = op;
				m_refcount = new int(bitFree);
			}else{
				m_xloper = op;
				((P*)m_xloper)->xltype |= (UINT)bitFree;
				m_refcount = new int(0);
			}
		}

		 void f_createVoidPtr4(void * op, int bitFree){
			if(bitFree < 0){
				m_xloper = op;
				m_refcount = new int(bitFree);
			}else if(bitFree == xlbitXLFree){ // As arg from Excel
				m_xloper4 = new xloper4;
				if (((xloper4*)op)->xltype & (xltypeRef | xltypeSRef)){
					xloper4 tmp;
					f_coerce<xloper4, XLPROC4>(&tmp, (xloper4*)op, xltypeMulti);
					f_clone4(m_xloper4, &tmp);
				}else{
					f_clone4(m_xloper4, (xloper4*)op);
				}
				m_refcount = new int(0);
				((xloper*)op)->xltype |= xlbitXLFree;
			}else{
				m_xloper = op;
				m_xloper4->xltype |= (UINT)bitFree;
				m_refcount = new int(0);
			}
		}

		void f_createVoidPtr12( void * op, int bitFree){
			if(bitFree < 0){
				m_xloper = op;
				m_refcount = new int(bitFree);
			}else if(bitFree == xlbitXLFree){ // As arg from Excel
				m_xloper12 = new xloper12;
				if (((xloper12*)op)->xltype & (xltypeRef | xltypeSRef)){
					xloper12 tmp;
					f_coerce<xloper12, XLPROC12>(&tmp, (xloper12*)op, xltypeMulti);
					f_clone12(m_xloper12, &tmp);
				}else{
					f_clone12(m_xloper12, (xloper12*)op);
				}
				m_refcount = new int(0);
				((xloper12*)op)->xltype |= xlbitXLFree;
			}else{
				m_xloper = op;
				m_xloper12->xltype |= (UINT)bitFree;
				m_refcount = new int(0);
			}
		}

		template <class P> void f_createErr(int errNum = xlerrValue){
			m_refcount = new int(0);
			m_xloper = (void*)(new P);
			((P*)m_xloper)->xltype = xltypeRef;
			((P*)m_xloper)->val.w = errNum;
		}

		template <class P, class F> int f_coerce(P* dst, P* src, int xltype){
			P otype;
			otype.xltype = xltypeInt;
			otype.val.w= xltype;
			P* opers[2] = {(P*)src, &otype};
			return ((F)m_xlproc)(xlCoerce, 2, &opers[0], (P*)dst);
		}

		template <class P, class F> void f_xlfree(P* op){
			P* opers[1] = {op};
			((F)m_xlproc)(xlFree, 1, &opers[0], 0);
		}

		template <class P> int f_deleteVal(P* op){
			int typ = op->xltype & 0xfff;
			if (typ == xltypeStr) delete [] op->val.str;
			else if(typ == xltypeRef) delete [] op->val.mref.lpmref;
			else if (typ == xltypeMulti){
				int size = op->val.array.rows * op->val.array.columns;
				P* p = op->val.array.lparray;
				for(; size-- > 0; p++){
					if(p->xltype == xltypeStr) delete [] p->val.str;
				}
				delete [] op->val.array.lparray;
			}
			return 1;
		}

		template <class P> int f_deleteVal(P* op, int refcount){
			if(refcount == F_KEEP_VAL){
				if(op->xltype == xltypeMulti) return 0; return 1;
			}
			return f_deleteVal(op);
		}

		template <class P, class F> void f_deleteSubstance(){
			int refcount = *m_refcount;
			int typ = ((P*)m_xloper)->xltype ;
			if (refcount == F_CALL_XLFREE) f_xlfree<P, F>((P*)m_xloper);
			delete m_refcount;
			if (typ & (xlbitXLFree | xlbitDLLFree))
				return;
			if (refcount == F_KEEP_VAL) {
				if (typ == xltypeMulti) delete (P*)m_xloper;
				return;
			}
			if (refcount == 0) f_deleteVal((P*)m_xloper);
			delete (P*)m_xloper;
		}

		void f_clone4(xloper* op, xloper* fr){
			int typ = fr->xltype & 0xfff;
			op->xltype = typ; 
			op->val = fr->val;
			if (typ == xltypeStr){
				int len = (BYTE)fr->val.str[0] + 1;
				char* str = new char[len];
				memcpy_s(str, len, fr->val.str, len);
				op->val.str = str;
			}else if(typ == xltypeRef){
				XLMREF * lpmref = new XLMREF;
				memcpy_s(lpmref, sizeof XLMREF, fr->val.mref.lpmref, sizeof XLMREF);
				op->val.mref.lpmref  = lpmref;
			}else if (typ == xltypeMulti){
				size_t size = fr->val.array.rows * fr->val.array.columns;
				xloper* p = fr->val.array.lparray;
				xloper* p2 = new xloper[size];
				op->val.array.lparray = p2;
				memcpy_s(op->val.array.lparray, sizeof(xloper)*size, p, sizeof(xloper)*size);
				while(size-- > 0) {
					if(p->xltype == xltypeStr) {
						int len = (BYTE)p->val.str[0] + 1;
						p2->val.str = new CHAR[len];
						memcpy_s(p2->val.str, len, p->val.str, len);
					}
					p++; p2++;
				}
			}// else if (typ =  xltypeBigData){
				// not implemented yet.
			//}
		}

		void f_clone12(xloper12* op, xloper12* fr){
			int typ = fr->xltype & 0xfff;
			op->xltype = typ;
			op->val = fr->val ;
			if (typ == xltypeStr){
				int len = (WORD)fr->val.str[0] + 1;
				wchar_t* str = new wchar_t[len];
				memcpy_s(str, len*2, fr->val.str, len*2);
				op->val.str = str;
			}else if(typ == xltypeRef){
				if(fr->val.mref.lpmref == 0) return;
				XLMREF12 * lpmref = new XLMREF12;
				memcpy_s(lpmref, sizeof XLMREF12, fr->val.mref.lpmref, sizeof XLMREF12);
				op->val.mref.lpmref  = lpmref;
			}else if (typ == xltypeMulti){
				int size = fr->val.array.rows * fr->val.array.columns;
				xloper12* p = fr->val.array.lparray;
				xloper12* p2 = new xloper12[size];
				op->val.array.lparray = p2;
				memcpy_s(op->val.array.lparray, sizeof(xloper12)*size, p, sizeof(xloper12)*size);
				while(size-- > 0) {
					if(p->xltype == xltypeStr) {
						int len = (WORD)p->val.str[0] + 1;
						p2->val.str = new XCHAR[len];
						memcpy_s(p2->val.str, len*2,p->val.str,len*2);
					}
					 p++; p2++;
				}
			} // else if (typ =  xltypeBigData){
				// not implemented yet.
			//}
		}

	// copy constructor implement
		template <class T> void f_copyThis4(const T* from){
			int t = from->m_xloper4->xltype;
			if(from->m_xloper4->xltype & xlbitXLFree || *(from->m_refcount) == F_CALL_XLFREE){
				m_refcount = new int(0);
				m_xloper = new xloper4;
				f_clone4(m_xloper4, from->m_xloper4);
			}else if(*(from->m_refcount) == F_KEEP_VAL){
				m_refcount = new int(0);
				*m_refcount = F_KEEP_VAL;
				if(from->m_xloper4->xltype == xltypeMulti){ // single horizontal array sliced from array
					m_xloper = new xloper4;
					m_xloper4->xltype = xltypeMulti;
					m_xloper4->val = from->m_xloper4->val;
				}else{ // value of single horizontal array
					m_xloper = from->m_xloper;
				}
			}else{
				m_refcount = from->m_refcount;
				*m_refcount += 1;
				m_xloper4 = from->m_xloper4;
			}
		}

		template <class T> void f_copyThis12(const T* from){
			int t = from->m_xloper12->xltype;
			if(from->m_xloper12->xltype & xlbitXLFree || *(from->m_refcount) == F_CALL_XLFREE){
				m_refcount = new int(0);
				m_xloper = new xloper12;
				f_clone12(m_xloper12, from->m_xloper12);
			}else if(*(from->m_refcount) == F_KEEP_VAL){
				m_refcount = new int(0);
				*m_refcount = F_KEEP_VAL;
				if(from->m_xloper12->xltype == xltypeMulti){ // single horizontal array sliced from array
					m_xloper = new xloper12;
					m_xloper12->xltype = xltypeMulti;
					m_xloper12->val = from->m_xloper12->val;
				}else{ // value of single horizontal array
					m_xloper = from->m_xloper;
				}
			}else{
				m_refcount = from->m_refcount;
				*m_refcount += 1;
				m_xloper12 = from->m_xloper12;
			}
		}
	};
	__declspec(selectany) bool xl::xlBase::m_excel12 = false;
	__declspec(selectany) void* xl::xlBase::m_xlproc = NULL;
}
