/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.unix.misc;

import net.morilib.unix.misc.Tr;
import junit.framework.TestCase;

public class TrTest extends TestCase {

	static void eqi(int x, int y) {
		assertEquals(y, x);
	}

	static void eqs(String x, String y) {
		assertEquals(y, x);
	}

	public void testLength() {
		eqi(Tr.length("abc"), 3);
		eqi(Tr.length("a-c"), 3);
		eqi(Tr.length("a-z"), 26);
		eqi(Tr.length("a-cx-z"), 6);
		eqi(Tr.length("x-za-c"), 6);
		eqi(Tr.length("abcx-z"), 6);
	}

	public void testIndexOf() {
		eqi(Tr.indexOf("abc", 'a'), 0);
		eqi(Tr.indexOf("abc", 'b'), 1);
		eqi(Tr.indexOf("abc", 'c'), 2);
		eqi(Tr.indexOf("a-c", 'a'), 0);
		eqi(Tr.indexOf("a-c", 'b'), 1);
		eqi(Tr.indexOf("a-c", 'c'), 2);
		eqi(Tr.indexOf("a-z", 'a'), 0);
		eqi(Tr.indexOf("a-z", 'z'), 25);
		eqi(Tr.indexOf("a-cx-z", 'x'), 3);
		eqi(Tr.indexOf("x-za-c", 'a'), 3);
		eqi(Tr.indexOf("abcx-z", 'z'), 5);
	}

	public void testCodePointAt() {
		eqi(Tr.codePointAt("abc", 0), 'a');
		eqi(Tr.codePointAt("abc", 1), 'b');
		eqi(Tr.codePointAt("abc", 2), 'c');
		eqi(Tr.codePointAt("a-c", 0), 'a');
		eqi(Tr.codePointAt("a-c", 1), 'b');
		eqi(Tr.codePointAt("a-c", 2), 'c');
		eqi(Tr.codePointAt("a-z", 0), 'a');
		eqi(Tr.codePointAt("a-z", 25), 'z');
		eqi(Tr.codePointAt("a-cx-z", 3), 'x');
		eqi(Tr.codePointAt("x-za-c", 3), 'a');
		eqi(Tr.codePointAt("abcx-z", 5), 'z');
	}

	public void testTrI() {
		eqi(Tr.tr("abc", "xyz", 'a', false, false), 'x');
		eqi(Tr.tr("abc", "xyz", 'b', false, false), 'y');
		eqi(Tr.tr("abc", "xyz", 'c', false, false), 'z');
		eqi(Tr.tr("abc", "xyz", 'd', false, false), 'd');
		eqi(Tr.tr("a-c", "x-z", 'a', false, false), 'x');
		eqi(Tr.tr("a-c", "x-z", 'b', false, false), 'y');
		eqi(Tr.tr("a-c", "x-z", 'c', false, false), 'z');
		eqi(Tr.tr("a-c", "x-z", 'd', false, false), 'd');
	}

	public void testTrS() {
		eqs(Tr.tr("a-zA-Z", "A-Za-z",
				"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0", false, false),
				"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0");
		eqs(Tr.tr("a-zA-X", "A-Za-z",
				"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0", false, false),
				"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxYZ0");
		eqs(Tr.tr("a-zA-Z", "A-Za-x",
				"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0", false, false),
				"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxxx0");
	}

	public void testComplementIndexOf() {
		eqi(Tr.complementIndexOf(" ", ' '), -1);
		eqi(Tr.complementIndexOf(" ", '\n'), '\n');
		eqi(Tr.complementIndexOf(" ", 'b'), 'a');
		eqi(Tr.complementIndexOf("a-c", 'a'), -1);
		eqi(Tr.complementIndexOf("a-c", ' '), ' ');
		eqi(Tr.complementIndexOf("a-c", 'd'), 'a');
		eqi(Tr.complementIndexOf("abc", 'a'), -1);
		eqi(Tr.complementIndexOf("abc", ' '), ' ');
		eqi(Tr.complementIndexOf("abc", 'd'), 'a');
		eqi(Tr.complementIndexOf("a-ce-g", 'a'), -1);
		eqi(Tr.complementIndexOf("a-ce-g", ' '), ' ');
		eqi(Tr.complementIndexOf("a-ce-g", 'h'), 'b');
	}

	public void testComplementTrI() {
		eqi(Tr.tr(" ",
				"0123456789abcdef0123456789abcdef0123456789",
				'\n', true, false), 'a');
		eqi(Tr.tr(" ",
				"0123456789abcdef0123456789abcdef0123456789",
				'!', true, false), '0');
	}

	public void testComplementTrS() {
		eqs(Tr.tr(" ",
				"0123456789abcdef0123456789abcdef0123456789",
				"\n!", true, false), "a0");
	}

}
