/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.builtin;

import net.morilib.sh.ShCommandExecuteTest;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/05/30
 */
public class ShHeadTest extends ShCommandExecuteTest {

	public void testHead001() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.println("7");
		piw.println("8");
		piw.println("9");
		piw.println("10");
		piw.println("11");
		piw.close();
		exc("head", 0);
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot("6");
		eot("7");
		eot("8");
		eot("9");
		eot("10");
		eot();
	}

	public void testHead002() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.println("7");
		piw.println("8");
		piw.println("9");
		piw.println("10");
		piw.println("11");
		piw.close();
		exc("head -n 5", 0);
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot();
	}

	public void testHead003() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.println("7");
		piw.println("8");
		piw.println("9");
		piw.println("10");
		piw.println("11");
		piw.close();
		exc("head --lines=5", 0);
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot();
	}

	public void testHead004() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.println("7");
		piw.println("8");
		piw.println("9");
		piw.println("10");
		piw.println("11");
		piw.close();
		exc("head -5", 0);
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot();
	}

	public void testHead005() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.println("7");
		piw.println("8");
		piw.println("9");
		piw.println("10");
		piw.println("11");
		piw.close();
		exc("head -q -n 5", 0);
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot();
	}

	public void testHead006() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.println("7");
		piw.println("8");
		piw.println("9");
		piw.println("10");
		piw.println("11");
		piw.close();
		exc("head -n 5 -q", 0);
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot();
	}

	public void testHead007() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.println("7");
		piw.println("8");
		piw.println("9");
		piw.println("10");
		piw.println("11");
		piw.close();
		exc("head --lines=5 -q", 0);
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot();
	}

	public void testHead008() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.println("7");
		piw.println("8");
		piw.println("9");
		piw.println("10");
		piw.println("11");
		piw.close();
		exc("head --lines=5 -v", 0);
		eot("==> standard input <==");
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot();
	}

	public void testHead009() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.close();
		exc("head --lines=5 -v", 0);
		eot("==> standard input <==");
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot();
	}

	public void testHead010() {
		piw.println("1234567890");
		piw.println("2");
		piw.close();
		exc("head -c 5", 0);
		eot("12345");
		eot();
	}

	public void testHead011() {
		piw.println("1234567890");
		piw.println("2");
		piw.close();
		exc("head --bytes=5", 0);
		eot("12345");
		eot();
	}

	public void testHead012() {
		piw.println("1234567890");
		piw.println("2");
		piw.close();
		exc("head -5c", 0);
		eot("12345");
		eot();
	}

	public void testHead013() {
		piw.println("1234");
		piw.close();
		exc("head -5c", 0);
		eot("1234");
		eot();
	}

	public void testHead014() {
		piw.println("1234567890");
		piw.println("2");
		piw.close();
		exc("head -5cv", 0);
		eot("==> standard input <==");
		eot("12345");
		eot();
	}

	public void testHead015() {
		piw.println("1234567890");
		piw.println("2");
		piw.close();
		exc("head -5vc", 0);
		eot("==> standard input <==");
		eot("12345");
		eot();
	}

	public void testHead016() {
		piw.println("1234567890");
		piw.println("2");
		piw.close();
		exc("head -5cq", 0);
		eot("12345");
		eot();
	}

	public void testHead017() {
		piw.println("1234567890");
		piw.println("2");
		piw.close();
		exc("head -5qc", 0);
		eot("12345");
		eot();
	}

	public void testHead018() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.close();
		exc("head -5n", 0);
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot();
	}

	public void testHead019() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.close();
		exc("head -5nq", 0);
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot();
	}

	public void testHead020() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.close();
		exc("head -5qn", 0);
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot();
	}

	public void testHead021() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.close();
		exc("head -5nv", 0);
		eot("==> standard input <==");
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot();
	}

	public void testHead022() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.close();
		exc("head -5vn", 0);
		eot("==> standard input <==");
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot();
	}

	public void testHead023() {
		piw.println("１２３４５６７８９０");
		piw.println("2");
		piw.close();
		exc("head -C 5", 0);
		eot("１２３４５");
		eot();
	}

	public void testHead024() {
		piw.println("１２３４５６７８９０");
		piw.println("2");
		piw.close();
		exc("head --characters=5", 0);
		eot("１２３４５");
		eot();
	}

	public void testHead025() {
		piw.println("１２３４５６７８９０");
		piw.println("2");
		piw.close();
		exc("head -5C", 0);
		eot("１２３４５");
		eot();
	}

	public void testHead026() {
		piw.println("１２３４");
		piw.close();
		exc("head -5C", 0);
		eot("１２３４");
		eot();
	}

	public void testHead027() {
		piw.println("１２３４５６７８９０");
		piw.println("2");
		piw.close();
		exc("head -5Cv", 0);
		eot("==> standard input <==");
		eot("１２３４５");
		eot();
	}

	public void testHead028() {
		piw.println("１２３４５６７８９０");
		piw.println("2");
		piw.close();
		exc("head -5vC", 0);
		eot("==> standard input <==");
		eot("１２３４５");
		eot();
	}

	public void testHead029() {
		piw.println("１２３４５６７８９０");
		piw.println("2");
		piw.close();
		exc("head -5Cq", 0);
		eot("１２３４５");
		eot();
	}

	public void testHead030() {
		piw.println("１２３４５６７８９０");
		piw.println("2");
		piw.close();
		exc("head -5qC", 0);
		eot("１２３４５");
		eot();
	}

	public void testHead031() {
		piw.println("1234567890");
		piw.println("2");
		piw.close();
		exc("head -c 5 --quiet", 0);
		eot("12345");
		eot();
	}

	public void testHead032() {
		piw.println("1234567890");
		piw.println("2");
		piw.close();
		exc("head -c 5 --silent", 0);
		eot("12345");
		eot();
	}

	public void testHead033() {
		piw.println("1234567890");
		piw.println("2");
		piw.close();
		exc("head -c 5 --verbose", 0);
		eot("==> standard input <==");
		eot("12345");
		eot();
	}

	public void testHead034() {
		piw.println("1234567890");
		piw.println("2");
		piw.close();
		exc("head -c 5 -", 0);
		eot("12345");
		eot();
	}

	public void testHead035() {
		piw.println("1234567890");
		piw.println("2");
		piw.close();
		exc("head -c 5 -- -", 0);
		eot("12345");
		eot();
	}

	public void testHead036() {
		piw.println("1234567890");
		piw.println("2");
		piw.close();
		exc("head -c 5 -v -", 0);
		eot("==> standard input <==");
		eot("12345");
		eot();
	}

	public void testHead037() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.close();
		exc("head -vn 5", 0);
		eot("==> standard input <==");
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot();
	}

	public void testHead038() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.close();
		exc("head -qn 5", 0);
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot();
	}

	public void testHead039() {
		piw.println("1234567890");
		piw.println("2");
		piw.close();
		exc("head -vc 5", 0);
		eot("==> standard input <==");
		eot("12345");
		eot();
	}

	public void testHead040() {
		piw.println("1234567890");
		piw.println("2");
		piw.close();
		exc("head -qc 5", 0);
		eot("12345");
		eot();
	}

	public void testHead041() {
		piw.println("１２３４５６７８９０");
		piw.println("2");
		piw.close();
		exc("head -vC 5", 0);
		eot("==> standard input <==");
		eot("１２３４５");
		eot();
	}

	public void testHead042() {
		piw.println("１２３４５６７８９０");
		piw.println("2");
		piw.close();
		exc("head -qC 5", 0);
		eot("１２３４５");
		eot();
	}

	public void testHead043() {
		exc("head -c 5 cut.txt", 0);
		eot("12345");
		eot();
	}

	public void testHead044() {
		exc("head -vc 5 cut.txt", 0);
		eot("==> cut.txt <==");
		eot("12345");
		eot();
	}

	public void testHead045() {
		exc("head -c 5 cut.txt cut2.txt", 0);
		eot("1234512345");
		eot();
	}

	public void testHead046() {
		exc("head -vc 5 cut.txt cut2.txt", 0);
		eot("==> cut.txt <==");
		eot("12345");
		eot("==> cut2.txt <==");
		eot("12345");
		eot();
	}

	public void testHeadI001() {
		redef(qiw, "EUC-JP");
		redef(qor, "EUC-JP");
		rev.bind("LANG", "ja_JP.EUC-JP");
		piw.println("１");
		piw.println("２");
		piw.println("３");
		piw.println("４");
		piw.println("５");
		piw.println("６");
		piw.close();
		exc("head -n 2", 0);
		eot("１");
		eot("２");
		eot();
	}

}
