/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.dc;

import java.math.BigDecimal;

import junit.framework.TestCase;

public class DcMathTest extends TestCase {

	void eqd(String s, String t) {
		assertEquals(new BigDecimal(t), DcMath.sqrt(new BigDecimal(s)));
	}

	public void testSqrtD1() {
		eqd("4", "2");
		eqd("4.00", "2.00");
		eqd("4.0", "2.0");
	}

	public void testSqrtD2() {
		eqd("2.00", "1.41");
		eqd("2.0", "1.4");
	}

	public void testSqrtD3() {
		eqd("5.00",  "2.24");
		eqd("5.000", "2.236");
	}

}
