/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.random;

/**
 * 乱数発生器をあらわすインターフェースです。
 * 
 *
 * @author MORIGUCHI, Yuichiro 2011/12/24
 */
public interface RandomSource {

	/**
	 * 乱数発生器を与えられた種で初期化します。
	 * 
	 * @param s 乱数の種
	 */
	public void init(long s);

	/**
	 * 乱数系列の次の符号なしint整数を得ます。
	 * 
	 * @return 符号なしint乱数
	 */
	public long nextUnsignedInt();

	/**
	 * 乱数系列の次のint整数を得ます。
	 * 
	 * @return int乱数
	 */
	public int nextInt();

	/**
	 * [0, 1]の範囲の一様乱数を得ます。
	 * 
	 * @return 一様乱数
	 */
	public double nextDouble1Closed();

	/**
	 * [0, 1)の範囲の一様乱数を得ます。
	 * 
	 * @return 一様乱数
	 */
	public double nextDouble1RightOpen();

	/**
	 * (0, 1)の範囲の一様乱数を得ます。
	 * 
	 * @return 一様乱数
	 */
	public double nextDouble1Open();

	/**
	 * 乱数の状態を得ます。
	 * 
	 * @return 状態
	 */
	public RandomState getState();

	/**
	 * 乱数の状態をセットします。
	 * 
	 * @param s 状態
	 */
	public void setState(RandomState s);

	/**
	 * 乱数の種を得ます。
	 * 
	 * @return 種
	 */
	public long getSeed();

}
