/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.matrix;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/09/21
 */
public class PermutationDoubleMatrix extends AbstractImmutableDoubleMatrix {

	//
	private int[] order;
	private int   parity;

	//
	/*package*/ PermutationDoubleMatrix(int[] order, int parity) {
		this.order  = order;
		this.parity = parity;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.matrix.ILispNumberMatrix#get(int, int)
	 */
	public double get(int row, int column) {
		return (order[row] == column) ? 1.0 : 0.0;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.matrix.ILispMatrix#rowSize()
	 */
	public int rowSize() {
		return order.length;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.matrix.ILispMatrix#columnSize()
	 */
	public int columnSize() {
		return order.length;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.matrix.ILispMatrix#determinant()
	 */
	public double determinant() {
		return ((parity & 1) == 0) ? 1 : -1;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.matrix.ILispMatrix#invert()
	 */
	public PermutationDoubleMatrix inv() {
		int[] no = new int[order.length];

		for(int i = 0; i < no.length; i++) {
			no[order[i]] = i;
		}
		return new PermutationDoubleMatrix(no, parity);
	}

}
