/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.builtin;

import net.morilib.sh.ShCommandExecuteTest;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/05/30
 */
public class ShTailTest extends ShCommandExecuteTest {

	public void testTail001() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.println("7");
		piw.println("8");
		piw.println("9");
		piw.println("10");
		piw.println("11");
		piw.close();
		exc("tail", 0);
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot("6");
		eot("7");
		eot("8");
		eot("9");
		eot("10");
		eot("11");
		eot();
	}

	public void testTail002() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.println("7");
		piw.println("8");
		piw.println("9");
		piw.println("10");
		piw.println("11");
		piw.close();
		exc("tail -n 5", 0);
		eot("7");
		eot("8");
		eot("9");
		eot("10");
		eot("11");
		eot();
	}

	public void testTail003() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.println("7");
		piw.println("8");
		piw.println("9");
		piw.println("10");
		piw.println("11");
		piw.close();
		exc("tail --lines=5", 0);
		eot("7");
		eot("8");
		eot("9");
		eot("10");
		eot("11");
		eot();
	}

	public void testTail004() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.println("7");
		piw.println("8");
		piw.println("9");
		piw.println("10");
		piw.println("11");
		piw.close();
		exc("tail -5", 0);
		eot("7");
		eot("8");
		eot("9");
		eot("10");
		eot("11");
		eot();
	}

	public void testTail005() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.println("7");
		piw.println("8");
		piw.println("9");
		piw.println("10");
		piw.println("11");
		piw.close();
		exc("tail -q -n 5", 0);
		eot("7");
		eot("8");
		eot("9");
		eot("10");
		eot("11");
		eot();
	}

	public void testTail006() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.println("7");
		piw.println("8");
		piw.println("9");
		piw.println("10");
		piw.println("11");
		piw.close();
		exc("tail -n 5 -q", 0);
		eot("7");
		eot("8");
		eot("9");
		eot("10");
		eot("11");
		eot();
	}

	public void testTail007() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.println("7");
		piw.println("8");
		piw.println("9");
		piw.println("10");
		piw.println("11");
		piw.close();
		exc("tail --lines=5 -q", 0);
		eot("7");
		eot("8");
		eot("9");
		eot("10");
		eot("11");
		eot();
	}

	public void testTail008() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.println("7");
		piw.println("8");
		piw.println("9");
		piw.println("10");
		piw.println("11");
		piw.close();
		exc("tail --lines=5 -v", 0);
		eot("==> standard input <==");
		eot("7");
		eot("8");
		eot("9");
		eot("10");
		eot("11");
		eot();
	}

	public void testTail009() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.close();
		exc("tail --lines=5 -v", 0);
		eot("==> standard input <==");
		eot("1");
		eot("2");
		eot("3");
		eot("4");
		eot();
	}

	public void testTail010() {
		piw.println("2");
		piw.print("1234567890");
		piw.close();
		exc("tail -c 5", 0);
		eot("67890");
		eot();
	}

	public void testTail011() {
		piw.println("2");
		piw.print("1234567890");
		piw.close();
		exc("tail --bytes=5", 0);
		eot("67890");
		eot();
	}

	public void testTail012() {
		piw.println("2");
		piw.print("1234567890");
		piw.close();
		exc("tail -5c", 0);
		eot("67890");
		eot();
	}

	public void testTail013() {
		piw.print("1234");
		piw.close();
		exc("tail -5c", 0);
		eot("1234");
		eot();
	}

	public void testTail014() {
		piw.println("2");
		piw.print("1234567890");
		piw.close();
		exc("tail -5cv", 0);
		eot("==> standard input <==");
		eot("67890");
		eot();
	}

	public void testTail015() {
		piw.println("2");
		piw.print("1234567890");
		piw.close();
		exc("tail -5vc", 0);
		eot("==> standard input <==");
		eot("67890");
		eot();
	}

	public void testTail016() {
		piw.println("2");
		piw.print("1234567890");
		piw.close();
		exc("tail -5cq", 0);
		eot("67890");
		eot();
	}

	public void testTail017() {
		piw.println("2");
		piw.print("1234567890");
		piw.close();
		exc("tail -5qc", 0);
		eot("67890");
		eot();
	}

	public void testTail018() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.close();
		exc("tail -5n", 0);
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot("6");
		eot();
	}

	public void testTail019() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.close();
		exc("tail -5nq", 0);
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot("6");
		eot();
	}

	public void testTail020() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.close();
		exc("tail -5qn", 0);
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot("6");
		eot();
	}

	public void testTail021() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.close();
		exc("tail -5nv", 0);
		eot("==> standard input <==");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot("6");
		eot();
	}

	public void testTail022() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.close();
		exc("tail -5vn", 0);
		eot("==> standard input <==");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot("6");
		eot();
	}

	public void testTail023() {
		piw.println("2");
		piw.print("１２３４５６７８９０");
		piw.close();
		exc("tail -C 5", 0);
		eot("６７８９０");
		eot();
	}

	public void testTail024() {
		piw.println("2");
		piw.print("１２３４５６７８９０");
		piw.close();
		exc("tail --characters=5", 0);
		eot("６７８９０");
		eot();
	}

	public void testTail025() {
		piw.println("2");
		piw.print("１２３４５６７８９０");
		piw.close();
		exc("tail -5C", 0);
		eot("６７８９０");
		eot();
	}

	public void testTail026() {
		piw.print("１２３４");
		piw.close();
		exc("tail -5C", 0);
		eot("１２３４");
		eot();
	}

	public void testTail027() {
		piw.println("2");
		piw.print("１２３４５６７８９０");
		piw.close();
		exc("tail -5Cv", 0);
		eot("==> standard input <==");
		eot("６７８９０");
		eot();
	}

	public void testTail028() {
		piw.println("2");
		piw.print("１２３４５６７８９０");
		piw.close();
		exc("tail -5vC", 0);
		eot("==> standard input <==");
		eot("６７８９０");
		eot();
	}

	public void testTail029() {
		piw.println("2");
		piw.print("１２３４５６７８９０");
		piw.close();
		exc("tail -5Cq", 0);
		eot("６７８９０");
		eot();
	}

	public void testTail030() {
		piw.println("2");
		piw.print("１２３４５６７８９０");
		piw.close();
		exc("tail -5qC", 0);
		eot("６７８９０");
		eot();
	}

	public void testTail031() {
		piw.println("2");
		piw.print("1234567890");
		piw.close();
		exc("tail -c 5 --quiet", 0);
		eot("67890");
		eot();
	}

	public void testTail032() {
		piw.println("2");
		piw.print("1234567890");
		piw.close();
		exc("tail -c 5 --silent", 0);
		eot("67890");
		eot();
	}

	public void testTail033() {
		piw.println("2");
		piw.print("1234567890");
		piw.close();
		exc("tail -c 5 --verbose", 0);
		eot("==> standard input <==");
		eot("67890");
		eot();
	}

	public void testTail034() {
		piw.println("2");
		piw.print("1234567890");
		piw.close();
		exc("tail -c 5 -", 0);
		eot("67890");
		eot();
	}

	public void testTail035() {
		piw.println("2");
		piw.print("1234567890");
		piw.close();
		exc("tail -c 5 -- -", 0);
		eot("67890");
		eot();
	}

	public void testTail036() {
		piw.println("2");
		piw.print("1234567890");
		piw.close();
		exc("tail -c 5 -v -", 0);
		eot("==> standard input <==");
		eot("67890");
		eot();
	}

	public void testTail037() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.close();
		exc("tail -vn 5", 0);
		eot("==> standard input <==");
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot("6");
		eot();
	}

	public void testTail038() {
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("4");
		piw.println("5");
		piw.println("6");
		piw.close();
		exc("tail -qn 5", 0);
		eot("2");
		eot("3");
		eot("4");
		eot("5");
		eot("6");
		eot();
	}

	public void testTail039() {
		piw.println("2");
		piw.print("1234567890");
		piw.close();
		exc("tail -vc 5", 0);
		eot("==> standard input <==");
		eot("67890");
		eot();
	}

	public void testTail040() {
		piw.println("2");
		piw.print("1234567890");
		piw.close();
		exc("tail -qc 5", 0);
		eot("67890");
		eot();
	}

	public void testTail041() {
		piw.println("2");
		piw.print("１２３４５６７８９０");
		piw.close();
		exc("tail -vC 5", 0);
		eot("==> standard input <==");
		eot("６７８９０");
		eot();
	}

	public void testTail042() {
		piw.println("2");
		piw.print("１２３４５６７８９０");
		piw.close();
		exc("tail -qC 5", 0);
		eot("６７８９０");
		eot();
	}

	public void testTail043() {
		exc("tail -c 5 cut.txt", 0);
		eot("67890");
		eot();
	}

	public void testTail044() {
		exc("tail -vc 5 cut.txt", 0);
		eot("==> cut.txt <==");
		eot("67890");
		eot();
	}

	public void testTail045() {
		exc("tail -c 5 cut.txt cut2.txt", 0);
		eot("6789067890");
		eot();
	}

	public void testTail046() {
		exc("tail -vc 5 cut.txt cut2.txt", 0);
		eot("==> cut.txt <==");
		eot("67890");
		eot("==> cut2.txt <==");
		eot("67890");
		eot();
	}

	public void testTailI001() {
		redef(qiw, "EUC-JP");
		redef(qor, "EUC-JP");
		rev.bind("LANG", "ja_JP.EUC-JP");
		piw.println("１");
		piw.println("２");
		piw.println("３");
		piw.println("４");
		piw.println("５");
		piw.println("６");
		piw.close();
		exc("tail -n 2", 0);
		eot("５");
		eot("６");
		eot();
	}

}
