package net.morilib.sh.builtin;

import net.morilib.sh.ShCommandExecuteTest;

public class ShGrepTest extends ShCommandExecuteTest {

	public void test001() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep 'aa'", 0);
		eot("aaaaa");
		eot("aabba");
		eot();
	}

	public void test002() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep -J 'aa'", 0);
		eot("aaaaa");
		eot("aabba");
		eot();
	}

	public void test003() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep -e 'aa'", 0);
		eot("aaaaa");
		eot("aabba");
		eot();
	}

	public void test004() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep -n 'aa'", 0);
		eot("1:aaaaa");
		eot("2:aabba");
		eot();
	}

	public void test005() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep -H 'aa'", 0);
		eot("(stdin):aaaaa");
		eot("(stdin):aabba");
		eot();
	}

	public void test006() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep -Hn 'aa'", 0);
		eot("(stdin):1:aaaaa");
		eot("(stdin):2:aabba");
		eot();
	}

	public void test007() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep -c 'aa'", 0);
		eot("2");
		eot();
	}

	public void test008() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep -c 'dd'", 1);
		eot("0");
		eot();
	}

	public void test009() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep 'dd'", 1);
		eot();
	}

	public void test010() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep -l 'aa'", 0);
		eot("(stdin)");
		eot();
	}

	public void test011() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep -l 'dd'", 1);
		eot();
	}

	public void test012() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep -v 'aa'", 0);
		eot("bbbbb");
		eot("ccccc");
		eot();
	}

	public void test013() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep -vn 'aa'", 0);
		eot("3:bbbbb");
		eot("4:ccccc");
		eot();
	}

	public void test014() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep -cv '[ab]'", 0);
		eot("1");
		eot();
	}

	public void test015() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep -lv '[abc]'", 1);
		eot();
	}

	public void test016() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep -q '[abc]'", 0);
		eot();
	}

	public void test017() {
		piw.println("aaaaa");
		piw.println("aabba");
		piw.println("bbbbb");
		piw.println("ccccc");
		piw.close();
		exc("grep -qv '[abc]'", 1);
		eot();
	}

	public void test018() {
		piw.println("x");
		piw.println("bbbbb");
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("x");
		piw.close();
		exc("grep -A 3 'bbb'", 0);
		eot("bbbbb");
		eot("1");
		eot("2");
		eot("3");
		eot();
	}

	public void test019() {
		piw.println("x");
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("bbbbb");
		piw.println("x");
		piw.close();
		exc("grep -B 3 'bbb'", 0);
		eot("1");
		eot("2");
		eot("3");
		eot("bbbbb");
		eot();
	}

	public void test020() {
		piw.println("x");
		piw.println("1");
		piw.println("2");
		piw.println("3");
		piw.println("bbbbb");
		piw.println("I");
		piw.println("II");
		piw.println("III");
		piw.println("x");
		piw.close();
		exc("grep -C 3 'bbb'", 0);
		eot("1");
		eot("2");
		eot("3");
		eot("bbbbb");
		eot("I");
		eot("II");
		eot("III");
		eot();
	}

	public void test021() {
		piw.close();
		exc("grep 'bbb' grep1.txt", 0);
		eot("bbb");
		eot();
	}

	public void test022() {
		piw.close();
		exc("grep 'bbb' grep1.txt grep2.txt", 0);
		eot("grep1.txt:bbb");
		eot("grep2.txt:bbb");
		eot();
	}

	public void test023() {
		piw.close();
		exc("grep -h 'bbb' grep1.txt grep2.txt", 0);
		eot("bbb");
		eot("bbb");
		eot();
	}

	public void test024() {
		piw.println("------");
		piw.println("bbbbb");
		piw.println("x");
		piw.close();
		exc("grep -e -", 0);
		eot("------");
		eot();
	}

	public void testF001() {
		piw.println("aabba");
		piw.println("hana*hana");
		piw.println("ccccc");
		piw.close();
		exc("grep -F '*'", 0);
		eot("hana*hana");
		eot();
	}

	public void testF002() {
		piw.println("------");
		piw.println("bbbbb");
		piw.println("x");
		piw.close();
		exc("grep -Ff grep1.txt", 0);
		eot("bbbbb");
		eot();
	}

	public void testF003() {
		piw.println("bbb");
		piw.println("bbbbb");
		piw.println("x");
		piw.close();
		exc("grep -Fx bbbbb", 0);
		eot("bbbbb");
		eot();
	}

	public void testF004() {
		piw.println("bbb");
		piw.println("bbbbb");
		piw.println("aaa bbb");
		piw.println("x");
		piw.close();
		exc("grep -Fw bbb", 0);
		eot("bbb");
		eot("aaa bbb");
		eot();
	}

	public void testJ003() {
		piw.println("bbb");
		piw.println("bbbbb");
		piw.println("x");
		piw.close();
		exc("grep -x bbbbb", 0);
		eot("bbbbb");
		eot();
	}

	public void testJ004() {
		piw.println("bbb");
		piw.println("bbbbb");
		piw.println("aaa bbb");
		piw.println("x");
		piw.close();
		exc("grep -w bbb", 0);
		eot("bbb");
		eot("aaa bbb");
		eot();
	}

	public void testG001() {
		piw.println("aabb");
		piw.println("abab");
		piw.println("x");
		piw.close();
		exc("grep -G '\\(..\\)\\1'", 0);
		eot("abab");
		eot();
	}

	public void testG003() {
		piw.println("abab");
		piw.println("ababab");
		piw.println("x");
		piw.close();
		exc("grep -Gx '\\(..\\)\\1'", 0);
		eot("abab");
		eot();
	}

	public void testG004() {
		piw.println("abab");
		piw.println("ababab");
		piw.println("ababab ");
		piw.println(" ababab");
		piw.println(" ababab ");
		piw.println("aaa abab");
		piw.println("abab aaa");
		piw.println("aaa abab aaa");
		piw.println("x");
		piw.close();
		exc("grep -Gw '\\(..\\)\\1'", 0);
		eot("abab");
		eot("aaa abab");
		eot("abab aaa");
		eot("aaa abab aaa");
		eot();
	}

	public void testI001() {
		redef(qiw, "EUC-JP");
		redef(qor, "EUC-JP");
		rev.bind("LANG", "ja_JP.EUC-JP");
		piw.println("ｂｂｂｂｂ");
		piw.println("ｃｃｃｃｃ");
		piw.close();
		exe("grep ｂ", 0);
		eot("ｂｂｂｂｂ");
		eot();
	}

}
