package net.morilib.sh;

public class ShSimpleCommandExecuteTest extends ShCommandExecuteTest {

	public void testBind001() {
		exe("aa=1", 0);
		exe("echo $aa", 0);
		eot("1");
	}

	public void testBind002() {
		exe("aa=1", 0);
		exe("bb=$aa", 0);
		exe("echo $bb", 0);
		eot("1");
	}

	public void testBind003() {
		exe("aa=1", 0);
		exe("bb='$aa'", 0);
		exe("echo $bb", 0);
		eot("$aa");
	}

	public void testBind004() {
		exe("aa=1", 0);
		exe("bb=\"$aa\"", 0);
		exe("echo $bb", 0);
		eot("1");
	}

	public void testBind005() {
		exe("aa=1", 0);
		exe("bb='1   1'", 0);
		exe("echo $bb", 0);
		eot("1 1");
	}

	public void testBind006() {
		exe("aa=1", 0);
		exe("bb=\"1   1\"", 0);
		exe("echo $bb", 0);
		eot("1 1");
	}

	public void testBind007() {
		exe("aa=*", 0);
		exe("echo $aa", 0);
		eot("haruka chihaya yukiho azusa ritsuko");
	}

	public void testBind008() {
		exe("aa=\"*\"", 0);
		exe("echo $aa", 0);
		eot("haruka chihaya yukiho azusa ritsuko");
	}

	public void testBind009() {
		exe("aa='*'", 0);
		exe("echo $aa", 0);
		eot("haruka chihaya yukiho azusa ritsuko");
	}

	public void testBind010() {
		exe("aa=*zzz", 0);
		exe("echo $aa", 0);
		eot("*zzz");
	}

	public void testBind101() {
		exe("aa=1 bb=2", 0);
		exe("echo $aa $bb", 0);
		eot("1 2");
	}

	public void testEcho001() {
		exe("echo aaa", 0);
		eot("aaa");
	}

	public void testEcho002() {
		env.bind("VAR", "var");
		exe("echo $VAR", 0);
		eot("var");
	}

	public void testTest001() {
		exe("[ aaa ]", 0);
	}

	public void testTest002() {
		env.bind("VAR", "var");
		exe("[ $VAR  ]", 0);
	}

	public void testTest003() {
		env.bind("VAR", "var");
		exe("[ -z $VAR  ]", 1);
	}

	public void testRedirect001() {
		exe("echo aaa > 1.txt", 0);
		eot();
		eot(o1r, "1.txt");
		eot(o1r, "aaa");
	}

	public void testRedirect002() {
		exe("echo aaa >1.txt", 0);
		eot();
		eot(o1r, "1.txt");
		eot(o1r, "aaa");
	}

	public void testRedirect003() {
		exe("echo > 1.txt aaa", 0);
		eot();
		eot(o1r, "1.txt");
		eot(o1r, "aaa");
	}

	public void testRedirect004() {
		exe("> 1.txt echo aaa", 0);
		eot();
		eot(o1r, "1.txt");
		eot(o1r, "aaa");
	}

	public void testRedirect005() {
		exe("echo aaa 1>&2", 0);
		eet("aaa");
	}

	public void testRedirect006() {
		exe("echo aaa > 1.txt 1>&2", 0);
		eet("aaa");
		eot(o1r, "1.txt");  eot(o1r);
	}

	public void testRedirect007() {
		exe("echo aaa 2> 1.txt 1>&2", 0);
		eot();
		eot(o1r, "1.txt");
		eot(o1r, "aaa");
	}

	public void testHere001() {
		exe(    "cat << END\n" +
				"aaaaa\n" +
				"bbbbb\n" +
				"END", 0);
		eot("aaaaa");
		eot("bbbbb");
		eot();
	}

	public void testHere002() {
		env.bind("VAR", "var");
		exe(    "cat << END\n" +
				"${VAR}\n" +
				"bbbbb\n" +
				"END", 0);
		eot("var");
		eot("bbbbb");
		eot();
	}

	public void testHere003() {
		env.bind("VAR", "var");
		exe(    "cat << END\n" +
				"$VAR\n" +
				"bbbbb\n" +
				"END", 0);
		eot("var");
		eot("bbbbb");
		eot();
	}

	public void testHere004() {
		env.bind("VAR", "var");
		exe(    "cat << END\n" +
				"${VAR}  ${VAR}\n" +
				"bbbbb\n" +
				"END", 0);
		eot("var  var");
		eot("bbbbb");
		eot();
	}

	public void testHere005() {
		env.bind("VAR", "var");
		exe(    "cat << END\n" +
				"$VAR  $VAR\n" +
				"bbbbb\n" +
				"END", 0);
		eot("var  var");
		eot("bbbbb");
		eot();
	}

	public void testBindExe001() {
		exe("aa=1 echo $aa", 0);
		eot("1");
	}

	public void testBindExe002() {
		exe("aa=1", 0);
		exe("readonly aa", 0);
		exe("aa=2 echo $aa", 0);
		eet("aa: readonly variable");
		eot("1");
	}

	public void testBindExe003() {
		exe("aa=1 bb='aaa  bbb' echo $aa \"$bb\"", 0);
		eot("1 aaa  bbb");
	}

}
