/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.stat;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import net.morilib.awk.builtin.AwkUnaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.stat.StatisticsUtils;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 * 関数stat.modeの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class Mode extends AwkUnaryArgs {

	public Mode() {
		super("mode");
	}

	public double eval(double... d) {
		return StatisticsUtils.mode(d);
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1) {
		AwkValue r = AwkUndefined.UNDEF;
		Collection<AwkValue> v;
		Map<AwkValue, Long> m;
		boolean isnum = true;
		double[] d;
		int i = 0;
		long c;

		if(a1 instanceof AwkArray) {
			m = new HashMap<AwkValue, Long>();
			v = a1.values();
			d = new double[v.size()];
			for(AwkValue a : v) {
				if(m.containsKey(a)) {
					m.put(a, m.get(a) + 1);
				} else {
					m.put(a, 1l);
				}

				if(isnum && a.isRealValue()) {
					d[i++] = a.toFloat();
				} else {
					isnum = false;
				}
			}

			if(isnum) {
				return AwkFloat.valueOf(eval(d));
			} else {
				c = -1;
				for(Map.Entry<AwkValue, Long> e : m.entrySet()) {
					if(c < e.getValue()) {
						c = e.getValue();
						r = e.getKey();
					}
				}
				return r;
			}
		} else {
			return a1;
		}
	}

}
