/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.builtin;

import net.morilib.sh.ShCommandExecuteTest;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/06/08
 */
public class ShSortTest extends ShCommandExecuteTest {

	public void test001() {
		piw.println("72.0   chihaya");
		piw.println("91.0  azusa");
		piw.println("105.0 shizuku");
		piw.close();
		exe("sort", 0);
		eot("105.0 shizuku");
		eot("72.0   chihaya");
		eot("91.0  azusa");
	}

	public void test002() {
		piw.println("72.0 chihaya");
		piw.println("91.0 azusa");
		piw.println("105.0 shizuku");
		piw.close();
		exe("sort -n", 0);
		eot("72.0 chihaya");
		eot("91.0 azusa");
		eot("105.0 shizuku");
	}

	public void test003() {
		piw.println("\t  -72.0 chihaya");
		piw.println("  -91.0 azusa");
		piw.println(" -105.0 shizuku");
		piw.close();
		exe("sort -n", 0);
		eot(" -105.0 shizuku");
		eot("  -91.0 azusa");
		eot("\t  -72.0 chihaya");
	}

	public void test004() {
		piw.println("72.0 Chihaya Kisaragi");
		piw.println("91.0 Azusa Miura");
		piw.println("105.0 Shizuku Oikawa");
		piw.close();
		exe("sort -k 2", 0);
		eot("91.0 Azusa Miura");
		eot("72.0 Chihaya Kisaragi");
		eot("105.0 Shizuku Oikawa");
	}

	public void test005() {
		piw.println("91.0 Azusa Miura");
		piw.println("72.0 Chihaya Kisaragi");
		piw.println("105.0 Shizuku Oikawa");
		piw.close();
		exe("sort +2", 0);
		eot("72.0 Chihaya Kisaragi");
		eot("91.0 Azusa Miura");
		eot("105.0 Shizuku Oikawa");
	}

	public void test006() {
		piw.println("   -72.0 chihaya");
		piw.println("  -91.0 azusa");
		piw.println(" -105.0 shizuku");
		piw.close();
		exe("sort -b", 0);
		eot(" -105.0 shizuku");
		eot("   -72.0 chihaya");
		eot("  -91.0 azusa");
	}

	public void test007() {
		piw.println("80.0 Mio Kisaragi");
		piw.println("91.0 Azusa Miura");
		piw.println("72.0 Chihaya Kisaragi");
		piw.println("105.0 Shizuku Oikawa");
		piw.close();
		exe("sort +2 -3 +1 -2", 0);
		eot("72.0 Chihaya Kisaragi");
		eot("80.0 Mio Kisaragi");
		eot("91.0 Azusa Miura");
		eot("105.0 Shizuku Oikawa");
	}

	public void test008() {
		piw.println("91.0 $A$z$u$s$a Miura");
		piw.println("72.0 #C#h#i#h#a#y#a Kisaragi");
		piw.println("105.0 %S%h%i%z%u%k%u Oikawa");
		piw.close();
		exe("sort -d +1", 0);
		eot("91.0 $A$z$u$s$a Miura");
		eot("72.0 #C#h#i#h#a#y#a Kisaragi");
		eot("105.0 %S%h%i%z%u%k%u Oikawa");
	}

	public void test009() {
		piw.println("72.0 CHIHAYA Kisaragi");
		piw.println("91.0 azusa Miura");
		piw.println("105.0 Shizuku Oikawa");
		piw.close();
		exe("sort -f +1", 0);
		eot("91.0 azusa Miura");
		eot("72.0 CHIHAYA Kisaragi");
		eot("105.0 Shizuku Oikawa");
	}

	public void test010() {
		piw.println("105.0 しずくShizuku Oikawa");
		piw.println("91.0 あずさAzusa Miura");
		piw.println("72.0 ちはやChihaya Kisaragi");
		piw.close();
		exe("sort -i +1", 0);
		eot("91.0 あずさAzusa Miura");
		eot("72.0 ちはやChihaya Kisaragi");
		eot("105.0 しずくShizuku Oikawa");
	}

	public void test011() {
		piw.println("72.0 Chihaya Kisaragi");
		piw.println("105.0 Shizuku Oikawa");
		piw.println("91.0 Azusa Miura");
		piw.close();
		exe("sort -r", 0);
		eot("91.0 Azusa Miura");
		eot("72.0 Chihaya Kisaragi");
		eot("105.0 Shizuku Oikawa");
	}

	public void test012() {
		piw.println("72.0 Chihaya Kisaragi");
		piw.println("105.0 Shizuku Oikawa");
		piw.println("91.0 Azusa Miura");
		piw.close();
		exe("sort -rn", 0);
		eot("105.0 Shizuku Oikawa");
		eot("91.0 Azusa Miura");
		eot("72.0 Chihaya Kisaragi");
	}

	public void test013() {
		piw.println("91.0,Azusa,Miura");
		piw.println("105.0,Shizuku,Oikawa");
		piw.println("72.0,Chihaya,Kisaragi");
		piw.close();
		exe("sort -t, -k 2", 0);
		eot("91.0,Azusa,Miura");
		eot("72.0,Chihaya,Kisaragi");
		eot("105.0,Shizuku,Oikawa");
	}

	public void test014() {
		piw.println("91.0,Azusa,Miura");
		piw.println("72.0,Chihaya,Kisaragi");
		piw.println("105.0,Shizuku,Oikawa");
		piw.println("91.0,Azusa,Miura");
		piw.println("72.0,Chihaya,Kisaragi");
		piw.println("105.0,Shizuku,Oikawa");
		piw.println("91.0,Azusa,Miura");
		piw.println("72.0,Chihaya,Kisaragi");
		piw.println("105.0,Shizuku,Oikawa");
		piw.close();
		exe("sort -u", 0);
		eot("105.0,Shizuku,Oikawa");
		eot("72.0,Chihaya,Kisaragi");
		eot("91.0,Azusa,Miura");
	}

	public void test015() {
		piw.println("80.0 Mio Kisaragi");
		piw.println("91.0 Azusa Miura");
		piw.println("72.0 Chihaya Kisaragi");
		piw.println("105.0 Shizuku Oikawa");
		piw.close();
		exe("sort +2 -3 +1 -2", 0);
		eot("72.0 Chihaya Kisaragi");
		eot("80.0 Mio Kisaragi");
		eot("91.0 Azusa Miura");
		eot("105.0 Shizuku Oikawa");
	}

	public void test016() {
		piw.println("80.0 Mio Kisaragi");
		piw.println("91.0 Azusa Miura");
		piw.println("72.0 Chihaya Kisaragi");
		piw.println("105.0 Shizuku Oikawa");
		piw.close();
		exe("sort -k3,3 -k2,2", 0);
		eot("72.0 Chihaya Kisaragi");
		eot("80.0 Mio Kisaragi");
		eot("91.0 Azusa Miura");
		eot("105.0 Shizuku Oikawa");
	}

	public void test017() {
		piw.println("91.0 Azusa Miura");
		piw.println("72.0 Chihaya Kisaragi");
		piw.println("72.0 Michiru");
		piw.println("105.0 Shizuku Oikawa");
		piw.close();
		exe("sort -k3", 0);
		eot("72.0 Michiru");
		eot("72.0 Chihaya Kisaragi");
		eot("91.0 Azusa Miura");
		eot("105.0 Shizuku Oikawa");
	}

	public void test018() {
		piw.println("105.0,Shizuku,Oikawa");
		piw.println("72.0,Chihaya,Kisaragi");
		piw.println("91.0,Azusa,Miura");
		piw.close();
		exe("sort -c", 0);
	}

	public void test019() {
		piw.println("72.0,Chihaya,Kisaragi");
		piw.println("91.0,Azusa,Miura");
		piw.println("105.0,Shizuku,Oikawa");
		piw.close();
		exe("sort -c", 1);
	}

	public void test020() {
		piw.println("72.0,Chihaya,Kisaragi");
		piw.println("91.0,Azusa,Miura");
		piw.println("105.0,Shizuku,Oikawa");
		piw.close();
		exe("sort -cn", 0);
	}

	public void test021() {
		piw.println("105.0,Shizuku,Oikawa");
		piw.println("72.0,Chihaya,Kisaragi");
		piw.println("91.0,Azusa,Miura");
		piw.close();
		exe("sort -cn", 1);
	}

	public void test022() {
		piw.println("105.0 Shizuku Oikawa");
		piw.println("72.0 Chihaya Kisaragi");
		piw.println("91.0 Azusa Miura");
		piw.println("80.0 Azuki Momoi");
		piw.close();
		exe("sort -k2.3", 0);
		eot("91.0 Azusa Miura");
		eot("80.0 Azuki Momoi");
		eot("72.0 Chihaya Kisaragi");
		eot("105.0 Shizuku Oikawa");
	}

	public void test023() {
		piw.println("105.0 Shizuku Oikawa");
		piw.println("72.0 Chihaya Kisaragi");
		piw.println("91.0 Azusa Miura");
		piw.println("80.0 Azuki Momoi");
		piw.close();
		exe("sort +1.3", 0);
		eot("91.0 Azusa Miura");
		eot("80.0 Azuki Momoi");
		eot("72.0 Chihaya Kisaragi");
		eot("105.0 Shizuku Oikawa");
	}

	public void test024() {
		piw.println("91.0 Azusa Miura");
		piw.println("72.0 Chihaya Kisaragi");
		piw.println("105.0 Shizuku Oikawa");
		piw.close();
		exe("sort -", 0);
		eot("105.0 Shizuku Oikawa");
		eot("72.0 Chihaya Kisaragi");
		eot("91.0 Azusa Miura");
	}

	public void test025() {
		piw.println("91.0 Azusa Miura");
		piw.println("72.0 Chihaya Kisaragi");
		piw.println("105.0 Shizuku Oikawa");
		piw.close();
		exe("sort -- -", 0);
		eot("105.0 Shizuku Oikawa");
		eot("72.0 Chihaya Kisaragi");
		eot("91.0 Azusa Miura");
	}

	public void test026() {
		piw.close();
		exe("sort sort1.txt", 0);
		eot("aaa");
		eot("bbb");
		eot("eee");
	}

	public void test027() {
		piw.close();
		exe("sort sort1.txt sort2.txt", 0);
		eot("aaa");
		eot("bbb");
		eot("bbb");
		eot("ccc");
		eot("ddd");
		eot("eee");
	}

	public void test028() {
		piw.close();
		exe("sort -m sortm1.txt sortm2.txt", 0);
		eot("aaa");
		eot("bbb");
		eot("bbb");
		eot("ccc");
		eot("ddd");
		eot("eee");
	}

	public void testI001() {
		redef(qiw, "EUC-JP");
		redef(qor, "EUC-JP");
		rev.bind("LANG", "ja_JP.EUC-JP");
		piw.println("ｖｖｖｖ");
		piw.println("ｂｂｂｂ");
		piw.close();
		exc("sort", 0);
		eot("ｂｂｂｂ");
		eot("ｖｖｖｖ");
		eot();
	}

}
