/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.builtin;

import net.morilib.sh.ShCommandExecuteTest;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/06/10
 */
public class ShDiffTest extends ShCommandExecuteTest {

	public void test001() {
		piw.println("aaa");
		piw.println("eee");
		piw.println(".");
		piw.println("aaa");
		piw.println("ddd");
		piw.println("ggg");
		piw.println("eee");
		piw.close();
		exe("diff --haruka=.", 0);
		eot("1a2,3");
		eot("> ddd");
		eot("> ggg");
		eot();
	}

	public void test002() {
		piw.println("aaa");
		piw.println("bbb");
		piw.println("eee");
		piw.println(".");
		piw.println("aaa");
		piw.println("ddd");
		piw.println("ggg");
		piw.println("eee");
		piw.close();
		exe("diff --haruka=.", 0);
		eot("2c2,3");
		eot("< bbb");
		eot("---");
		eot("> ddd");
		eot("> ggg");
		eot();
	}

	public void test003() {
		piw.println("aaa");
		piw.println("ddd");
		piw.println("ggg");
		piw.println("eee");
		piw.println(".");
		piw.println("aaa");
		piw.println("eee");
		piw.close();
		exe("diff --haruka=.", 0);
		eot("2,3d1");
		eot("< ddd");
		eot("< ggg");
		eot();
	}

	public void test004() {
		piw.println("aaa");
		piw.println("bbb");
		piw.println("eee");
		piw.println("bbb");
		piw.println(".");
		piw.println("aaa");
		piw.println("ddd");
		piw.println("ggg");
		piw.println("eee");
		piw.close();
		exe("diff --haruka=.", 0);
		eot("2c2,3");
		eot("< bbb");
		eot("---");
		eot("> ddd");
		eot("> ggg");
		eot("4d4");
		eot("< bbb");
		eot();
	}

	public void test005() {
		piw.println("aaa");
		piw.println("bbb");
		piw.println("eee");
		piw.println("bbb");
		piw.println("eee");
		piw.println("bbb");
		piw.println(".");
		piw.println("aaa");
		piw.println("eee");
		piw.println("ddd");
		piw.println("ggg");
		piw.println("eee");
		piw.println("ggg");
		piw.close();
		exe("diff --haruka=.", 0);
		eot("2d1");
		eot("< bbb");
		eot("4c3,4");
		eot("< bbb");
		eot("---");
		eot("> ddd");
		eot("> ggg");
		eot("6c6");
		eot("< bbb");
		eot("---");
		eot("> ggg");
		eot();
	}

	public void test006() {
		piw.println("aaa");
		piw.println("bbb");
		piw.println("bbb");
		piw.println("eee");
		piw.println("bbb");
		piw.println("eee");
		piw.println("bbb");
		piw.println(".");
		piw.println("aaa");
		piw.println("eee");
		piw.println("ddd");
		piw.println("ggg");
		piw.println("eee");
		piw.close();
		exe("diff --haruka=.", 0);
		eot("2,3d1");
		eot("< bbb");
		eot("< bbb");
		eot("5c3,4");
		eot("< bbb");
		eot("---");
		eot("> ddd");
		eot("> ggg");
		eot("7d5");
		eot("< bbb");
		eot();
	}

	public void test007() {
		piw.println("aaa");
		piw.println("bbb");
		piw.println("eee");
		piw.println("bbb");
		piw.println("eee");
		piw.println(".");
		piw.println("aaa");
		piw.println("eee");
		piw.println("ddd");
		piw.println("ggg");
		piw.println("eee");
		piw.println("ggg");
		piw.close();
		exe("diff --haruka=.", 0);
		eot("2d1");
		eot("< bbb");
		eot("4c3,4");
		eot("< bbb");
		eot("---");
		eot("> ddd");
		eot("> ggg");
		eot("5a6");
		eot("> ggg");
		eot();
	}

}
